/*
 * File:		wrld_dlg.h
 * Purpose:		general dialogs for world detailing
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: wrld_dlg.h,v $ $Revision: 1.3 $ $Author: man $ $Date: 2003/05/04 17:17:47 $" */

#ifndef WRLD_DLG_H
#define WRLD_DLG_H

#include "t_dlg.h"
#include "t_code.h"
#include "detail.h"

#define MAX_UWP_CHOICES		8

// ====================================================
class ChoiceItem : public wxObject
{
public:
	ChoiceItem(int n, BaseOrbit *bo);
	~ChoiceItem() {};

	int			ndx;
	BaseOrbit	*orb;
};

class ChoiceList : public wxList
{
public:
	ChoiceList() : wxList() {};
	~ChoiceList();

private:
};

// ----------------------------------------------------
class ChoiceDialog : public StdDialog
{
public:
	ChoiceDialog(wxWindow *p);
	~ChoiceDialog() {};

	bool GetWorldChoice(System *s, int *ndx);
	bool GetSatChoice(WorldOrbit *wo, int *ndx);

//	DECLARE_EVENT_TABLE()

private:
	wxListBox	*sel;

	ChoiceList	*list;
	
	bool Eval(int *ndx);
};

// ====================================================
// ----------------------------------------------------
// ----------------------------------------------------
class TweakDialog : public StdDialog
{
public:
	TweakDialog(wxWindow *p);
	~TweakDialog() {};
	
	bool GetValues(float *rot_period, bool *alb, float *alb_adj,
				bool *grn, float *grn_adj);

	void Update(wxCommandEvent &event);

	DECLARE_EVENT_TABLE()

private:
	void Reflect(void);

	wxTextCtrl			*rot_per;
	wxCheckBox			*alb_cb;
	wxTextCtrl			*alb_val;
	wxCheckBox			*grn_cb;
	wxTextCtrl			*grn_val;

};

#endif

