/*
 * File:		enc_dlg.cpp
 * Purpose:		get animal encounter params from user
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.	
 */

/* rcsid[] = "$RCSfile: wrld_dlg.cpp,v $ $Revision: 1.5 $ $Author: man $ $Date: 2003/05/05 03:28:11 $" */

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include "wrld_dlg.h"
#include "str_util.h"


// ======================================================================
ChoiceItem::ChoiceItem(int n, BaseOrbit *bo) :
	wxObject()
{
	ndx = n;
	orb = bo;
}

ChoiceList::~ChoiceList()
{
wxNode *n;
ChoiceItem *ci;

	n = First();
	while(n != NULL)
		{
		ci = (ChoiceItem *)n->Data();
		delete ci;
		delete n;
		n = First();
		}
}


// ----------------------------------------------------------------------
ChoiceDialog::ChoiceDialog(wxWindow *p) :
	StdDialog(p, "delete this")
{
wxBoxSizer *bs;

	sel = new wxListBox(this, -1,
			wxPoint(-1, -1),
			wxSize(5 * COL_OFFSET, (7 * ROW_OFFSET)),
			0, NULL);

	bs = new wxBoxSizer(wxVERTICAL);
	bs->Add(sel, 0, wxALL, DLG_OFFSET);
	DoLayout(wxALL, DLG_OFFSET, bs);
}

bool
ChoiceDialog::GetSatChoice(WorldOrbit *wo, int *ndx)
{
char buff[120];
int i=0;
SatOrbit *so;
ChoiceItem *ci;

	SetTitle("Select Satillite");
	sel->Clear();

	list = new ChoiceList();
	while((so = wo->GetSat(i)) != NULL)
		{
		ci = new ChoiceItem(i, so);
		list->Append(ci);
		sel->Append(so->FormatName(buff, -1));
		i++;
		}
	
	return(Eval(ndx));
}

bool
ChoiceDialog::GetWorldChoice(System *s, int *ndx)
{
char buff[120];
int i=0;
BaseOrbit *bo;
ChoiceItem *ci;

	SetTitle("Select World");
	sel->Clear();

	list = new ChoiceList();
	while((bo = s->GetIndexedOrbit(i)) != NULL)
		{
		if(bo->GetOrbType() & ORBIT_IS_WORLD)
			{
			ci = new ChoiceItem(i, bo);
			list->Append(ci);
			sel->Append(bo->FormatName(buff, -1));
			}

		i++;
		}

	return(Eval(ndx));
}

bool
ChoiceDialog::Eval(int *ndx)
{
int i;
wxNode *n;
ChoiceItem *ci;

	if(wxID_CANCEL == ShowModal())
		{
		delete list;
		return(FALSE);
		}

	i = sel->GetSelection();
	if(i < 0) i = 0;
	n = list->Nth(sel->GetSelection());
	ci = (ChoiceItem *)n->Data();
	*ndx = ci->ndx;

	delete list;

	return(TRUE);
}


// ======================================================================
#define ID_CB		700
BEGIN_EVENT_TABLE(TweakDialog, wxDialog)
	EVT_CHECKBOX(ID_CB, TweakDialog::Update)
END_EVENT_TABLE()

// ----------------------------------------------------------------------
TweakDialog::TweakDialog(wxWindow *p) :
	StdDialog(p, "Adjust Values")
{
wxStaticText *msg;
wxBoxSizer *bs;
wxFlexGridSizer *gs;

	alb_cb = new wxCheckBox(this, ID_CB, "Albedo Terraforming:");
	alb_val = new wxTextCtrl(this, -1, "XXXXXXX", 
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, -1));
			
	grn_cb = new wxCheckBox(this, ID_CB, "Greenhouse Terraforming:");
	grn_val = new wxTextCtrl(this, -1, "XXXXXXX", 
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, -1));
			
	msg = new wxStaticText(this, -1,     "Rotational Period (hrs):");
	rot_per = new wxTextCtrl(this, -1, "XXXXXXX", 
			wxPoint(-1, -1),
			wxSize(COL_OFFSET * 2, -1));
	
	bs = new wxBoxSizer(wxVERTICAL);
	gs = new wxFlexGridSizer(2, 0, 0);
	
	gs->Add(alb_cb, 0, wxALL | wxALIGN_BOTTOM, DLG_OFFSET / 2);
	gs->Add(alb_val, 0, wxALL, DLG_OFFSET / 2);
	gs->Add(grn_cb, 0, wxALL | wxALIGN_BOTTOM, DLG_OFFSET / 2);
	gs->Add(grn_val, 0, wxALL, DLG_OFFSET / 2);
	gs->Add(msg, 0, wxALL | wxALIGN_BOTTOM, DLG_OFFSET / 2);
	gs->Add(rot_per, 0, wxALL, DLG_OFFSET / 2);
	bs->Add(gs, 0, wxALL, DLG_OFFSET);
	DoLayout(wxALL, DLG_OFFSET, bs);
}

bool
TweakDialog::GetValues(float *rot, bool *alb, float *alb_adj,
			bool *grn, float *grn_adj)
{
char buff[20],*ptr;

	sprintf(buff, "%f", *rot);
	rot_per->SetValue(buff);
	alb_cb->SetValue(*alb);
	sprintf(buff, "%f", *alb_adj);
	alb_val->SetValue(buff);
	grn_cb->SetValue(*grn);
	sprintf(buff, "%f", *grn_adj);
	grn_val->SetValue(buff);

	Reflect();
	if(wxID_CANCEL == ShowModal())
		return(FALSE);

	ptr = (char *)rot_per->GetValue().GetData();
	*rot = atof(ptr);
	*alb = alb_cb->GetValue();
	ptr = (char *)alb_val->GetValue().GetData();
	*alb_adj = atof(ptr);
	*grn = grn_cb->GetValue();
	ptr = (char *)grn_val->GetValue().GetData();
	*grn_adj = atof(ptr);

	return(TRUE);
}

void
TweakDialog::Update(wxCommandEvent& event)
{
	Reflect();
}

void
TweakDialog::Reflect(void)
{
	if(alb_cb->GetValue())
		alb_val->Enable(TRUE);
	else
		alb_val->Enable(FALSE);

	if(grn_cb->GetValue())
		grn_val->Enable(TRUE);
	else
		grn_val->Enable(FALSE);
}

