/*
 * File:    world.h
 * Purpose:	
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: world.h,v $ $Revision: 1.3 $ $Author: man $ $Date: 2000/09/05 03:21:27 $" */

#ifndef WORLD_H
#define WORLD_H

#include "wx/timer.h"
#include "wx/print.h"
#include "t_frame.h"
#include "t_dice.h"
#include "wrld_dlg.h"
#include "detail.h"

// ====================================================
// Define a new application
class WorldApp: public wxApp
{
public:
//    WorldApp(void) ;
//    wxFrame *OnInit(void);
    bool OnInit(void);

private:
};

// ========================================================================
//  gui stuff
class WorldPanel : public wxPanel
{
public:
	WorldPanel(wxWindow *frame, int x=-1, int y=-1, int w=-1, int h=-1);
	~WorldPanel();
};

// ========================================================================
// display (print) handler
class WorldDisplay : public DisplayMethod
{
public:
	WorldDisplay(wxDC *d, int x=0, int y=0, int len=-1) :
		DisplayMethod(d, x, y, len) {};
	WorldDisplay(FILE *fpx, int len=-1) : DisplayMethod(fpx) {};
	~WorldDisplay();

	int DrawDetail(Detail *d,
			char *msg1=NULL, char *msg2=NULL,
			int start_count=0, int total_count=32000);

private:
	int DrawSystem(Detail *d, int cur_count, int start_count, int total_count);
	int DrawParent(Detail *d, int cur_count, int start_count, int total_count);
	int DrawDetail(Detail *d, int cur_count, int start_count, int total_count);

	int DrawOrbit(OrbitInfo *orb, 
					int *cur_count, int start_count, int total_count);

	int DrawGGSize(GGSize *gs, 
					int *cur_count, int start_count, int total_count);
	int DrawBeltSize(BeltSize *gs, 
					int *cur_count, int start_count, int total_count);
	int DrawWorldSize(WorldSize *gs, 
					int *cur_count, int start_count, int total_count);
	int DrawSatSize(SatSize *gs, 
					int *cur_count, int start_count, int total_count);
	int DrawGenSize(WorldSize *ws, 
					int *cur_count, int start_count, int total_count);
	int DrawAtmos(Atmos *atm, 
					int *cur_count, int start_count, int total_count);
	int DrawTemp(Temp *t, bool full_flag,
					int *cur_count, int start_count, int total_count);
	int DrawTerr(int *cur_count, int start_count, int total_count,
					char *msg, int terr, int dm);
	int DrawTempW(Atmos *atm, float rot,
					int *cur_count, int start_count, int total_count);
	int DrawHydro(Hydro *hyd, 
					int *cur_count, int start_count, int total_count);
	int DrawResources(Resources *res, 
					int *cur_count, int start_count, int total_count);
	int DrawSocial(SocialData *sd, 
					int *cur_count, int start_count, int total_count);
	int DrawCities(SocialData *sd, 
					int *cur_count, int start_count, int total_count);
	int DrawCustoms(SocialData *sd, 
					int *cur_count, int start_count, int total_count);
	int DrawGovt(Govt *govt, 
					int *cur_count, int start_count, int total_count);
	int DrawLaw(Law *law, 
					int *cur_count, int start_count, int total_count);
	int DrawTech(Tech *tech, 
					int *cur_count, int start_count, int total_count);

	int DrawLine(int *cur_count, int start_count, int total_count,
					char *format...);
};

// ====================================================
// print out
class PrintOut : public wxPrintout
{
public:
	PrintOut(Detail *d);
	~PrintOut() {};

	bool OnPrintPage(int page);
	bool HasPage(int page);
	void GetPageInfo(int *minPage, int *maxPage,
					 int *selPageFrom, int *selPageTo);

private:
	int				page_max;
};

// ========================================================================
// general canvas
class WorldCanvas : public wxScrolledWindow
{
public:
    WorldCanvas(wxWindow *frame, int x=-1, int y=-1, int w=-1, int h=-1,
				 long style = wxRETAINED);
	~WorldCanvas() {};

	void OnDraw(wxDC& dc);
	
};

// ========================================================================
#if 0
class BaseFrame : public wxFrame
{
friend class QuietFrame;
friend class WorldFrame;
public:
//	BaseFrame(struct conf_struct *c, char *cfg_ptr, int w, int h);
	BaseFrame(char *cfg_ptr, int w, int h);
	~BaseFrame();

	bool OnCLose(void) { return(TRUE); };

	System *GetSys(void) { return(sys); };
	Detail *GetDetail(void) { return(detail); };

private:
	void CleanUp(void);

	System *sys;
	Detail *detail;
};
#endif
// ----------------------------------------------------
//class WorldFrame : public BaseFrame
class WorldFrame : public wxFrame
{
public:
//    WorldFrame(struct conf_struct *c, char *cfg_ptr);
    WorldFrame(char *cfg_ptr);
    ~WorldFrame();

	// command line calls
	void LoadSystem(char *fname);
	void Generate(int ndx);

//	bool OnClose(void) { return(TRUE); };
	
//    void OnSize(wxSizeEvent& event);

	void DoMenu(int ndx);
	
	void Draw(wxDC *dc);

//	bool OnCLose(void) { return(TRUE); };

	void InitButtons(wxToolBar *tb);

	System *GetSys(void) { return(sys); };
	Detail *GetDetail(void) { return(detail); };

	DECLARE_EVENT_TABLE()

private:
	void OnToolEnter(wxCommandEvent& event);

	void Open(wxCommandEvent& event);
	void Config(wxCommandEvent& event);
	void GenWorld(wxCommandEvent& event);
	void GenSat(wxCommandEvent& event);
	void Regen(wxCommandEvent& event);
	void Tweak(wxCommandEvent& event);
	void Save(wxCommandEvent& event);
	void Print(wxCommandEvent& event);
	void Exit(wxCommandEvent& event);
	void OnAbout(wxCommandEvent& event);

	void UpdateStatus(void);

	WorldCanvas			*canvas;

	ChoiceDialog		*choice;
	TweakDialog			*tweak_dlg;

	TCodes *codes;
	System *sys;
	Detail *detail;
};

#endif
