/*
 * File:      	sectmerge.c
 * Purpose:   	pick-n-choose fields from 2 sector files
 * Author:		Mark A. Nordstrand
 * Created:	
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: sectmerge.c,v $ $Revision: 1.3 $ $Author: man $ $Date: 2002/06/05 04:51:07 $" */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "str_util.h"
#include "sect_text.h"

int 
merge_sectors(struct TMP_STRUCT *s1, TMP_STRUCT *s2, TMP_STRUCT *s_new,
				unsigned int mask)
{
int x,y;

	for(x = 0;x < MAX_X;x++) {
		for(y = 0;y < MAX_Y;y++) {
			/* both empty? */
			if((s1->data[x][y].present < 1) && (s2->data[x][y].present < 1)) {
				continue;
			}
			/* only in first file? */
			if((s1->data[x][y].present > 0) && (s2->data[x][y].present < 1)) {
				fprintf(stderr, "Warning: %s only present in first file\n",
						s1->data[x][y].hex);
				strcpy(s_new->data[x][y].name, s1->data[x][y].name);
				strcpy(s_new->data[x][y].hex, s1->data[x][y].hex);
				strcpy(s_new->data[x][y].uwp, s1->data[x][y].uwp);
				strcpy(s_new->data[x][y].bases, s1->data[x][y].bases);
				strcpy(s_new->data[x][y].codes, s1->data[x][y].codes);
				strcpy(s_new->data[x][y].zone, s1->data[x][y].zone);
				strcpy(s_new->data[x][y].pbg, s1->data[x][y].pbg);
				strcpy(s_new->data[x][y].alleg, s1->data[x][y].alleg);
				strcpy(s_new->data[x][y].stars, s1->data[x][y].stars);
			/* only in second file? */
			} else if((s1->data[x][y].present < 1) && (s2->data[x][y].present > 0)) {
				fprintf(stderr, "Warning: %s only present in second file\n",
						s2->data[x][y].hex);
				strcpy(s_new->data[x][y].name, s2->data[x][y].name);
				strcpy(s_new->data[x][y].hex, s2->data[x][y].hex);
				strcpy(s_new->data[x][y].uwp, s2->data[x][y].uwp);
				strcpy(s_new->data[x][y].bases, s2->data[x][y].bases);
				strcpy(s_new->data[x][y].codes, s2->data[x][y].codes);
				strcpy(s_new->data[x][y].zone, s2->data[x][y].zone);
				strcpy(s_new->data[x][y].pbg, s2->data[x][y].pbg);
				strcpy(s_new->data[x][y].alleg, s2->data[x][y].alleg);
				strcpy(s_new->data[x][y].stars, s2->data[x][y].stars);
			/* in both files? */
			} else {
				if(strcmp(s1->data[x][y].uwp, s2->data[x][y].uwp) != 0)
					fprintf(stderr, 
						"Warning: UWP's differ at %s (%s) (%s)\n",
						s1->data[x][y].hex,
						s1->data[x][y].uwp, s2->data[x][y].uwp);

				if(mask & 0x001)
					strcpy(s_new->data[x][y].name, s2->data[x][y].name);
				else
					strcpy(s_new->data[x][y].name, s1->data[x][y].name);

				if(mask & 0x002)
					strcpy(s_new->data[x][y].hex, s2->data[x][y].hex);
				else
					strcpy(s_new->data[x][y].hex, s1->data[x][y].hex);
				
				if(mask & 0x004)
					strcpy(s_new->data[x][y].uwp, s2->data[x][y].uwp);
				else
					strcpy(s_new->data[x][y].uwp, s1->data[x][y].uwp);
				
				if(mask & 0x008) {
					s_new->data[x][y].bases[0] = s2->data[x][y].bases[0];
				} else {
					s_new->data[x][y].bases[0] = s1->data[x][y].bases[0];
				}
				s_new->data[x][y].bases[1] = 0;
				
				if(mask & 0x010)
					strcpy(s_new->data[x][y].codes, s2->data[x][y].codes);
				else
					strcpy(s_new->data[x][y].codes, s1->data[x][y].codes);
				
				if(mask & 0x020) {
					s_new->data[x][y].zone[0] = s2->data[x][y].zone[0];
				} else {
					s_new->data[x][y].zone[0] = s1->data[x][y].zone[0];
				}
				s_new->data[x][y].zone[1] = 0;
				
				if(mask & 0x040)
					strcpy(s_new->data[x][y].pbg, s2->data[x][y].pbg);
				else
					strcpy(s_new->data[x][y].pbg, s1->data[x][y].pbg);
				
				if(mask & 0x080)
					strcpy(s_new->data[x][y].alleg, s2->data[x][y].alleg);
				else
					strcpy(s_new->data[x][y].alleg, s1->data[x][y].alleg);
			
				if(mask & 0x100)
					strcpy(s_new->data[x][y].stars, s2->data[x][y].stars);
				else
					strcpy(s_new->data[x][y].stars, s1->data[x][y].stars);
			}

			s_new->data[x][y].present = 1;
		}
	}

	return(TRUE);
}

int 
main(int argc, char *argv[])
{
int err=0,opt,num_input=0;
unsigned int mask=0;
struct TMP_STRUCT s1,s2,sout;
FILE *fout=NULL;

	if(argc < 3)
		err = 1;
	else {
		memset((void *) &sout, 0, sizeof(struct TMP_STRUCT));
		do {
			opt = getopt(argc, argv, "f:o:hnlubtzpas");
			switch(opt) {
				case '?':
				case 'h':
					err = 1;
					break;
				case 'f':
					if(0 == num_input) {
						if(!get_sector(optarg, &s1))
							err = 2;
						num_input++;
					} else if(1 == num_input) {
						if(!get_sector(optarg, &s2))
							err = 3;
						num_input++;
					} else
						err = 4;
					break;
				case 'o':
					if((fout = fopen(optarg, "w")) == NULL)
						err = 4;
					break;
				case 'n':
					mask |= 0x001;
					break;
				case 'l':
					mask |= 0x002;
					break;
				case 'u':
					mask |= 0x004;
					break;
				case 'b':
					mask |= 0x008;
					break;
				case 't':
					mask |= 0x010;
					break;
				case 'z':
					mask |= 0x020;
					break;
				case 'p':
					mask |= 0x040;
					break;
				case 'a':
					mask |= 0x080;
					break;
				case 's':
					mask |= 0x100;
					break;
			}
		} while (opt > 0);
	}
	
	if(num_input != 2)
		err = 7;

	if(0 == err) {
		if(NULL == fout)
			fout = stdout;
		if(!merge_sectors(&s1, &s2, &sout, mask))
			err = 5;
		else {
			if(!write_sector(fout, &sout))
				err = 6;
		}
	}

	if(err) {
		fprintf(stderr, "%s: Merges 2 sector files.\n", argv[0]);
		fprintf(stderr, "\nUsage:\n");
		fprintf(stderr, 
			"%s [-nlubtzpas] -f<input file 1> -f <input file 2> [-o<output file>]\n", 
			argv[0]);
		fprintf(stderr, "\nWhere:\n");
		fprintf(stderr, "  -f<input file n> input sector file\n");
		fprintf(stderr, "  -o<output file> optional output sector file\n");
		fprintf(stderr, "  -n select name from second file\n");
		fprintf(stderr, "  -l select location from second file\n");
		fprintf(stderr, "  -u select UWP from second file\n");
		fprintf(stderr, "  -b select base from second file\n");
		fprintf(stderr, "  -t select trade from second file\n");
		fprintf(stderr, "  -z select zone from second file\n");
		fprintf(stderr, "  -p select pbg from second file\n");
		fprintf(stderr, "  -a select allegiance from second file\n");
		fprintf(stderr, "  -s select stellar data from second file\n");
		fprintf(stderr, "  -h prints this message\n\n");
		fprintf(stderr, "The default behavior is take everything from file 1,\n");
		fprintf(stderr, "and to use standard out for no output file.\n");
	}

	return(err);
}

