/*
 * File:      	ht.cpp
 * Purpose:   	generate hart times and collapse data
 * Author:		Mark A. Nordstrand
 * Created:	
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: ht.cpp,v $ $Revision: 1.3 $ $Author: man $ $Date: 2002/06/05 04:51:07 $" */


// special note:
//   this is really crappy code.......

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include "wx/image.h"
#include "wx/listctrl.h"
#include "wx/sizer.h"
#include "wx/log.h"
#include <stdio.h>
#include "t_help.h"

#if defined(__WXGTK__) || defined(__WXMOTIF__)
#include "mondrian.xpm"
#endif

#define MAX_X		32
#define MAX_Y		40
#define DEFAULT_A	'S'
#define DEFAULT_W	'P'
#define WAR_NDX		0
#define AREA_NDX	1
#define BTN_BASE	200

// derived classes

class MyFrame;
class MyApp;

// MyCanvas

class MyCanvas: public wxScrolledWindow
{
public:
    MyCanvas() {};
    MyCanvas( wxWindow *parent, wxWindowID, const wxPoint &pos, const wxSize &size );
    ~MyCanvas();
#if 0
    void OnPaint( wxPaintEvent &event );
    void OnQueryPosition( wxCommandEvent &event );
    void OnAddButton( wxCommandEvent &event );
    void OnDeleteButton( wxCommandEvent &event );
    void OnMoveButton( wxCommandEvent &event );
    void OnScrollWin( wxCommandEvent &event );
    void OnMouseDown( wxMouseEvent &event );
    void OnScroll( wxScrollWinEvent &event );

    wxButton *m_button;
#endif

    void OnButton(wxCommandEvent &event );

    void OnSafe(void);
    void OnFrontier(void);
    void OnOutlands(void);
    void OnWilds(void);
    void OnPeace(void);
    void OnWar(void);
    void OnIntense(void);
    void OnBlack(void);

	void SetData(bool war, char c);
	void UpdateButtons(void);
	void UpdateButton(int x, int y);

	void UpdateButtonColor(int x, int y);
	void UpdateButtonColors(void);

	wxButton		*btn[MAX_X][MAX_Y];
	char			states[2][MAX_X][MAX_Y];
	bool			war_mode;

    DECLARE_DYNAMIC_CLASS(MyCanvas)
    DECLARE_EVENT_TABLE()
};

// MyFrame

class MyFrame: public wxFrame
{
public:
    MyFrame();

    void OnAbout(wxCommandEvent &event);
    void OnQuit(wxCommandEvent &event);

    void OnSave(wxCommandEvent &event);
    void OnAreaMode(wxCommandEvent &event);
    void OnWarMode(wxCommandEvent &event);
    void OnSafe(wxCommandEvent &event);
    void OnFrontier(wxCommandEvent &event);
    void OnOutlands(wxCommandEvent &event);
    void OnWilds(wxCommandEvent &event);
    void OnPeace(wxCommandEvent &event);
    void OnWar(wxCommandEvent &event);
    void OnIntense(wxCommandEvent &event);
    void OnBlack(wxCommandEvent &event);

	void UpdateStatus(void);


    MyCanvas         *m_canvas;
    wxTextCtrl       *m_log;

    DECLARE_DYNAMIC_CLASS(MyFrame)
    DECLARE_EVENT_TABLE()
};

// MyApp

class MyApp: public wxApp
{
public:
    virtual bool OnInit();
};

// main program

IMPLEMENT_APP(MyApp)

// ids
enum {
	ID_QUIT = 100,
    ID_ABOUT,
	ID_SAVE,

	ID_AREA_MODE,
	ID_WAR_MODE,

	ID_AREA_SAFE,
	ID_AREA_FRONTIER,
	ID_AREA_OUTLANDS,
	ID_AREA_WILDS,

	ID_WAR_PEACE,
	ID_WAR_WAR,
	ID_WAR_INTENSE,
	ID_WAR_BLACK,

};


// MyCanvas

IMPLEMENT_DYNAMIC_CLASS(MyCanvas, wxScrolledWindow)

BEGIN_EVENT_TABLE(MyCanvas, wxScrolledWindow)
	EVT_BUTTON(BTN_BASE, MyCanvas::OnButton)
END_EVENT_TABLE()

MyCanvas::MyCanvas( wxWindow *parent, wxWindowID id,
                    const wxPoint &pos, const wxSize &size )
        : wxScrolledWindow( parent, id, pos, size, wxSUNKEN_BORDER | wxTAB_TRAVERSAL, "test canvas" )
{
char buffer[24];
int x, y;
wxLayoutConstraints *c;

	for(x = 0;x < MAX_X;x++) {
		for(y = 0;y < MAX_Y;y++) {
			states[AREA_NDX][x][y] = DEFAULT_A;
			states[WAR_NDX][x][y] = DEFAULT_W;
			sprintf(buffer, "%02d%02d %c | %c", x+1, y+1, DEFAULT_A, DEFAULT_W);
			btn[x][y] = new wxButton(this, 
							BTN_BASE,// + (x * 100) + y, 
							buffer);
			UpdateButtonColor(x, y);
			c = new wxLayoutConstraints;
			if((0 == y) && (0 == x)) {
				c->top.SameAs(this, wxTop, 4);
				c->left.SameAs(this, wxLeft, 4);
			} else {
				if(0 == y) {
					if(x & 1)
						c->top.SameAs(this, wxTop, 14);
					else
						c->top.SameAs(this, wxTop, 4);
				} else {
					c->top.SameAs(btn[x][y-1], wxBottom, 4);
				}
				if(0 == x) {
					c->left.SameAs(this, wxLeft, 4);
				} else {
					c->left.SameAs(btn[x-1][y], wxRight, 4);
				}
			}
			c->height.AsIs();
			c->width.AsIs();
			btn[x][y]->SetConstraints(c);
		}
	}
	war_mode = TRUE;

    SetAutoLayout(TRUE);
	Layout();
	Fit();

}

MyCanvas::~MyCanvas()
{
}

void 
MyCanvas::OnButton(wxCommandEvent &event)
{
int x,y,x1=-1,y1=-1;

	for(x = 0;x < MAX_X;x++) {
		for(y = 0;y < MAX_Y;y++) {
			if(event.GetEventObject() == btn[x][y]) {
				x1 = x;
				y1 = y;
				break;
			}
		}
	}

	if(x1 < 0)
		fprintf(stderr, "Strange event.\n");
	else {
		if(war_mode) {
			switch(states[WAR_NDX][x1][y1]) {
				case 'P':
					states[WAR_NDX][x1][y1] = 'W';
					break;
				case 'W':
					states[WAR_NDX][x1][y1] = 'I';
					break;
				case 'I':
					states[WAR_NDX][x1][y1] = 'B';
					break;
				case 'B':
					states[WAR_NDX][x1][y1] = 'P';
					break;
			}
		} else {
			switch(states[AREA_NDX][x1][y1]) {
				case 'S':
					states[AREA_NDX][x1][y1] = 'F';
					break;
				case 'F':
					states[AREA_NDX][x1][y1] = 'O';
					break;
				case 'O':
					states[AREA_NDX][x1][y1] = 'W';
					break;
				case 'W':
					states[AREA_NDX][x1][y1] = 'S';
					break;
			}
		}
		UpdateButton(x1, y1);
	}
}

void 
MyCanvas::OnSafe(void)
{
	SetData(FALSE, 'S');
	UpdateButtons();
}

void 
MyCanvas::OnFrontier(void)
{
	SetData(FALSE, 'F');
	UpdateButtons();
}

void 
MyCanvas::OnOutlands(void)
{
	SetData(FALSE, 'O');
	UpdateButtons();
}

void 
MyCanvas::OnWilds(void)
{
	SetData(FALSE, 'W');
	UpdateButtons();
}

void 
MyCanvas::OnPeace(void)
{
	SetData(TRUE, 'P');
	UpdateButtons();
}

void 
MyCanvas::OnWar(void)
{
	SetData(TRUE, 'W');
	UpdateButtons();
}

void 
MyCanvas::OnIntense(void)
{
	SetData(TRUE, 'I');
	UpdateButtons();
}

void 
MyCanvas::OnBlack(void)
{
	SetData(TRUE, 'B');
	UpdateButtons();
}

void 
MyCanvas::SetData(bool war, char c)
{
int ndx=AREA_NDX;
int x,y;

	if(war)
		ndx = WAR_NDX;

	for(x = 0;x < MAX_X;x++) {
		for(y = 0;y < MAX_Y;y++) {
			states[ndx][x][y] = c;
		}
	}
}

void 
MyCanvas::UpdateButtons(void)
{
int x,y;

	for(x = 0;x < MAX_X;x++) {
		for(y = 0;y < MAX_Y;y++) {
			UpdateButton(x, y);
		}
	}
}

void 
MyCanvas::UpdateButton(int x, int y)
{
char buffer[24];

	sprintf(buffer, "%02d%02d %c | %c", x+1, y+1, 
			states[AREA_NDX][x][y],
			states[WAR_NDX][x][y]);
	btn[x][y]->SetLabel(buffer);
	UpdateButtonColor(x, y);
}

void 
MyCanvas::UpdateButtonColors(void)
{
int x,y;

	for(x = 0;x < MAX_X;x++) {
		for(y = 0;y < MAX_Y;y++) {
			UpdateButtonColor(x, y);
		}
	}
}

void 
MyCanvas::UpdateButtonColor(int x1, int y1)
{
char *ptr = "white";

	if(war_mode) {
		switch(states[WAR_NDX][x1][y1]) {
			case 'P':
				ptr = "white";
				break;
			case 'W':
				ptr = "yellow";
				break;
			case 'I':
				ptr = "orange";
				break;
			case 'B':
				ptr = "red";
				break;
		}
	} else {
		switch(states[AREA_NDX][x1][y1]) {
			case 'S':
				ptr = "white";
				break;
			case 'F':
				ptr = "yellow";
				break;
			case 'O':
				ptr = "orange";
				break;
			case 'W':
				ptr = "red";
				break;
		}
	}

	btn[x1][y1]->SetBackgroundColour(ptr);
}

// ===========================================================================
// MyFrame

IMPLEMENT_DYNAMIC_CLASS( MyFrame, wxFrame )

BEGIN_EVENT_TABLE(MyFrame,wxFrame)
	EVT_MENU(ID_ABOUT, MyFrame::OnAbout)
	EVT_MENU(ID_QUIT, MyFrame::OnQuit)
	EVT_MENU(ID_SAVE, MyFrame::OnSave)
	EVT_MENU(ID_AREA_MODE, MyFrame::OnAreaMode)
	EVT_MENU(ID_WAR_MODE, MyFrame::OnWarMode)
	EVT_MENU(ID_AREA_SAFE, MyFrame::OnSafe)
	EVT_MENU(ID_AREA_FRONTIER, MyFrame::OnFrontier)
	EVT_MENU(ID_AREA_OUTLANDS, MyFrame::OnOutlands)
	EVT_MENU(ID_AREA_WILDS, MyFrame::OnWilds)
	EVT_MENU(ID_WAR_PEACE, MyFrame::OnPeace)
	EVT_MENU(ID_WAR_WAR, MyFrame::OnWar)
	EVT_MENU(ID_WAR_INTENSE , MyFrame::OnIntense)
	EVT_MENU(ID_WAR_BLACK, MyFrame::OnBlack)
END_EVENT_TABLE()

MyFrame::MyFrame()
       : wxFrame( (wxFrame *)NULL, -1, "Hard Times data editor",
                  wxPoint(-1, 1), wxSize(470,500) )
{

    CreateStatusBar(2);
    int widths[] = { -1, 100 };
    SetStatusWidths( 2, widths );

    m_canvas = new MyCanvas( this, -1, wxPoint(0,0), wxSize(100,100) );
    m_canvas->SetScrollbars( 10, 10, 300, 120 );
  
    m_log = new wxTextCtrl( this, -1, "This is the log window.\n", wxPoint(0,0), wxSize(100,100), wxTE_MULTILINE );
    wxLog *old_log = wxLog::SetActiveTarget( new wxLogTextCtrl( m_log ) );
    delete old_log;
    
    wxBoxSizer *topsizer = new wxBoxSizer( wxVERTICAL );
    
    topsizer->Add( m_canvas, 1, wxEXPAND );
    topsizer->Add( m_log, 0, wxEXPAND );

	UpdateStatus();

    SetAutoLayout(TRUE);
    SetSizer(topsizer);
}

void 
MyFrame::OnAbout( wxCommandEvent &WXUNUSED(event) )
{
AboutDialog *dlg;

	dlg = new AboutDialog(this);
	dlg->ShowAbout("Sector Viewer");
	delete dlg;
}

void 
MyFrame::OnSave(wxCommandEvent &event)
{
wxString ptr;
char *name;

	ptr = wxFileSelector("Open data file", NULL, NULL, NULL, 
			"*.ht", wxHIDE_READONLY, this);
	name = (char *)ptr.GetData();
	if(name[0] != 0) {
		int x,y;
		FILE *fp;

		fp = fopen(name, "w");
		for(y = 0;y < MAX_Y;y++) {
			for(x = 0;x < MAX_X;x++) {
				fprintf(fp, "%c", m_canvas->states[AREA_NDX][x][y]);
			}
			fprintf(fp, "\n");
		}
		for(y = 0;y < MAX_Y;y++) {
			for(x = 0;x < MAX_X;x++) {
				fprintf(fp, "%c", m_canvas->states[WAR_NDX][x][y]);
			}
			fprintf(fp, "\n");
		}
		fclose(fp);
	}
}

void 
MyFrame::OnAreaMode(wxCommandEvent &event)
{
	m_canvas->war_mode = FALSE;
	UpdateStatus();
	m_canvas->UpdateButtonColors();
}

void 
MyFrame::OnWarMode(wxCommandEvent &event)
{
	m_canvas->war_mode = TRUE;
	UpdateStatus();
	m_canvas->UpdateButtonColors();
}

void 
MyFrame::OnSafe(wxCommandEvent &event)
{
	m_canvas->OnSafe();
}

void 
MyFrame::OnFrontier(wxCommandEvent &event)
{
	m_canvas->OnFrontier();
}

void 
MyFrame::OnOutlands(wxCommandEvent &event)
{
	m_canvas->OnOutlands();
}

void 
MyFrame::OnWilds(wxCommandEvent &event)
{
	m_canvas->OnWilds();
}

void 
MyFrame::OnPeace(wxCommandEvent &event)
{
	m_canvas->OnPeace();
}

void 
MyFrame::OnWar(wxCommandEvent &event)
{
	m_canvas->OnWar();
}

void 
MyFrame::OnIntense(wxCommandEvent &event)
{
	m_canvas->OnIntense();
}

void 
MyFrame::OnBlack(wxCommandEvent &event)
{
	m_canvas->OnBlack();
}

void 
MyFrame::OnQuit( wxCommandEvent &WXUNUSED(event) )
{
	Close(TRUE);
}

void 
MyFrame::UpdateStatus(void)
{
	if(m_canvas->war_mode)
		SetStatusText("War Mode", 1);
	else
		SetStatusText("Area Mode", 1);
}

//-----------------------------------------------------------------------------
// MyApp
//-----------------------------------------------------------------------------

bool MyApp::OnInit()
{
	wxFrame *frame = new MyFrame();
	// Give it an icon
	frame->SetIcon( wxICON(mondrian) );

	wxMenu *file_menu = new wxMenu("",  wxMENU_TEAROFF);

	file_menu->Append(ID_SAVE, "&Save", "Write file");
    file_menu->AppendSeparator();
	file_menu->Append(ID_ABOUT, "&About", "Information");
    file_menu->AppendSeparator();
    file_menu->Append(ID_QUIT, "E&xit\tAlt-X", "Quit controls sample");

//    file_menu->Append(ID_ABOUT, "&About\tF1");

    wxMenuBar *menu_bar = new wxMenuBar;
    menu_bar->Append(file_menu, "&File");

    wxMenu *mode_menu = new wxMenu;
    mode_menu->Append(ID_AREA_MODE, "&Area Mode", "Set area level");
    mode_menu->Append(ID_WAR_MODE, "&War Mode", "Set war level");
    menu_bar->Append(mode_menu, "&Mode");

    wxMenu *bulk_menu = new wxMenu;
    bulk_menu->Append(ID_AREA_SAFE, "&Safe", "Set all to safe");
    bulk_menu->Append(ID_AREA_FRONTIER, "&Frontier", "Set all to frontier");
    bulk_menu->Append(ID_AREA_OUTLANDS, "&Outlands", "Set all to outlands");
    bulk_menu->Append(ID_AREA_WILDS, "&Wilds", "Set all to wilds");
    bulk_menu->AppendSeparator();
    bulk_menu->Append(ID_WAR_PEACE, "&Peace", "Set all to peace");
    bulk_menu->Append(ID_WAR_WAR, "&War", "Set all to war");
    bulk_menu->Append(ID_WAR_INTENSE, "&Intense", "Set all to intense war");
    bulk_menu->Append(ID_WAR_BLACK, "&Black", "Set all to black war");
    menu_bar->Append(bulk_menu, "&Bulk");

    frame->SetMenuBar(menu_bar);

	frame->Show(TRUE);

	return(TRUE);
}

