/*
 * File:    system.h
 * Purpose:	
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: system.h,v $ $Revision: 1.10 $ $Author: man $ $Date: 2002/03/18 15:34:36 $" */

#ifndef SYSTEM_H
#define SYSTEM_H

#include "wx/splitter.h"
#include "wx/treectrl.h"
#include "wx/confbase.h"
#include "wx/fileconf.h"
#include "syst.h"
#include "t_frame.h"
#include "syst_dlg.h"
#include "mtu_file.h"

// ====================================================
// forward references

// ====================================================

// define the app
class SystemApp: public wxApp
{
public:
	bool OnInit();
	int OnExit(void);
};

// ===========================================================================
class SystemDisplay : public DisplayMethod
{
public:
    SystemDisplay(wxDC *d, int x=0, int y=0, int len=-1) :
	  DisplayMethod(d,x,y) {};
    SystemDisplay(FILE *fpx, int len=-1) : DisplayMethod(fpx) {};
    ~SystemDisplay();

	
// also old (but, useful):
    int DrawDetail(System *, BaseOrbit *);

// new:
	int DrawLines(char *msg1=NULL, char *msg2=NULL,
				  int start_count=0, int end_count=32000);
	int DrawDetails(PRINT_SOURCE ps=PS_ALL, char *msg1=NULL, char *msg2=NULL,
				  int start_count=0, int end_count=32000);
//	int DrawLine(BaseOrbit *, STAR_INDEX st, short pl, short sat);

private:
    void DrawWorldText(bool line, char *msg1, char *msg2, int start_count,
        int end_count, int start_x, int start_y, int end_x, int end_y);

	int DrawSatLine(System *sys, STAR_INDEX st, int pl, int sat, int *count,
								 int start_count, int end_count);
	int DrawWorldLine(System *sys, STAR_INDEX st, int pl, int *count,
					  int start_count, int end_count);
	int DrawStarLine(System *sys, STAR_INDEX st, int *count,
					 int start_count, int end_count);
	int DrawLine(System *sys, STAR_INDEX st, int pl, int sat, int *count,
				 int start_count, int end_count);
	int DrawDetails(System *sys, BaseOrbit *bo, int *wcount, int *lcount,
					int start, int lines,
					PRINT_SOURCE ps);

};

// ====================================================
// the detail canvas
class SystemDetail : public wxScrolledWindow
{
public:
    SystemDetail(wxWindow *frame);
	~SystemDetail() {};

//    void OnPaint(void);
	void OnDraw(wxDC& dc);

private:

};


// ====================================================
// the list canvas
class ListCanvas : public wxTreeCtrl
{
public:
	ListCanvas(wxWindow *parent, wxFont *f, int d);
	~ListCanvas();

	void OnSelChanged(wxTreeEvent& event);

	void TreeSelection(int index);
	wxImageList *GetImageList(void) { return(image_list); };

private:
	wxImageList		*image_list;

	DECLARE_EVENT_TABLE()
};

// ====================================================
// map canvas
typedef enum HIT_TEST_VAL {
    HT_NONE = 0,
    HT_HEX = 1,
    HT_SECT = 2,
    HT_GLOB = 3 };

class MapCanvas: public wxScrolledWindow
{
public:
    MapCanvas(wxWindow *frame);
    ~MapCanvas() {};

//    void OnPaint(void);
 //   void OnEvent(wxMouseEvent& event);
	void OnDraw(wxDC& dc);

private:
    // menuing helper
    HIT_TEST_VAL HitText(int x, int y, int *r_x, int *r_y);

	bool         map_ready;
};

// ====================================================
// a dialog frame
class TempFrame : public wxFrame
{
public:
	TempFrame(char *filename);
	~TempFrame();

private:
	wxButton		*cmds[2];

	void Ok(wxCommandEvent& event);
	void Cancel(wxCommandEvent& event);

	MTUFile			*dirs;

	DECLARE_EVENT_TABLE()
};

// ====================================================
// the main (real) frame
class SystemFrame: public wxFrame
{
public:
    SystemFrame(wxFrame* frame, char* title, int x, int y, int w, int h);
    virtual ~SystemFrame();

    bool OnClose();

	System *GetSystem(void) { return(sys); };

	void DrawMap(wxDC& dc);
	int DrawMapAt(wxDC& dc, int cent, int first,
				  int start_x=0, int start_y=0, bool draw_empty=TRUE);
	void UpdateCurrentOrbit(long index);

	int CalcPageCount(PRINT_TYPE t, PRINT_SOURCE s, int lines=1,
					 bool msg=FALSE);
	int CalcMapCount(PRINT_SOURCE s, BaseOrbit *bo);

	int CalcWorldsOnPage(bool list, PRINT_SOURCE s, bool hdr, int lines,
						int page);

	bool CalcMapIndecies(PRINT_SOURCE ps, int index, int *cent, int *first);
	bool CalcOrbitIndecies(BaseOrbit *o, PRINT_SOURCE s, int index,
						  int *cur_page, int *cent, int *first);
	void GetMapSize(int *h, int *w);
	void Load(char *name);

	void InitButtons(wxToolBar *tb);
    void SetMenuMode(bool flag);

private:
// append a file name to the 'file' menu
	void AppendMenu(char *s);

// add a menu item
	void AddToMenu(wxMenu *mn, int id);

// dir stuff
	char *GetFilename(char *buff, bool for_enc);

//// update the tree canvas
	void UpdateTree(void);
    long UpdateTreeWithOrbit(long p_id,
								  STAR_INDEX st, int pl, int sat);
	long UpdateWithStarOrbit(long p_id,
								  STAR_INDEX st);
	long UpdateWithWorldOrbit(long p_id,
								   STAR_INDEX st, int pl);

	void DrawStar(wxDC& dc, int x, int y, StarOrbit *so, bool large=FALSE);
	void DrawWorld(wxDC &dc, int x, int y, BaseOrbit *bo,bool large=FALSE);

// menu functions
	void LoadFile(const int id);
	void LoadFileCommand(wxCommandEvent& event);
	void LoadFile1(wxCommandEvent& event);
	void LoadFile2(wxCommandEvent& event);
	void LoadFile3(wxCommandEvent& event);
	void LoadFile4(wxCommandEvent& event);
	void LoadFile5(wxCommandEvent& event);
	void SaveSystem(wxCommandEvent& event);
	void PrintSystem(wxCommandEvent& event);
	void EditSystem(wxCommandEvent& event);
	void EditOrbit(wxCommandEvent& event);
	void MoveOrbit(wxCommandEvent& event);
	void AddOrbit(wxCommandEvent& event);
	void DeleteOrbit(wxCommandEvent& event);
	void DetailOrbit(wxCommandEvent& event);
	void EncOrbit(wxCommandEvent& event);
	void ZoomIn(wxCommandEvent& event);
	void ZoomOut(wxCommandEvent& event);
	void ZoomSelect(wxCommandEvent& event);
	void ZoomOrbit(wxCommandEvent& event);
	void Quit(wxCommandEvent& event);
	void OnCloseWindow(wxCloseEvent &event);
	void OnAbout(wxCommandEvent &event);
// more helpers
	void OnToolEnter(wxCommandEvent& event);
	bool CreateOrbit(ORBIT_TYPE ot, float orbit);
    bool CreateStar(float o);
    bool CreateGG(float o);
	bool CreateBelt(float o)
	  { return(CreateOrbit("Y000", o)); };
	bool CreateWorld(float o)
	  { return(CreateOrbit("YS00", o)); };
	bool CreateSat(float o)
	  { return(CreateOrbit("YS00", o)); };
	bool CreateRing(float o)
	  { return(CreateOrbit("YR00", o)); };
	bool CreateOrbit(char *u, float o);

// canvases that display data
	SystemDetail		*detail;
    ListCanvas          *list;
    MapCanvas			*map;

// menus to keep track of
    wxMenu				*file_menu;
    wxMenu				*edit_menu;
    wxMenu				*map_menu;
    wxMenuBar			*menu_bar;
   
// dialogs
    SystemDialog        *sys_dlg;
	EditStarDialog      *star_dlg;
	EditGGDialog        *gg_dlg;
	EditWorldDialog     *world_dlg;
	MoveDialog          *move_dlg;
	AddDialog           *add_dlg;
	PrintDialog         *print_dlg;

// splitters
    wxSplitterWindow 	*splitter1;
    wxSplitterWindow 	*splitter2;

// brush w/ dithering
// windoze needs work:
    wxBitmap            *stipple_bm;
	
// actual system
	System				*sys;

	TCodes				*codes;
	MTUFile				*dirs;
// keep track of map world here:
//  (instead of in the actual system)
//	(also note that a 'map_sat' is kinda stupid) 

	int                 map_center;    // abs ndx to center 
	int                 map_first;     // where to start (wrt map_center)

	DECLARE_EVENT_TABLE()
};

#endif

