/*
 * File:		syst_dlg.h
 * Purpose:		general dialogs for system program
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: syst_dlg.h,v $ $Revision: 1.8 $ $Author: man $ $Date: 2003/05/04 15:12:39 $" */

#ifndef SYST_DLG_H
#define SYST_DLG_H

#include "t_dlg.h"
#include "uwp_dlg.h"
#include "syst.h"
#include "wx/print.h"
#include "wx/printdlg.h"

// ====================================================
// SystemParamDialog
#define MAX_UWP_CHOICES		8
#define MAX_STAR_CHOICES    3

// ====================================================
class SystemDialog : public StdDialog
{
public:
    SystemDialog(wxWindow *p);
    ~SystemDialog() {};

	bool GetSystemParams(char *n, char *st, char *sst, char *loc);
	
private:
	wxTextCtrl         *name;
	wxTextCtrl         *sect;
	wxTextCtrl         *ss;
	wxTextCtrl         *loc;
   
};

// ====================================================
class EditStarDialog : public StdDialog
{
public:
    EditStarDialog(wxWindow *p);
    ~EditStarDialog() {};

	bool GetStar(char *n, int *ty, int *cl, int *sz);

private:
	StarBox		*stars;

	wxTextCtrl         *name;
};

// ====================================================
class EditGGDialog : public StdDialog
{
public:
    EditGGDialog(wxWindow *p);
    ~EditGGDialog() {};

    bool GetGG(char *n, int *g);

private:
	wxChoice       *gg;
	wxTextCtrl         *name;
	
};

// ====================================================
class EditWorldDialog : public StdDialog
{
public:
    EditWorldDialog(wxWindow *p, CodeTable *ct);
    ~EditWorldDialog() {};

	bool GetWorld(BaseOrbit *, BaseTable *bt, CodeTable *at);

//	short ErrorCheck(char *user_uwp, char *adj_uwp);

private:
	void DoCodes(wxCommandEvent& event);
	void DoVerify(wxCommandEvent& event);
	// these returns TRUE if ok (ie. no changes)
	short CheckWorld(int *u);
	short CheckPlanet(int *u);
	bool CheckUWP(int *val, int min, int max);
	short CheckNoPop(int *u);
	short CheckRing(int *u);

	UWPBox			*uwp_box;

	wxTextCtrl		*name;
	
	ZoneChoice		*zone;
	CodeList		*bases;
	CodeList		*alleg;

	EditCodeDialog	*code_dlg;
//	ErrorDialog		*err_dlg;

	// keep local copies for verify
	BaseOrbit		*bo;

	// need to hold this for the code dialog
	unsigned long	code_val;

	// keep track of originals
	char luwp[MAX_UWP_CHOICES+1];

	DECLARE_EVENT_TABLE()
};

// ====================================================
class MoveDialog : public StdDialog
{
public:
    MoveDialog(wxWindow *p);
    ~MoveDialog() {};

	bool GetMove(System *s);
	
private:
	wxChoice      *star;
	wxTextCtrl    *orb;
	
};

// ====================================================
class AddDialog : public StdDialog
{
public:
    AddDialog(wxWindow *p);
    ~AddDialog() {};

	bool GetAdd(BaseOrbit *o, STAR_INDEX *si, ORBIT_TYPE *ot, float *orbit);

private:
	wxTextCtrl    *orb;
	wxChoice      *typ;
};

// ====================================================
class SysgenDialog : public StdDialog
{
public:
	SysgenDialog(wxWindow *p);
	~SysgenDialog();
	
	bool GetSysData(char *lng, bool *q);

private:
	wxBoxSizer		*sizer;
	wxStaticText    *lang;
	wxButton        *lang_sel;
	wxCheckBox		*quiet;
	char			*temp_lang;

	void LangFcn(wxCommandEvent& event);

	DECLARE_EVENT_TABLE()
};

// ====================================================
#define LINES_PER_PAGE 90

typedef enum PRINT_TYPE {
	PT_NONE=0,	// ie. cancelled
	PT_LIST,
	PT_DETAIL,
	PT_MAP };

typedef enum PRINT_SOURCE {
    PS_ALL=0,
	PS_CUR,
	PS_SUB,
	PS_IGN };

class SystemPrintOut : public wxPrintout
{
public:
	SystemPrintOut(PRINT_TYPE t, PRINT_SOURCE ps, char *msg);
	~SystemPrintOut();

	bool OnPrintPage(int page);
	bool HasPage(int page);
	void GetPageInfo(int *minPage, int *maxPage,
					 int *selPageFrom, int *selPageTo);

private:
	int				page_max;
#ifdef __WXGTK__
	bool            first_pass;
#endif
	char			*header_msg;
	PRINT_TYPE		pt;
	PRINT_SOURCE    ps;
};

// ====================================================
class PrintDialog : public StdDialog
{
public:
    PrintDialog(wxWindow *p);

	void DoPrint(System *sys);
	
// misc callback helpers
	void OnWhich(wxCommandEvent& event);
    void OnSetup(wxCommandEvent& event);

private:
	void Reset(void);
	
	wxRadioBox      *which;
	wxRadioBox      *opts;
	wxCheckBox      *file;

	wxPrintData			*p_data;
	wxPageSetupData		*ps_data;
	wxPrintDialog		*setup_dialog;

	GraphicDialog		*g_dlg;

	DECLARE_EVENT_TABLE()
};

#endif
