/*
 * File:		sg_dlg.h
 * Purpose:		general dialogs for system generate program
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: sg_dlg.h,v $ $Revision: 1.6 $ $Author: man $ $Date: 2003/05/04 12:47:39 $" */

#ifndef SG_DLG_H
#define SG_DLG_H

#include "t_dlg.h"
#include "uwp_dlg.h"
#include "t_code.h"
#include "sg_build.h"

#define MAX_STAR_CHOICES    3

// ====================================================
class MWDialog : public StdDialog
{
public:
    MWDialog(wxWindow *p, BaseTable *bt, CodeTable *at);
	~MWDialog() {};

	bool GetMW(char *u, char *ba, char *a, char *z, bool *supp,
				BaseTable *bt, CodeTable *at);

private:
	UWPBox			*uwp_box;
	CodeList		*bases;
	CodeList		*alleg;
	ZoneChoice		*zone;
	wxStaticText	*msg[3];
	wxCheckBox      *suppress;

	void Suppress(wxCommandEvent& event);
	
	DECLARE_EVENT_TABLE()
};

// ====================================================
class StarDialog : public StdDialog
{
public:
    StarDialog(wxWindow *p);
	~StarDialog() {};

	bool GetStars(char *st1, char *st2, char *st3);

private:
	StarBox			*stars[MAX_STAR_CHOICES];
	// NOTE: first one of these is not used:
	wxCheckBox		*none[MAX_STAR_CHOICES];
	wxCheckBox		*random[MAX_STAR_CHOICES];

	void None1(wxCommandEvent& event);
	void None2(wxCommandEvent& event);
	void None3(wxCommandEvent& event);
	void None(int n);
	void Random1(wxCommandEvent& event);
	void Random2(wxCommandEvent& event);
	void Random3(wxCommandEvent& event);
	void Random(int n);

	DECLARE_EVENT_TABLE()
};

// ===========================================================================
class ConfigDialog : public StdDialog
{
public:
    ConfigDialog(wxWindow *p, BaseTable *bt, CodeTable *at);
	~ConfigDialog() {};

	bool GetConfig(struct sys_conf *cfg);

//	void ToggleSave(void);
//	void ToggleMstars(void);
//	void ToggleTrav(void);
	void DoSpec(wxCommandEvent& event);
	void DoStars(wxCommandEvent& event);
	void DoRand(wxCommandEvent& event);
	void DoLang(wxCommandEvent& event);
	void Rand(void);
	
	DECLARE_EVENT_TABLE()

private:
	wxTextCtrl         *name;
	wxTextCtrl         *sect;
	wxTextCtrl         *ss;
	wxTextCtrl         *loc;

    wxButton        *trav_spec;
    wxButton        *stars;

//	wxCheckBox      *warn;
//	wxCheckBox      *st_adj;
	wxCheckBox      *rand;
//    wxCheckBox      *save;
//    wxCheckBox      *mstars;
//    wxCheckBox      *trav;
	
	wxChoice       *gg;
	wxChoice       *belts;

	wxStaticText	*lang;
	wxButton       *lang_btn;

	WordGen        *temp_lang;
	sys_conf    	*data;

	MWDialog       *mw;
	StarDialog     *st;
	
	BaseTable      *b_table;
	CodeTable      *a_table;
};


// ====================================================
class EditStarDialog : public StdDialog
{
public:
    EditStarDialog(wxWindow *p);
	~EditStarDialog() {};

	bool GetStar(int ndx, SystemGenerate *sg);

	void DoDel(wxCommandEvent& event);
	
	DECLARE_EVENT_TABLE()

private:
	StarBox			*star;

	wxTextCtrl      *orbit;
	wxTextCtrl      *last_orbit;
	wxTextCtrl      *capt_orb[3];
	wxTextCtrl      *mt_orb[3];

	wxButton       *del;

	bool           del_flag;
};

// ====================================================
class MoveOrbDialog : public StdDialog
{
public:
    MoveOrbDialog(wxWindow *p);
	~MoveOrbDialog() {};

	bool GetOrbit(char *title, SystemGenerate *sg,
				  int *st_ndx, int *orb, bool sat_ok=FALSE);

//	DECLARE_EVENT_TABLE()

private:
	wxChoice       *star;
	wxTextCtrl      *orb;
	
};

// ====================================================
class SelectOrbDialog : public StdDialog
{
public:
    SelectOrbDialog(wxWindow *p);
	~SelectOrbDialog() {};

	bool DoOrbSelect(char *title, struct sys_conf *cfg,
					 SystemGenerate *sg, bool gg);

	void DoAdd(wxCommandEvent& event);
	void DoDel(wxCommandEvent& event);
	void DoEdit(wxCommandEvent& event);
	
	DECLARE_EVENT_TABLE()

private:
	wxListBox       *orbs;

	wxButton        *add;
	wxButton        *del;
	wxButton        *edit;

	MoveOrbDialog   *dlg;
	
	// keep track of old values
	int             orbits[MAX_GG];
	int             st_ndx[MAX_GG];
	int             max;
	bool            no_add_del;

	// local storage do not delete
	SystemGenerate  *gen;
	bool            gg_flag;
	
	void CheckButtons(void);
	bool CrackSelection(int *st, int *o);
	
};

// ====================================================
class OrbMapElement : public wxObject
{
public:
    OrbMapElement(int s, int n, int a=-1) { st=s; ndx=n; sat=a; };
	~OrbMapElement() {};
	int st;
	int ndx;
	int sat;
};

// ----------------------------------------------------
class SelectMWDialog : public StdDialog
{
public:
    SelectMWDialog(wxWindow *p);
	~SelectMWDialog() {};

	bool SelectMW(SystemGenerate *sg, int *st, int *ndx, int *sat);
	
//	DECLARE_EVENT_TABLE()

private:
	wxListBox       *orbs;

	wxList          *map;
	
	void AppendOrbit(BuildOrbit *bo, char *data, int s, int n, int a=-1);
};

#endif

