/*
 * File:	sect_dlg.h
 * Purpose:	
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: sect_dlg.h,v $ $Revision: 1.14 $ $Author: man $ $Date: 2003/05/05 03:29:03 $" */

#ifdef __GNUG__
#pragma interface
#endif

#ifndef SECT_DLG_H
#define SECT_DLG_H

#include "d_sect.h"
#include "clr_dlg.h"
#include "uwp_dlg.h"
#include "draw_hex.h"
#include "wx/print.h"
#include "wx/notebook.h"
#include "wx/print.h"
#include "wx/printdlg.h"
#include "wx/generic/printps.h"
#include "wx/generic/prntdlgg.h"

// ====================================================
// not so generic dialogs
//  edit choice dialog
typedef enum CHOICE_MODE {
	CHOICE_NONE=0,
	CHOICE_BASES,
	CHOICE_CODES,
	CHOICE_ALLEG,
	CHOICE_BORDER,
	CHOICE_ROUTE,
	CHOICE_HEX_ROUTE
	};

class EditChoiceDialog : public wxDialog
{
public:
	EditChoiceDialog(wxWindow *p);
	~EditChoiceDialog(void);

	void AddChoice(char *c) { lb->Append(c); };
	void Clear(void) { lb->Clear(); };

	void DoChoice(CHOICE_MODE m, ColorArray *ca);
	bool DoRouteChoice(LinkedList *rtl, ColorArray *ca, ColorTable *ct);

	void OnNew(wxCommandEvent &event);
	void OnEdit(wxCommandEvent &event);
	void OnDelete(wxCommandEvent &event);
	void OnCloseWindow(wxCloseEvent &event);

private:
	wxListBox		*lb;
	CHOICE_MODE		mode;

	LookupTable		*lt;
// this could be done better
	LinkedList		*routes;
	ColorTable		*ct;

	ColorArray		*color_array;

	void UpdateRoutes(void);
	void Update(void);

	DECLARE_EVENT_TABLE()
};


// ====================================================
// hex choice dialog
//	used for selecting a specific (pre-defined) border or route
class HexChoiceDialog : public StdDialog
{
public:
	HexChoiceDialog(wxWindow *p, char *t);
	~HexChoiceDialog();

	short GetChoice(ColorTable *ct, bool abs_index=FALSE);

private:
	wxListBox		*lb;
};
		
// ====================================================
// border list dialog
class SectColorDialog : public StdDialog
{
public:
	SectColorDialog(wxWindow *p);
	~SectColorDialog();

	bool NewColor(CHOICE_MODE m, ColorArray *ca, ColorTable *ct);
	bool EditColor(CHOICE_MODE m, ColorArray *ca, ColorTableEntry *cte);

private:
//	void OnPaint(wxPaintEvent &event);
	void ColorEdit(wxCommandEvent &event);
//	void CreateWidget(void);
	void InitTitle(CHOICE_MODE m);
	void DoBitmap(void);

	wxTextCtrl			*desc;
	wxButton			*sel;
//	ColorWidget			*color;
	wxStaticBitmap		*bitmap;

	ColorArray			*color_array;		// reference
	int					col_sel;

	DECLARE_EVENT_TABLE()
};

// ====================================================
// misc simple dialogs
class HexDialog : public StdDialog
{
public:
	HexDialog(wxWindow *p);

	bool GetHex(short *x_, short *y_);

private:
	wxTextCtrl		*HexEdit;
};

class SSDialog : public StdDialog
{
public:
	SSDialog(wxWindow *p);

// WARNING:
//	do NOT pass nulls to this routine:
	bool GetNames(char **s_name, char *names[]);

private:
	wxTextCtrl		*SSNames[MAX_SS];
	wxTextCtrl		*SName;
};

#if 0
class CpDialog : public OkCancelDialog
{
public:
	CpDialog(wxWindow *p);

	bool GetCP(int, int, char **);

	void OnClear(wxCommandEvent &event);

	DECLARE_EVENT_TABLE()
private:
	wxTextCtrl		*CPName;

};
#endif

// ====================================================
class HexBorderDialog : public StdDialog
{
public:
	HexBorderDialog(wxWindow *p);
	~HexBorderDialog();

	bool GetBorders(HexData *hd, ColorArray *c, ColorTable *ct);

private:
	void ColorEdit(wxCommandEvent &event);
	void EnableCB(wxCommandEvent &event);

	void DoBitmaps(void);
	void DoBitmap(int ndx);
	
	wxCheckBox			*enable[6];
	ColorTable			*color_table;
	wxButton			*sel[6];
	wxStaticBitmap		*bitmaps[6];

	ColorArray			*color_array;		// reference
	int					col_sel[6];


	DECLARE_EVENT_TABLE()
};

// ====================================================
class HexRouteDialog : public StdDialog
{
public:
	HexRouteDialog(wxWindow *p);
	~HexRouteDialog();

	bool NewRoute(LinkedList *rtl, ColorArray *ca, ColorTable *ct);
	bool EditRoute(Route *rt, ColorArray *ca, ColorTable *ct);

private:
	void ColorEdit(wxCommandEvent &event);
	void SetBitmap(void);

	wxTextCtrl			*dest_x;
	wxTextCtrl			*dest_y;
	wxButton			*sel;
	wxStaticBitmap		*bitmap;

	ColorArray			*color_array;		// reference
	ColorTable			*color_table;

	int					col_sel;

	ColorTable			*ct;

	DECLARE_EVENT_TABLE()
};

// ====================================================
class EditStarDialog : public StdDialog
{
public:
    EditStarDialog(wxWindow *p);
    ~EditStarDialog() {};

	bool GetStar(int *ty, int *cl, int *sz);

private:
	StarBox			*stars;
};

// ====================================================
class EditWorldDialog : public StdDialog
{
public:
	EditWorldDialog(wxWindow *p, TCodes *codes);
    ~EditWorldDialog() {};

	bool EditWorld(main_world *mw, TCodes *codes);

private:
	void DoCodes(wxCommandEvent& event);
	void DoVerify(wxCommandEvent& event);
	void DoStar1(wxCommandEvent& event);
	void DoStar2(wxCommandEvent& event);
	void DoStar3(wxCommandEvent& event);
	void EnableStar1(wxCommandEvent& event);
	void EnableStar2(wxCommandEvent& event);
	void EnableStar3(wxCommandEvent& event);
	void DoEnable(void);
	void DoStar(int ndx);
	void UpdateTrade(char *);

	UWPBox			*uwp_box;

	wxTextCtrl		*name;
	
	wxChoice		*pop_ndx;
	wxChoice		*belts;
	wxChoice		*gg;
	wxStaticText	*trade;

	ZoneChoice		*zone;
	CodeList		*bases;
	CodeList		*alleg;

	wxCheckBox		*enable[3];
	wxButton		*star_btn[3];

	// controls not listed:
	//  'other' code button
	//  verify uwp button
	//  star dialog button(s)
	//  ok & cancel buttons....

	EditCodeDialog	*code_dlg;
	EditStarDialog	*star_dlg;

	// keep local copies for verify
	main_world		*mw;

	// need to hold these for the sub-dialogs (they may be thrown away)
	unsigned long	code_val;
	int				star_type[3];
	int				star_size[3];
	int				star_class[3];

	// keep track of originals
	char luwp[MAX_UWP_CHOICES+1];

	TradeTable		*tt;		// reference

	DECLARE_EVENT_TABLE()
};

// ====================================================
#define LINES_PER_PAGE 90

typedef enum PRINT_TYPE {
	PT_NONE=-1,	// ie. cancelled
	PT_MAP=0,
	PT_LIST,
	PT_DETAIL,
	PT_LEGEND,
	PT_FORMAT
};

typedef enum SECTOR_PRINT_SOURCE {
	// ??? wxGTK reversed these ???
	PS_SECT=0,
	PS_SS,
	PS_CURRENT,
	PS_RANGE
};

class SectorPrintOut : public wxPrintout
{
public:
	SectorPrintOut(PRINT_TYPE t, SECTOR_PRINT_SOURCE s, int s, int s_x, int s_y, 
		int e_x, int e_y, char *msg);
	~SectorPrintOut();

	bool OnPrintPage(int page);
	bool HasPage(int page);
	void GetPageInfo(int *minPage, int *maxPage, int *selPageFrom, int *selPageTo);

private:
	int				start_x;
	int				start_y;
	int				end_x;
	int				end_y;
	int				page_max;

	char			*header_msg;
	PRINT_TYPE		pt;
	SECTOR_PRINT_SOURCE	ps;
	int				ss;				// for format (only) < 0 => all subsectors
};

// ====================================================
class PrintDialog : public StdDialog
{
public:
	PrintDialog(wxWindow *p);
	~PrintDialog();

	void DoPrint(void);

// inputs:
	void SetCurrent(bool c) { current = c; };
	void SetSSName(int ndx, char *n);

// outputs:
	PRINT_TYPE GetType(void) { return(type); };
	SECTOR_PRINT_SOURCE GetSource(void) { return(src); };
	bool GetFile(void) { return(to_file); };
	short GetSSIndex(void) { return(ss_ndx); };

	void GetRange(int *s_x, int *s_y, int *e_x, int *e_y);

	void OnSetup(wxCommandEvent &event);

	void OnSource(wxCommandEvent &event);

	DECLARE_EVENT_TABLE()
private:
	void Reset(void);
	void HandleControls(void);
// inputs:
	char			*ss_names[MAX_SS];		// names of s/s
	bool			current;				// current world?
// outputs:
	PRINT_TYPE		type;
	SECTOR_PRINT_SOURCE	src;
	bool			to_file;
	short			ss_ndx;
	short			start_x;
	short			end_x;
	short			start_y;
	short			end_y;

	wxRadioBox			*which;
	wxRadioBox			*source;

	wxStaticText		*start_t;
	wxTextCtrl			*r_start;
	wxStaticText		*end_t;
	wxTextCtrl			*r_end;
	wxStaticText		*ss_t;
	wxChoice			*ss;
	wxCheckBox			*file;
	wxCheckBox			*total;

#ifdef __WXMSW__
	wxPrintDialog 		*setup_dialog;
#else
	wxGenericPrintDialog *setup_dialog;
#endif

	wxPrintData			p_data;
	
	GraphicDialog		*g_dlg;
};

// ====================================================
typedef enum SYS_SEL{
	SS_GEN=0,
	SS_EDIT,
	SS_BOTH
};

#if 0
class SysDialog : public OkCancelDialog
{
public:
	SysDialog(wxWindow *p);
	~SysDialog() {};

	void LangFcn(wxCommandEvent& event);
	void OptFcn(wxCommandEvent& event);
	void DoOpt(void);
	bool GetSysData(SYS_SEL *sel, char *lng, char *out, bool *q);

private:
	wxRadioBox      *opt;
	wxStaticText    *lang;
	wxButton        *lang_sel;
	wxTextCtrl      *out_file;
	wxCheckBox		*quiet;
	char			*temp_lang;

	DECLARE_EVENT_TABLE()
};
#endif
// ====================================================
// select a s/s
class SSSelectDialog : public StdDialog
{
public:
	SSSelectDialog(wxWindow *p);
	~SSSelectDialog();

	int SelectSS(char **s_names);

private:
	wxListBox		*lb;
};

// ====================================================
// dailog for alpha border code
typedef enum {
	ADC_DISCARD=0,
	ADC_ACCEPT,
	ADC_RETURN
} AD_CODE;

class AlphaDialog : public wxDialog
{
public:
	AlphaDialog(wxWindow *p);
	~AlphaDialog();

	AD_CODE GetAlpha(void);

private:
	AD_CODE		ret;

	void Discard(wxCommandEvent& event);
	void Accept(wxCommandEvent& event);
	void Return(wxCommandEvent& event);

	DECLARE_EVENT_TABLE()
};

// ====================================================
// formatting dialog box
class FormatDialog;
class FormatPanel : public wxScrolledWindow
{
public:
	FormatPanel(FormatDialog *p, BitmapList *b, TCodes *c, int w, int h);
	~FormatPanel() {};

	void OnDraw(wxDC& dc);
	void SetLayout(HexLayout *hl) { l_hl = hl; };
	void SetCoords(int x, int y) { cur_x = x; cur_y = y; }

private:
	void OnLeftDown(wxMouseEvent &event);
	int				cur_x;
	int				cur_y;
	DrawnHex		hex;
	HexLayout		*l_hl;				// reference
	BitmapList		*bms; 
	TCodes 			*codes;
	FormatDialog	*parent;

	DECLARE_EVENT_TABLE()
};

// ----------------------------------------------------
class FormatDialog : public StdDialog
{
public:
	FormatDialog(wxWindow *p, BitmapList *b, TCodes *c, HexLayout *hd);
	~FormatDialog() {};

	bool GetFormat(bool sector_wide, HexLayout *hl, bool *clear);

	void UpdateCoords(int x, int y_);
private:
	void OnFormat(wxCommandEvent& event);
//	void OnRouteBorder(wxCommandEvent& event);
	void OnReset(wxCommandEvent& event);
	void OnFilter(wxCommandEvent& event);
	void UpdateFormat(void);
	void EnableFilter(bool val);

	wxChoice		*format;
	wxStaticText	*msg;
	FormatPanel		*canvas;
	wxCheckBox		*uwps[8];
	wxStaticBox		*uwp_box;
	// these 2 are only available for the global version
//	wxButton		*rb_btn;
	wxCheckBox		*all;

	HexLayout		*l_hl;
	int				cur_x;
	int				cur_y;

	DECLARE_EVENT_TABLE()
};

#endif

