//
// File:		draw_hex.h
// Purpose:		draws a hex
// Author:		Mark A. Nordstrand
// Created:
// Updated:	
// Copyright:	LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: draw_hex.h,v $ $Revision: 1.3 $ $Author: man $ $Date: 2002/10/07 17:10:37 $"

#include "basesect.h"
#include "hex_fmt.h"
#include "t_code.h"
#include "t_bm.h"
#include "clr_dlg.h"
#include "wx/dc.h"

#ifndef DRAW_HEX_H
#define DRAW_HEX_H

// public defines used for drawing actual hex
#define BORDER_WIDTH			3
#define BORDER_STYLE			wxSOLID

#define HEX_X_OFFSET			152
#define HEX_Y_OFFSET			88

#define HEX_BORDER_X_OFFSET		2
#define HEX_BORDER_Y_OFFSET		2

#define HEX_X_1					24
#define HEX_X_2					76
#define HEX_X_3					100
#define HEX_X_4					76
#define HEX_X_5					24
#define HEX_X_6					0

#define HEX_Y_1					0
#define HEX_Y_2					0
#define HEX_Y_3					44
#define HEX_Y_4					88
#define HEX_Y_5					88
#define HEX_Y_6					44

#define HEX_X_CENTER			((HEX_X_3 - HEX_X_6) / 2)
#define HEX_Y_CENTER			HEX_Y_3

#define HEX_CENTER_WIDTH		12

// ==========================================================================
#define MAX_WORLD_BM			8

class WorldBitmapList : public LinkedList
{
public:
	WorldBitmapList();
	~WorldBitmapList();

	wxBitmap *GetBM(char *uwp);

private:
	wxBitmap 	*world_bm[MAX_WORLD_BM];
};

// -------------------------------------------------------------------------
// indecies to default colo(u)rs
#define RED_COLOUR_NDX				4
#define AMBER_COLOUR_NDX			6

class DrawnHex
{
public:
	DrawnHex();

	void DrawTotalHex(wxDC& dc, int x, int y, int start_x, int start_y,
			int last_x, int last_y, long off_x, long off_y,
			BaseSector *sect, HexData *hd, ColorTable *ct, ColorArray *colors,
			BitmapList *bitmaps, TCodes *codes, HexLayout *ghl);
	// simple hexs....
	void DrawHex(wxDC& dc, int x, int y);
	void DrawDummy(wxDC& dc, HexLayout *layout, BitmapList *bitmaps, 
				TCodes *codes, int x=0, int y=0);

	// call to setup fonts, brushes, and maybe pens
	void Start(wxDC& dc);

	void SetTextOffset(int val) { text_offset = val; };

	// do offset calcs
	void GetAltXY(int x, int y, int start_x, int start_y,
				  long off_x, long off_y, long *alt_x, long *alt_y);

	void DrawBorder(wxDC& dc, int x, int y, int start_x, int start_y,
			int color_ndx, ColorTable *ct, ColorArray *colors,
			long off_x, long off_y);
	void DrawHex(wxDC& dc, int x, int y, int start_x, int start_y,
			int last_x, int last_y, HexData *hd, ColorTable *ct, 
			ColorArray *colors, long off_x, long off_y);
	void DrawWorld(wxDC& dc, int x, int y, int start_x, int start_y,
			BaseSector *sect, HexData *hd, ColorArray *colors,
			BitmapList *bitmaps, TCodes *codes,
			HexLayout *ghl, long off_x, long off_y);
	void DrawCP(wxDC& dc, int x, int y, int start_x, int start_y, 
			HexData *hd, BitmapList *bitmaps, HexLayout *ghl, 
			long off_x, long off_y);
	void DrawBases(wxDC& dc, long alt_x, long alt_y, wxBitmap *bm1,
			wxBitmap *bm2);

	// misc lookups
//	int GetHexOffset(void) { return(hex_x_array[2]); };
	void GetTextOffsets(int i, int j, int *x, int *y);
	void GetHexCorner(int i, int *x, int *y);

	// misc drawing 'primitives'
	// XXX how many could be private?
	void DrawMW(wxDC& dc, int x, int y);
	void DrawMWBM(wxDC& dc, char *uwp, int x, int y);
	void DrawDryMW(wxDC& dc, int x, int y);
	void DrawAstMW(wxDC& dc, int x, int y);
	void DrawGG(wxDC& dc, int x, int y);
	void DrawAst(wxDC& dc, int x, int y);
	void DrawStar(wxDC& dc, char *clr, int x, int y);

	void DrawChar(wxDC& dc, char c, int x, int y);
	void DrawString(wxDC& dc, char *s, int x, int y);
	void DrawStringBold(wxDC& dc, char *s, int x, int y);

	void DrawBM(wxDC& dc, wxBitmap *bm, int x, int y);

private:
	static WorldBitmapList *world_bm_list;
	static int hex_x_array[7];
	static int hex_y_array[7];
	static int alt_hex_x_array[7];
	static int alt_hex_y_array[7];
	static int coords[MAX_LAYOUT_Y][MAX_LAYOUT_X][2];

	int text_offset;
};

#endif

