/*
 * File:      mtu_dlg.h
 * Purpose:   header for MTU (the program, not the suite) specific dialogs
 * Author:    Mark A. Nordstrand
 * Created:   9/18/99
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: mtu_dlg.h,v $ $Revision: 1.10 $ $Author: man $ $Date: 2003/05/02 13:05:33 $" */

#ifndef MTU_DLG_H
#define MTU_DLG_H

#include "wx/prntbase.h"
#include "wx/printdlg.h"
#include "clr_dlg.h"
#include "code_dlg.h"
#include "universe.h"
#include "t_word.h"
#include "wx/confbase.h"
#include "wx/fileconf.h"


// ========================================================================
// flags for drawing (easier than passing a boat load of bool's around)
// NOTE:  since some are exclusive (ie. 3D vs. 2D), the mess
//  (and I do mean mess) could be implemented by making them context
//  specific.  I think that may be a worse mess........
#define	FLAG_SECT_NAME			0x0001
#define	FLAG_SECT_ROUTES		0x0002
#define	FLAG_SECT_BORDERS		0x0004
// not implemented (yet):
#define	FLAG_SECT_COORD			0x0008
#define FLAG_SECT_NAMED			0x0010
#define	FLAG_SECT_UNDETAILED	0x0010
#define	FLAG_SECT_3D_NAME		0x0100
// not implemented (yet):
#define	FLAG_SECT_3D_DETAILED	0x0200
// NOTE: this means systems *with* routes, not the routes themselves
// not implemented (yet):
#define	FLAG_SECT_3D_ROUTES		0x0400
// not implemented (yet):
#define	FLAG_SECT_3D_COLOR		0x0800

#define FLAG_SECT_DEFAULT		0x0f0f

#define FLAG_SECT_EDITED		0x10000000

typedef enum {
	HTV_NONE=0,
	HTV_AREA,
	HTV_WAR
} HARD_TIMES_VIEW;

// kludge!
void main_frame_callback(unsigned long f, HARD_TIMES_VIEW v, float s, int x_, int y_, int z_);

// ========================================================================
// resource editor(s)
class EditColorDialog : public StdDialog
{
public:
	EditColorDialog(wxWindow *p);
	~EditColorDialog();

	// returns the 'name' component or NULL on cancel
	//   unfortunately, that means the caller must manage the memory.....
	char *EditColor(wxColour *c, char *n);

private:
//	void OnPaint(wxPaintEvent& event);
	void OnSlider(wxCommandEvent& event);
	void SetColor(void);

	wxColour		*widget;
	wxSlider		*red;
	wxSlider		*green;
	wxSlider		*blue;
	wxTextCtrl		*name;
	wxStaticBitmap	*bitmap;

	DECLARE_EVENT_TABLE()
};

// =======================================================================
class EditBitmapDialog : public StdDialog
{
public:
	EditBitmapDialog(wxWindow *p);
	~EditBitmapDialog();

	bool EditBitmap(NamedBitmap *nb);

private:
//	void OnPaint(wxPaintEvent& event);
	void OnLoad(wxCommandEvent& event);

	NamedBitmap		*bitmap;			// reference, don't delete
	wxStaticBitmap	*bm;

	wxTextCtrl		*name;

	DECLARE_EVENT_TABLE()
};

// ==================================================================
//  My gut reaction is these should be *nix dependent, I could be wrong,
//   and a finer granularity may be more appropriate......
#if defined(__WXGTK__) || defined(__WXMOTIF__)
typedef enum RESOURCE_EDIT {
	RE_COLOR=0,
	RE_BITMAP
};

class ResourceDataDialog : public StdDialog
{
public:
	ResourceDataDialog(wxWindow *p);
	~ResourceDataDialog();

	bool GetBitmaps(BitmapList *bl);
	bool GetColors(ColorArray *c);

private:
	void OnNew(wxCommandEvent& event);
	void OnDel(wxCommandEvent& event);
	void OnEdit(wxCommandEvent& event);
	void OnSelected(wxListEvent& event);
	void DisplayColors(ColorArray *c);
	void DisplayBitmaps(BitmapList *bl);
	int GetSelection(void);

	EditColorDialog		*color_dialog;
	EditBitmapDialog	*bitmap_dialog;

	wxImageList			*images;
	RESOURCE_EDIT		ed;
	ColorArray			*colors;			// reference; do not delete
	BitmapList			*bls;				// reference; do not delete

//	wxListCtrl			*bm;
	BitmapControl		*bm;
	wxButton			*edit_c;
	wxButton			*delete_c;
	wxButton			*new_c;

	DECLARE_EVENT_TABLE()
};

class ResourceDialog : public StdDialog
{
public:
	ResourceDialog(wxWindow *p, wxConfig *config);
	~ResourceDialog();

	// TRUE from this means the caller must reload the resources
	//  (this dialog will write them when it is finished)
	bool GetResources(void);

private:
	void OnColor(wxCommandEvent& event);
	void OnBitmap(wxCommandEvent& event);

	ColorArray				*ca;
	BitmapList				*bl;
	ResourceDataDialog		*data_dialog;

    wxTextCtrl      *data_dir;
    wxTextCtrl      *exe_dir;
    wxTextCtrl      *help_dir;
	wxTextCtrl		*mtu_dir;

    wxTextCtrl      *sector;
    wxTextCtrl      *sysgen;
    wxTextCtrl      *system;
    wxTextCtrl      *world;
    wxTextCtrl      *enc_tbl;
	wxTextCtrl		*trade;
	wxTextCtrl		*sect_gen;
	wxTextCtrl		*editor;
	wxTextCtrl		*viewer;
	wxTextCtrl		*graphics;
	wxTextCtrl		*browser;

	wxConfig		*config;			// reference

	DECLARE_EVENT_TABLE()
};
#endif

// ========================================================================
// simple dialog for making a choice
class ChooseDialog : public StdDialog
{
public:
	ChooseDialog(wxWindow *p);
	~ChooseDialog();

	int GetUniverseChoice(UList *ul);
	int GetSectorChoice(SectorList *sl);

private:
	wxListBox		*lb;

	int GetChoice(int count);
};

// ========================================================================
class ViewDialog : public ApplyDialog
{
public:
	ViewDialog(wxWindow *p);
	~ViewDialog();

	bool GetView(unsigned long flags, HARD_TIMES_VIEW htv);

private:
	void OnApply(wxCommandEvent& event);
	void HandleCallBack(void);

	wxCheckBox		*names;
	wxCheckBox		*routes;
	wxCheckBox		*borders;
	wxCheckBox		*named;
	wxCheckBox		*undetailed;
	wxRadioBox		*ht;

	DECLARE_EVENT_TABLE()
};

// ========================================================================
class View3DDialog : public ApplyDialog
{
public:
	View3DDialog(wxWindow *p);
	~View3DDialog();

	// include htv so it won't be overwritten by the callback kludge
	bool GetView(unsigned long flags, HARD_TIMES_VIEW htv, float scale, 
				int x_rot, int y_rot, int z_rot);

private:
	void OnApply(wxCommandEvent& event);
	void HandleCallBack(void);

	wxCheckBox		*names_3d;
	wxCheckBox		*detailed;
	wxCheckBox		*routes_3d;
	wxCheckBox		*color;
	wxSlider		*x;
	wxSlider		*y;
	wxSlider		*z;
	wxTextCtrl		*scale;

	HARD_TIMES_VIEW	htv;

	DECLARE_EVENT_TABLE()
};

// ========================================================================
// NOTE:  these two classes (MTUPrintOut and MTUBitmap) are defined here,
// 			yet are implemented in mtu.cpp due to the drawing code.
class MTUPrintOut : public wxPrintout
{
public:
	MTUPrintOut(int s_x, int s_y, int e_x, int e_y, wxPrintData *pd, bool sc);
	MTUPrintOut();
	~MTUPrintOut();

	bool OnPrintPage(int page);
	bool HasPage(int page);
	void GetPageInfo(int *min, int *max, int *sel_from, int *sel_to);

private:
	// 2D specific:
	int			start_x;
	int			start_y;
	int			end_x;
	int			end_y;
	bool		scale;
	// general:
	bool		d3;
	int 		page_max;
};

// ========================================================================
class MTUBitmap : public wxBitmap
{
public:
	MTUBitmap(int w, int h);
	~MTUBitmap();

	void Draw(wxDC &dc, int start_x, int start_y, int end_x, int end_y);
	void Draw(wxDC &dc);

private:
	void Clear(wxDC &dc);
};

// ========================================================================
class PrintDialog : public StdDialog
{
public:
	PrintDialog(wxWindow *p);
	~PrintDialog();

	bool DoPrintOut(UListData *sectors, int default_x, int default_y);

private:
	void OnSetup(wxCommandEvent& event);
	void OnTotal(wxCommandEvent& event);
	void OnFile(wxCommandEvent& event);
	void CheckControls(void);

	wxStaticText			*msgs[4];
	wxTextCtrl				*ranges[4];
	wxCheckBox				*total;
	wxCheckBox				*file;
	wxCheckBox				*scale;

	GraphicDialog			*g_dlg;
#ifdef __WXMSW__
	wxPrintDialog			*setup_dialog;
#else
	wxGenericPrintDialog	*setup_dialog;
#endif
	wxPrintData 			p_data;

	DECLARE_EVENT_TABLE()
};

// ========================================================================
class Print3DDialog : public StdDialog
{
public:
	Print3DDialog(wxWindow *p);
	~Print3DDialog();

	bool DoPrintOut(UListData *sectors, int default_x, int default_y);

private:
	void OnSetup(wxCommandEvent& event);

	wxCheckBox				*file;

	GraphicDialog			*g_dlg;
#ifdef __WXMSW__
	wxPrintDialog			*setup_dialog;
#else
	wxGenericPrintDialog	*setup_dialog;
#endif
	wxPrintData 			p_data;

	DECLARE_EVENT_TABLE()
};

#endif

