/*
 * File:      mtu.h
 * Purpose:   header for MTU menu program
 * Author:    Mark A. Nordstrand
 * Created:   8/1/99
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: mtu.h,v $ $Revision: 1.9 $ $Author: man $ $Date: 2002/10/06 15:12:07 $" */

#ifndef MTU_H
#define MTU_H

#include "mtu_dlg.h"
#include "t_help.h"
#include "wx/confbase.h"
#include "wx/fileconf.h"
#include "wx/process.h"
#include "universe.h"
#include "srch_dlg.h"
#include "mtu_file.h"
#include "t_menu.h"
#ifdef USE_NEW_FUNCTIONS
#include "create.h"
#endif

// defaults for drawing code.....
//  is there a better way/value?
#define DEFAULT_MIN			-10000
#define DEFAULT_MAX			10000

// ========================================================================
// forward reference
class MainFrame;

// ========================================================================
// Define a new application
class MTU : public wxApp
{
public:
    bool OnInit(void);

};

// ========================================================================
// 3d view
class View3DStar : public ListData
{
public:
	View3DStar(Star3D *s, int n_x, int n_y, int n_z);
	~View3DStar();

	Star3D		*star;
	int			x;
	int			y;
	int 		z;

private:
};

class View3D : public LinkedList
{
public:
	View3D();
	~View3D();

	void CreateView(Sector3D *s, int x_ang, int y_ang, int z_ang);

	int			max_x;
	int			min_x;
	int			max_y;
	int			min_y;
	int			max_z;
	int			min_z;
private:
	void Clear(void);
};

// ========================================================================
// canvas
class MTUCanvas : public wxScrolledWindow
{
public:
	MTUCanvas(wxFrame *frame);

	void OnDraw(wxDC& dc);
	void OnLeftMouseDown(wxMouseEvent &event);
	void OnMouseDown(wxMouseEvent &event);
	
	DECLARE_EVENT_TABLE()

private:
};

// ------------------------------------------------------------------------
// main frame
class MainFrame : public wxFrame
{
public:
	MainFrame();
	~MainFrame();

	void OnCloseWindow(wxCloseEvent& event);
	void OnQuit(wxCommandEvent& event);
	void OnAbout(wxCommandEvent& event);
	void OnUser(wxCommandEvent& event);
	void OnCombo(wxCommandEvent& event);
	void OnToolLeftClick(wxCommandEvent& event);
	void OnToolEnter(wxCommandEvent& event);

	// canvas we draw on
	MTUCanvas		*canvas;

	void Draw(wxDC& dc);
	// drawing helpers
	void Draw2D(wxDC& dc, int min_x=DEFAULT_MIN, int min_y=DEFAULT_MIN,
					int max_x=DEFAULT_MAX, int max_y=DEFAULT_MAX);
	void Draw3D(wxDC& dc);
	void CalcPixelSizes(long *size_x, long *size_y, 
			int start_x, int start_y, int end_x, int end_y);
	void CalcSectorSize(int *x_, int *y_);

	unsigned long GetFlags(void) { return(flags); };
	float GetScale(void) { return(scale); };
	int GetXRot(void) { return(x_rot); };
	int GetYRot(void) { return(y_rot); };
	int GetZRot(void) { return(z_rot); };

	void SetFlags(unsigned long f) { flags = f; } ;
	void SetHTView(HARD_TIMES_VIEW v) { htv = v; } ;
	void SetScale(float s) { scale = s; };
	void SetRot(int x, int y, int z);

	void Refresh(void) { canvas->Refresh(); };

	void SetButtons(wxToolBar *tb, bool value);
	wxColour *GetColor(int ndx) { return(colors->GetColor(ndx)); };
	void GetMax3DView(long *x, long *y);

	bool InitToolbar(void);

	void DoSelection(int x, int y);

	Menu *GetUserMenu(void) { return(user_menu); };

private:
	void DoOpen(void);
	void DoSelect(void);
	void DoAbout(void);
#ifdef USE_NEW_FUNCTIONS
	void DoNew(void);
#endif
	void OpenU(int ndx);

	void Get3DPos(int x, int y, int z, int *d_x, int *d_y, int *rad);

	//
	bool CreateDir(char *msg, char *dir);

	// resource loaders
	void LoadResources(void);
	void LoadLocalResources(void);
	unsigned long LoadFlags(wxConfig *config, char *entry, unsigned long flag);
	void WriteFlags(wxConfig *config, char *entry, unsigned long flag);
	void LoadData(void);

	// 
	void UpdateStatus(void);

	// help system
	THelp			*help;

	// dialogs
	ResourceDialog	*resource_dialog;
	ChooseDialog	*choose_dialog;
	TCodeDialog		*code_dialog;
	ViewDialog		*view_dialog;
	View3DDialog	*view3d_dialog;
	PrintDialog		*print_dialog;
	Print3DDialog	*print_dialog3;
	SearchDialog	*search_dialog;
#ifdef USE_NEW_FUNCTIONS
	NewDialog		*new_dialog;
	ImportDialog	*import_dialog;
	Create3DDialog	*d3_dialog;
	Create2DDialog	*d2_dialog;
#endif
	// combobox on Toolbar
	wxComboBox		*combo;

	// display flags (see defines above)
	unsigned long	flags;
	HARD_TIMES_VIEW	htv;

	// menuing stuff
	Menu			*user_menu;

	// 3D display info
	int				x_rot;
	int				y_rot;
	int				z_rot;
	float			scale;
// would like to add the following:
// 	int				x_center;
// 	int				y_center;
// 	int				z_center;
// 	int				diameter;

	// the list of universes
	UList			*u_list;

	// the list of current sectors in a universe
	UListData		*sectors;		// ref.  do not delete
	// the 'current' sector
	SectorData		*sd;			// ref.  do not delete
	// the 'current' star
	Star3D			*star;			// rev.  do not delete

	// common (single/main) reference for TCodes
	TCodes			*codes;

	// colo(u)rs
	ColorArray		*colors;

	// font (for 3D)
	wxFont			*star_font;

	// view for 3D
	View3D			*view;

	// dir structure
	MTUFile			*dirs;


	DECLARE_EVENT_TABLE()
};


#endif

