/*
 * File:      	iso_map.h
 * Purpose:   	mapping with support for rotation and axis
 * Author:		Mark A. Nordstrand
 * Created:	
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-1999 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: iso_map.h,v $ $Revision: 1.1 $ $Author: man $ $Date: 2003/04/26 20:29:14 $" */



#ifndef ISO_MAP_H
#define ISO_MAP_H

#include "face.h"

// ========================================================================
// size stuff
#define ISO_MAP_MAX_X		35
#define ISO_MAP_MAX_Y		22
#define ISO_MAP_SECTION		7

#define MAX_PLATES				18
#define MAX_FACES				20
#define MAX_VERTICES			12
// special ones:
#define N_VERTEX_INDEX			0
#define S_VERTEX_INDEX			(MAX_VERTICES / 2)
#define VERTEX_FACE_INDEX		-99

// ---------------------------------------------------------------------------
// simple structure for top level coordinates
struct MAP_COORD {
	char		f;
	char		x;
	char		y;
};

#if 0
// ---------------------------------------------------------------------------
// intermediate class
class HexMap : public MapObject
{
public:
	HexMap();
	~HexMap();

	bool GetAdjHex(int f, int x, int y, int dir, 
				int *new_f, int *new_x, int *new_y);

private:
};
#endif
// ---------------------------------------------------------------------------
class TectPlate
{
public:
	TectPlate(int size, int dir, int v, int f, int x, int y);
	~TectPlate();

	int GetDirection(void) { return(direction); };
	int GetVelocity(void) { return(velocity); };
	int GetNumHexes(void) { return(num_hexes); };
	int GetPlacedHexes(void) { return(placed_hexes); };

	void SetDirection(int d) { direction = d; };
	void SetNumHexes(int n) { num_hexes = n; };
	bool IncPlacedHexes(void);
	bool CanPlace(void) { return(placed_hexes <= num_hexes); };

	void GetCenter(int *f, int *x, int *y);

#ifdef DEBUG_PLATES
	void DumpPlate(void);
#endif

private:
	int			direction;
	int			velocity;
	int			num_hexes;
	int			placed_hexes;
	// not really center, but starting point.....
	int 		face;
	int			x_cent;
	int			y_cent;
};

// ---------------------------------------------------------------------------
class IsoMap : public MapObject
{
public:
	IsoMap();
	~IsoMap();

	unsigned char GetHexMask(int x, int y);
//	HEX_PRESENT HexPresent(int x, int y);
//	void AdjacentHex(int x, int y, int dir, int *x, int *y);
	bool GetAdjHex(int f, int x, int y, int dir, 
				int *new_f, int *new_x, int *new_y);


//	bool SetData(int x, int y, unsigned long val);
//	bool GetData(int x, int y, unsigned long *val);

	void Clear(void);

//	MapHex *GetHex(int x, int y);
	MapHex *GetHex(int face, int x, int y);

	void SetPlates(int n);
	void DoPlateCollision(void);

//	bool XlatCoords(int x, int y, int axis, int rot, int *new_x, int *new_y);
	bool XlatCoords(int face, int x, int y, int axis, int rot, 
			int *new_x, int *new_y);
	int GetFaceIndex(int x, int y);

	TectPlate *GetPlate(int ndx);

	unsigned char GetRotation(int face, int rot);

	bool CheckPair(int x, int y, int *new_x);

#ifdef PLATE_GROW_CODE
	bool ExpandPlates(int mag);
#endif
private:
	bool ValidHex(int x, int y);
	int LowestY(int x);
	bool XYToFaceCoord(int x, int y, int *f, int *n_x, int *n_y);
	void LinkHex(int f, int x, int y);

//	HEX_TYPE GetHexType(int x, int y);
	unsigned char GetHexType(int x, int y);

	void GrowPlates(void);
#ifndef PLATE_GROW_CODE
	bool ExpandPlates(int mag);
#endif
	void PlacePlates(int num);
	int FillInPlates(int num, int x, int y, int dir, int min, int max, int c);
	bool SetPlateNum(int f, int x, int y, int plate_num);
	bool ForcePlateNum(int f, int x, int y, int plate_num);
	bool GetNewCoord(int f, int x, int y, int mag, int *dir,
			int *new_f, int *new_x, int *new_y);
	bool GetRelativeCoord(int f, int x, int y, int d,
			int *n_f, int *n_x, int *n_y, int *n_d);

	TectPlate 				*plates[MAX_PLATES];
	MapFace					*faces[MAX_FACES];
	// NOTE:  when accessing this, f and y will be VERTEX_FACE_INDEX,
	//   and x will provide the index.
	MapHex					*vertices[MAX_VERTICES];
#ifdef PLATE_GROW_CODE
	int						blank_no;
#endif

	static unsigned char 	mask[ISO_MAP_SECTION][ISO_MAP_MAX_Y];
//	unsigned long data[ISO_MAP_MAX_X][ISO_MAP_MAX_Y];
	static char 			face_index[ISO_MAP_SECTION][ISO_MAP_MAX_Y];
	static char				half_hex[ISO_MAP_SECTION][ISO_MAP_MAX_Y];
	static unsigned char 	rotation[MAX_FACES][6];
	static unsigned char	face_xlat[MAX_FACES][6];
	static char				face_base[MAX_FACES][2];
	static char 			hex_xlat_even[6][7][7][2];
	static char 			hex_xlat_odd[6][7][7][2];
	static unsigned char	vertex_xlat[6][MAX_VERTICES][2];
	static unsigned char	vertex_rotation[6][MAX_VERTICES];
};

#endif

