/*
 * File:      	flat_map.cpp
 * Purpose:   	base mapping
 * Author:		Mark A. Nordstrand
 * Created:	
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-1999 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: hex.cpp,v $ $Revision: 1.1 $ $Author: man $ $Date: 2003/04/26 20:29:14 $" */

#include <math.h>
#include "hex.h"

#ifndef M_PIl
#define M_PIl      3.1415926535897932384626433832795029L
#endif

// ============================================================================
MapObject::MapObject(MapObject *p, MAP_OBJECT_TYPE t)
{
	parent = p;
	type = t;
}

MapObject::~MapObject()
{
}

// ============================================================================
Hex::Hex(MapObject *p, HEX_TYPE t, int d) :
		MapObject(p, MOT_SUB_HEX)
{
	CommonInit(t, d);
}

// hokey special one for MapHex.....
Hex::Hex(MapObject *p, HEX_TYPE t) :
		MapObject(p, MOT_MAP_HEX)
{
	CommonInit(t, 0);
}

Hex::~Hex()
{
int i,j;
	
	for(i = 0;i < MAX_SUB_HEXES_X;i++) {
		for(j = 0;j < MAX_SUB_HEXES_Y;j++) {
			if(hexes[i][j] != NULL)
				delete hexes[i][j];
		}
	}
}

// ----------------------------------------------------------------------------
void
Hex::CommonInit(HEX_TYPE t, int d)
{
int i,j;

	hex_type = t;
	depth = d;
	plate = -1;			// not in any plate.....
//	sub_hex = TRUE;
	altitude = 0;
	user_features = features = 0l;
	for(i = 0;i < MAX_SUB_HEXES_X;i++) {
		for(j = 0;j < MAX_SUB_HEXES_Y;j++) {
			hexes[i][j] = NULL;
		}
	}
}

// ----------------------------------------------------------------------------
Hex *
Hex::GetSubHex(int x, int y)
{
	if((x < MAX_SUB_HEXES_X) && (y < MAX_SUB_HEXES_Y))
		return(hexes[x][y]);
	return(NULL);
}

// ----------------------------------------------------------------------------
// hex navigation/traversal
//  NOTE:  I'm doing some real screwy things near vertices
//  NOTE2: XXX for now, the poles are just plain hosed.....
//  NOTE3: ARRRRGGGGGHHHHH!!!!!!! XXX should use depth.....
GET_HEX_RET 
Hex::GetAdjHex(int x, int y, int dir, int *n_x, int *n_y, int *n_d)
{
	// XXX sanity check on x and y?
	*n_x = x;
	*n_y = y;
	
	// XXX poles...
	if((HT_N_VERTEX == hex_type) || (HT_N_POLE == hex_type)) {
		if((1 == x) && (1 == y)) {
			if(0 == dir) {
				x = 3;
				return(GHR_OK);
			} else if(1 == dir) {
				x = 2;
				y = 2;
				return(GHR_OK);
			}
		} else if((1 == x) && (2 == y)) {
			if(0 == dir) {
				y = 1;
				return(GHR_OK);
			}
		} 
	} else if((HT_S_VERTEX == hex_type) || (HT_S_VERTEX == hex_type)) {
		if((1 == x) && (3 == y)) {
			if(2 == dir) {
				x = 3;
				return(GHR_OK);
			} else if(1 == dir) {
				x = 2;
				y = 2;
				return(GHR_OK);
			}
		} else if((1 == x) && (2 == y)) {
			if(0 == dir) {
				y = 3;
				return(GHR_OK);
			}
		} 
	}

	switch(dir) {
		case 0:
			(*n_y)--;
			if((y & 1) == 0)
				(*n_x)++;
			break;
		case 1:
			(*n_x)++;
			break;
		case 2:
			(*n_y)++;
			if((y & 1) == 0)
				(*n_x)++;
			break;
		case 3:
			(*n_y)++;
			if(y & 1)
				(*n_x)--;
			break;
		case 4:
			(*n_x)--;
			break;
		case 5:
			(*n_y)--;
			if(y & 1)
				(*n_x)--;
			break;
	}

	// XXX poles...
	if(HT_N_VERTEX == hex_type) {
		if((2 == x) && (1 == y)) {
			x = 1;
		} else if((2 == x) && (0 == y)) {
			x = 0;
		}
	} else if(HT_S_VERTEX == hex_type) {
		if((2 == x) && (3 == y)) {
			x = 1;
		} else if((2 == x) && (4 == y)) {
			x = 0;
		}
	}

	// did we move off this hex?
	if(OffHexCheck(n_x, n_y, n_d)) {
		// XXX check for pole
		return(GHR_RELATIVE);
	}

	return(GHR_OK);
}

// real slow way to do this.
//  then again, I can't come up with a fast way which is right......
GET_HEX_RET 
Hex::GetNewCoord(int x, int y, int dir, int mag, 
			int *n_x, int *n_y, int *n_d, int *n_m)
{
GET_HEX_RET ret;
int x2,y2;
int m1,d2;

	m1 = mag;
	while(m1) {
		if((ret = GetAdjHex(x, y, dir, &x2, &y2, &d2)) == GHR_ERR) {
			return(GHR_ERR);
		}

		if(GHR_RELATIVE == ret) {
			*n_x = x2;
			*n_y = y2;
			*n_d = d2;
			*n_m = mag - m1;
			return(ret);
		}

		x = x2;
		y = y2;
		m1--;
	}

	*n_x = x2;
	*n_y = y2;
	return(GHR_OK);
}

bool
Hex::OffHexCheck(int *x, int *y, int *d)
{
	if((*y) < 0) {
		if((*x) < 2) {
			*d = 5;
			*x = 3;
			*y = 3;
			return(TRUE);
		} else {
			*d = 0;
			(*x) -= 2;
			*y = 3;
			return(TRUE);
		}
	} else if((*y) < 1) {
		if((*x) < 1) {
			*d = 5;
			(*x) += 2;
			*y = 4;
			return(TRUE);
		} else if((*x) > 2) {
			*d = 0;
			(*x) = 1;
			*y = 4;
			return(TRUE);
		}
	} else if ((*y) >= MAX_SUB_HEXES_Y) {
		if((*x) < 2) {
			*d = 3;
			*x = 3;
			*y = 1;
			return(TRUE);
		} else {
			*d = 2;
			(*x) -= 2;
			*y = 1;
			return(TRUE);
		}
	} else if((*y) > 3) {
		if((*x) < 2) {
			*d = 3;
			(*x) -= 2;
			*y = 0;
			return(TRUE);
		} else {
			*d = 2;
			*x = 1;
			*y = 0;
			return(TRUE);
		}
	}

	if((*x) < 0) {
		(*x) += MAX_SUB_HEXES_X;
		*d = 4;
		return(TRUE);
	}

	if((*x) >= MAX_SUB_HEXES_X) {
		(*x) -= MAX_SUB_HEXES_X;
		*d = 2;
		return(TRUE);
	}

	return(FALSE);
}

// ----------------------------------------------------------------------------
#ifdef DEBUG_HEX
void 
Hex::DumpHex(void)
{
int i,j;

	fprintf(stderr, "d:%d t:%d a:%d f:0x%x u:0x%x\n", depth, hex_type,
			altitude, features, user_features);
	for(i = 0;i < MAX_SUB_HEXES_X;i++) {
		for(j = 0;j < MAX_SUB_HEXES_Y;j++) {
			fprintf(stderr, "0x%x ", hexes[i][j]);
		}
		fprintf(stderr, "\n");
	}
}
#endif

// ============================================================================
MapHex::MapHex(MapObject *p, HEX_TYPE t) : 
		Hex(p, t)
{
int i;

	for(i = 0;i < 6;i++) {
		adj[i][0] = adj[i][1] = adj[i][2] = -1;
		alt[i] = 0;
	}
	// override this:
//	sub_hex = TRUE;
}

MapHex::~MapHex()
{
}

void 
MapHex::SetAdj(int dir, int f, int x, int y)
{
	if((dir >= 0) && (dir < 6)) {
		adj[dir][0] = f;
		adj[dir][1] = x;
		adj[dir][2] = y;
	}
}

bool
MapHex::GetAdj(int dir, int *f, int *x, int *y)
{
	if((dir >= 0) && (dir < 6)) {
		*f = adj[dir][0];
		*x = adj[dir][1];
		*y = adj[dir][2];
		return(TRUE);
	}
	return(FALSE);
}

void
MapHex::SetAlt(int dir, int move, int vel, int adj_move, int adj_vel)
{
double p[2],a_p[2];

	if((dir >= 0) && (dir < 6)) {
		if((move != adj_move) && (vel != adj_vel)) {
			// XXX make a function!!!
			switch(move) {
				case 0:
					p[0] = cos(M_PIl / 3.0);
					p[1] = sin(M_PIl / 3.0);
					break;
				case 1:
					p[0] = cos(0);
					p[1] = sin(0);
					break;
				case 2:
					p[0] = cos(5.0 * M_PIl / 3.0);
					p[1] = sin(5.0 * M_PIl / 3.0);
					break;
				case 3:
					p[0] = cos(4.0 * M_PIl / 3.0);
					p[1] = sin(4.0 * M_PIl / 3.0);
					break;
				case 4:
					p[0] = cos(3.0 * M_PIl / 3.0);
					p[1] = sin(3.0 * M_PIl / 3.0);
					break;
				case 5:
					p[0] = cos(2.0 * M_PIl / 3.0);
					p[1] = sin(2.0 * M_PIl / 3.0);
					break;
			}
			p[0] *= vel;
			p[1] *= vel;

			switch(adj_move) {
				case 0:
					a_p[0] = cos(M_PIl / 3.0);
					a_p[1] = sin(M_PIl / 3.0);
					break;
				case 1:
					a_p[0] = cos(0);
					a_p[1] = sin(0);
					break;
				case 2:
					a_p[0] = cos(5.0 * M_PIl / 3.0);
					a_p[1] = sin(5.0 * M_PIl / 3.0);
					break;
				case 3:
					a_p[0] = cos(4.0 * M_PIl / 3.0);
					a_p[1] = sin(4.0 * M_PIl / 3.0);
					break;
				case 4:
					a_p[0] = cos(3.0 * M_PIl / 3.0);
					a_p[1] = sin(3.0 * M_PIl / 3.0);
					break;
				case 5:
					a_p[0] = cos(2.0 * M_PIl / 3.0);
					a_p[1] = sin(2.0 * M_PIl / 3.0);
					break;
			}
			a_p[0] *= adj_vel;
			a_p[1] *= adj_vel;

			p[0] -= a_p[0];
			p[1] -= a_p[1];

			alt[dir] = (int) (10.0 * sqrt((p[0] * p[0]) + (p[1] * p[1])));
		}
	}

	SetAltitude((alt[0] + alt[1] + alt[2] + alt[3] + alt[4] + alt[5]) / 6);
}

