/*
 * File:      	face.h
 * Purpose:   	handle a single map 'face' (aka the triangle)
 * Author:		Mark A. Nordstrand
 * Created:	
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-1999 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: face.h,v $ $Revision: 1.1 $ $Author: man $ $Date: 2003/04/26 20:29:14 $" */

#ifndef FACE_H
#define FACE_H

#ifdef DEBUG_FACE
#include <stdio.h>
#endif

#include "hex.h"

// ---------------------------------------------------------------------------
#define MAP_FACE_MAX_X			6
#define MAP_FACE_MAX_Y			7

class MapFace : public MapObject
{
public:
	MapFace(MapObject *p, bool odd);
	~MapFace();

	MapHex *GetHex(int x, int y);
	
	// XXX probably need to screw around w/ moving off of face....
	GET_HEX_RET GetAdjHex(int x, int y, int dir, int *n_x, int *n_y, int *n_d);
	GET_HEX_RET GetNewCoord(int x, int y, int dir, int mag, 
				int *n_x, int *n_y, int *n_m, int *n_d);

#ifdef DEBUG_FACE
	void DumpFace(int d=0);
#endif
private:
	bool		odd;
	// NOTE:
	// like with hexes, several will be NULL.  so, there will be
	//  space wasted with empty pointers..... (and like hexes, 
	//  draw it out if you can't visualize it)  even faces have
	//  the following NULLs:
	// [0][0],[1][0],   [3][0],[4][0],[5][0]
	// [0][1],[1][1],          [4][1],[5][1]
	// [0][2],                 [4][2],[5][2]
	// [0][3],                        [5][3]
	//                                [5][4]
	//
	//  odd faces will also have all of row 6 filled with NULLs
	//  (and having some ugly translations -- see the iso_map
	//  files).
	//
	// AND:  vertices, as special cases, are not handled here
	MapHex		*hexes[MAP_FACE_MAX_X][MAP_FACE_MAX_Y];

};


#endif

