/*
 * File:      	face.cpp
 * Purpose:   	handle a single map 'face'
 * Author:		Mark A. Nordstrand
 * Created:	
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-1999 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: face.cpp,v $ $Revision: 1.1 $ $Author: man $ $Date: 2003/04/26 20:29:14 $" */

//#include <stdio.h>
#include "face.h"

static char hex_map[MAP_FACE_MAX_Y] = {
	0x08,	// 001000
	0x0c,	// 001100
	0x1c,	// 011100
	0x1e,	// 011110
	0x3e,	// 111110
	0x3f,	// 111111
	0x3f	// 111111
};

MapFace::MapFace(MapObject *p, bool o) :
	MapObject(p, (o & 1) ? MOT_FACE_ODD : MOT_FACE_EVEN)
{
int i,j,mask;

	odd = o;

	mask = 0x20;
	for(i = 0;i < MAP_FACE_MAX_X;i++) {
		for(j = 0;j < MAP_FACE_MAX_Y;j++) {
			hexes[i][j] = NULL;
			if((6 == j) && (odd))
				continue;
			if(mask & hex_map[j])
				hexes[i][j] = new MapHex(this, HT_WHOLE);
		}
		mask /= 2;
	}
}

MapFace::~MapFace()
{
int i,j;

	for(i = 0;i < MAP_FACE_MAX_X;i++) {
		for(j = 0;j < MAP_FACE_MAX_Y;j++) {
			if(hexes[i][j] != NULL) {
				delete(hexes[i][j]);
			}
		}
	}
}

//#include <stdio.h>
MapHex *
MapFace::GetHex(int x, int y)
{
//fprintf(stderr, "(%d %d)---> o:%d ", x, y, odd);
	// simple range check
	if((x < 0) || (x >= MAP_FACE_MAX_X) || (y < 0) ||
		(((odd) && (y >= (MAP_FACE_MAX_Y - 1))) ||
		(y >= MAP_FACE_MAX_Y))) {
//fprintf(stderr, "Not found!!!\n");
		return(NULL);
	}

	// known emptly locations????
	
//fprintf(stderr, "0x%x\n", hexes[x][y]);
	return(hexes[x][y]);
}

// NOTE: n_d is a relative direction, like for hexes, however,
// 		 a face only has 3 sides and 3 corners (vertices), so
//		 0,2,4 are the sides, while 1,3,5 are vertices.
//		 vertex returns will do no translation
GET_HEX_RET 
MapFace::GetAdjHex(int x, int y, int dir, int *n_x, int *n_y, int *n_d)
{
int max_y;

	// XXX sanity check?
	*n_x = x;
	*n_y = y;

	if(odd) {
		max_y = MAP_FACE_MAX_Y - 1;
		// adjust dirction
//		dir += 3;
//		if(dir > 5)
//			dir -= 6;
	} else 
		max_y = MAP_FACE_MAX_Y;

	switch(dir) {
		case 0:
			(*n_y)--;
			if((y & 1) == 0)
				(*n_x)++;
			break;
		case 1:
			(*n_x)++;
			break;
		case 2:
			(*n_y)++;
			if((y & 1) == 0)
				(*n_x)++;
			break;
		case 3:
			(*n_y)++;
			if(y & 1)
				(*n_x)--;
			break;
		case 4:
			(*n_x)--;
			break;
		case 5:
			(*n_y)--;
			if(y & 1)
				(*n_x)--;
			break;
	}
	
	// move onto a vertex?
	if((-1 == (*n_x)) && (6 == (*n_y))) {
		*n_d = 5;
		return(GHR_RELATIVE);
	} else if((6 == (*n_x)) && (6 == (*n_y))) {
		*n_d = 3;
		return(GHR_RELATIVE);
	} else if((-1 == (*n_y)) &&
		(((odd) && (2 == (*n_x))) || ((!odd) && (3 == (*n_x))))) {
		*n_d = 1;
		return(GHR_RELATIVE);
	}

	// move off bottom?
	if((*n_y) >= max_y) {
		if(odd)
			*n_y = MAP_FACE_MAX_Y - 2;
		else
			*n_y = MAP_FACE_MAX_Y - 1;
		(*n_x) = MAP_FACE_MAX_X - (*n_x) - 1;
		*n_d = 1;
		return(GHR_RELATIVE);
	}

	// move off left side?
	if((((*n_y) / 2) + (*n_x) -1) < 1) {
		*n_x = -((*n_x) - 1);
		*n_y = MAP_FACE_MAX_Y - (*n_y);
		*n_d = 5;
		return(GHR_RELATIVE);
	}
	// move off the right side?
	if(((((*n_y) + 3) / 2) - (((*n_x) - 1))) > 0) {
		*n_x = 8 - (*n_x);
		*n_y = MAP_FACE_MAX_Y - (*n_y);
		*n_d = 0;
		return(GHR_RELATIVE);
	}

	return(GHR_OK);
}

GET_HEX_RET 
MapFace::GetNewCoord(int x, int y, int dir, int mag, 
		int *n_x, int *n_y, int *n_m, int *n_d)
{
GET_HEX_RET ret;
int x2,y2,m1,d2;

//fprintf(stderr, "===========================================\n");
//fprintf(stderr, "(%d %d) d:%d m:%d ", x, y, dir, mag);
	m1 = mag;
	while(m1) {
		if((ret = GetAdjHex(x, y, dir, &x2, &y2, &d2)) == GHR_ERR) {
//fprintf(stderr, "Error!!!\n");
			return(GHR_ERR);
		}

		if(GHR_RELATIVE == ret) {
			*n_x = x2;
			*n_y = y2;
			*n_d = d2;
			*n_m = mag = m1;
//fprintf(stderr, "Rel: (%d %d) d:%d m:%d\n", x2, y2, d2, m1);
			return(ret);
		}

		x = x2;
		y = y2;
		m1--;
	}

	*n_x = x2;
	*n_y = y2;
//fprintf(stderr, "Ok: (%d %d)\n", x2, y2);
	return(GHR_OK);
}

// ===========================================================================
#ifdef DEBUG_FACE
void
MapFace::DumpFace(int d)		// XXX d not implemented XXX
{
int i,j;

	for(j = 0;j < MAP_FACE_MAX_Y;j++) {
		for(i = 0;i < MAP_FACE_MAX_X;i++) {
			fprintf(stderr, " 0x%08x", hexes[i][j]);
		}
		fprintf(stderr, "\n");
	}
	fprintf(stderr, "\n");
}

#endif

