//
// File:		t_menu.h
// Purpose:		keep track of user menus
// Author:		Mark A. Nordstrand
// Created:
// Updated:	
// Copyright:	LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: t_menu.cpp,v $ $Revision: 1.4 $ $Author: man $ $Date: 2002/10/09 02:19:02 $"

#include <stdio.h>
#include "t_menu.h"
#include "parse.h"
#include "str_util.h"

#define BUFFER_SIZE			256
#define BIG_BUFFER_SIZE		(BUFFER_SIZE * 2)

// ==========================================================================
MenuItem::MenuItem(char *a, int i, MENU_TYPE t) :
	ListData()
{
	action = new char[strlen(a) + 1];
	strcpy(action, a);
	id = i;
	type = t;
}

MenuItem::~MenuItem()
{
	delete action;
}

// ==========================================================================
Menu::Menu(MTUFile *dirs, char *filename, int base_menu_id, int base_label_id) :
	LinkedList()
{
	real_id = base_menu_id;
	bogus_id = base_label_id;
	menu = BuildMenu(dirs, filename);
}

Menu::~Menu()
{
ListNode *n;
MenuItem *mi;

	n = First();
	while(n != NULL) {
		mi = (MenuItem *)n->Data();
		DeleteNode(n);
		delete mi;
		n = First();
	}

	delete menu;
}

MenuItem *
Menu::GetMenu(int id)
{
ListNode *n;
MenuItem *mi;

	n = First();
	while(n != NULL) {
		mi = (MenuItem *)n->Data();
		if(mi->GetID() == id)
			return(mi);
		n = Next();
	}

	return(NULL);
}

wxMenu *
Menu::BuildMenu(MTUFile *dirs, char *filename)
{
MENU_TYPE type=MT_INFO;
char buffer[BIG_BUFFER_SIZE],dir_buffer[BUFFER_SIZE],buffer2[BIG_BUFFER_SIZE];
char *ptrs[4];
FILE *fp;
MenuItem *mi;
wxMenu *lmenu=NULL,*nmenu;
GenericParse p;

//fprintf(stderr, "%s\n", filename);
	sprintf(dir_buffer, "%s/", dirs->GetMTUDir());
	if((fp = fopen(filename, "r")) != NULL) {
		lmenu = new wxMenu();
		while(fgets(buffer, BIG_BUFFER_SIZE, fp) != NULL) {
			strstrip(buffer, TRUE);
			strstrip(buffer, FALSE);
			if((strlen(buffer) == 0) || ('#' == buffer[0]))
				continue;
			p.Parse(buffer, ptrs, 4);
			switch(buffer[0]) {
				case 'D':
					strcat(dir_buffer, ptrs[1]);
					strcat(dir_buffer, "/");
					break;
				case 'I':
					if(type != MT_INFO)
						lmenu->AppendSeparator();
					lmenu->Append(bogus_id, ptrs[1]);
					type = MT_INFO;
					lmenu->Enable(bogus_id, FALSE);
					bogus_id++;
					break;
				case 'T':
					if(MT_INFO == type)
						lmenu->AppendSeparator();
					lmenu->Append(real_id, ptrs[1]);
					type = MT_TEXT;
					sprintf(buffer2, "%s/%s", dir_buffer, ptrs[2]);
					mi = new MenuItem(buffer2, real_id, type);
					Append(mi);
					real_id++;
					break;
				case 'H':
					if(MT_INFO == type)
						lmenu->AppendSeparator();
					lmenu->Append(real_id, ptrs[1]);
					type = MT_HTML;
					sprintf(buffer2, "%s/%s", dir_buffer, ptrs[2]);
					mi = new MenuItem(buffer2, real_id, type);
					Append(mi);
					real_id++;
					break;
				case 'P':
					if(MT_INFO == type)
						lmenu->AppendSeparator();
					lmenu->Append(real_id, ptrs[1]);
					type = MT_PS;
					sprintf(buffer2, "%s/%s", dir_buffer, ptrs[2]);
					mi = new MenuItem(buffer2, real_id, type);
					Append(mi);
					real_id++;
					break;
				case 'M':
					if(MT_INFO == type)
						lmenu->AppendSeparator();
					sprintf(buffer2, "%s%s", dir_buffer, ptrs[2]);
					nmenu = BuildMenu(dirs, buffer2);
					lmenu->Append(bogus_id, ptrs[1], nmenu);
					type = MT_MENU;
					bogus_id++;
					break;
				case 'G':
					if(MT_INFO == type)
						lmenu->AppendSeparator();
					lmenu->Append(real_id, ptrs[1]);
					type = MT_GRAPHICS;
					sprintf(buffer2, "%s/%s", dir_buffer, ptrs[2]);
					mi = new MenuItem(buffer2, real_id, type);
					Append(mi);
					real_id++;
					break;
				case 'E':
					if(MT_INFO == type)
						lmenu->AppendSeparator();
					lmenu->Append(real_id, ptrs[1]);
					type = MT_EXE;
//					sprintf(buffer2, "%s/%s", dir_buffer, ptrs[2]);
					mi = new MenuItem(ptrs[2], real_id, type);
					Append(mi);
					real_id++;
					break;
			}
		}
		fclose(fp);
	}

	return(lmenu);
}

bool
Menu::HandleEvent(MTUFile *dirs, int id)
{
char buffer[BIG_BUFFER_SIZE * 4];
MenuItem *mi;

	buffer[0] = 0;
//fprintf(stderr, "---> ");
	if((mi = GetMenu(id)) != NULL) {
		switch(mi->GetType()) {
			case MT_TEXT:
				sprintf(buffer, "%s %s", dirs->GetEditor(), mi->GetAction());
				break;
			case MT_HTML:
				sprintf(buffer, "%s %s", dirs->GetViewer(), mi->GetAction());
				break;
			case MT_PS:
				// sorry, it's hardcoded for now....
				sprintf(buffer, "%s %s", "gv", mi->GetAction());
				break;
			case MT_GRAPHICS:
				sprintf(buffer, "%s %s", dirs->GetGraphics(), mi->GetAction());
				break;
			case MT_EXE:
				sprintf(buffer, "%s", mi->GetAction());
				break;
		}
//fprintf(stderr, "t: %d  a:%s  ", mi->GetID(), mi->GetAction());
//fprintf(stderr, "<%s>  ", buffer);
		if(buffer[0] != 0) {
			wxExecute(buffer, FALSE);
//fprintf(stderr, "id: %d\n", id);
			return(TRUE);
		}
	}

//fprintf(stderr, "id: %d\n", id);
	return(FALSE);
}

