/*
 * File:      t_bm.cpp
 * Purpose:   general (small) bitmap list
 * Author:    Mark A. Nordstrand
 * Created:   9/25/1999
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: t_bm.cpp,v $ $Revision: 1.3 $ $Author: man $ $Date: 2002/06/05 04:51:07 $" */

#include "t_bm.h"
#include "t_res.h"

#include "wx/confbase.h"
#include "wx/fileconf.h"

#include "bitmaps/default.xpm"

#define MAX_FILE_LENGTH                    256

// ==========================================================================
BitmapList::BitmapList(wxConfig *config) :
	wxList()
{
	Load(config);
	_default = new wxBitmap(default_xpm);
}

BitmapList::~BitmapList()
{
wxNode *n;
NamedBitmap *bm;

	n = First();
	while(n != NULL) {
		bm = (NamedBitmap *)n->Data();
		delete bm;
		delete n;
		n = First();
	}
	
	delete _default;
}

wxBitmap *
BitmapList::NthBM(int ndx, bool NULL_OK)
{
NamedBitmap *nb;

	if((nb = GetNth(ndx)) != NULL)
		return(nb->GetBM());

	if(NULL_OK)
		return(NULL);
	else
		return(_default);
}

char *
BitmapList::NthName(int ndx)
{
NamedBitmap *nb;

	if((nb = GetNth(ndx)) != NULL)
		return(nb->GetName());

	return(NULL);
}

NamedBitmap *
BitmapList::GetNth(int ndx)
{
wxNode *n;

	n = Nth(ndx);
	if(n != NULL) {
		return((NamedBitmap *)n->Data());
	}

	return(NULL);
}

char *
BitmapList::NthFilename(int ndx)
{
NamedBitmap *nb;

	if((nb = GetNth(ndx)) != NULL)
		return(nb->GetFilename());

	return(NULL);
}

// ---------------------------------------------------------------------------
bool
BitmapList::Load(wxConfig *config)
{
char str[MAX_FILE_LENGTH];
int i=0;
wxString ptr;


	while(TRUE) {
		NamedBitmap *nb;
		char buff[MAX_FILE_LENGTH];

		ptr = "";
		sprintf(str, "/%s/%s%d", SECTION_BITMAP, ENTRY_BITMAP_NAME, i+1);
		if(!config->Read((const wxString) str, &ptr))
			break;
		strcpy(buff, ptr.GetData());;

		ptr = "";
		sprintf(str, "/%s/%s%d", SECTION_BITMAP, ENTRY_BITMAP_FILE, i+1);
		if(!config->Read((const wxString) str, &ptr))
			break;
		nb = new NamedBitmap((char *)ptr.GetData(), buff);
		Append(nb);
//fprintf(stderr, "%s:%s\n", buff, ptr.GetData());
		i++;
	}

	return(TRUE);
}

bool
BitmapList::Save(wxConfig *config)
{
int i=0;
char buff1[MAX_FILE_LENGTH];

	while(TRUE) {

		sprintf(buff1, "/%s/%s%d", SECTION_BITMAP, ENTRY_BITMAP_NAME, i + 1);
		config->Write((const wxString) buff1, 
					(const wxString) NthName(i));

		sprintf(buff1, "/%s/%s%d", SECTION_BITMAP, ENTRY_BITMAP_FILE, i + 1);
		config->Write((const wxString) buff1, 
					(const wxString) NthFilename(i));

		i++;
	}

	config->Flush();

	return(TRUE);
}

void
BitmapList::SetBitmapIndex(BaseTableEntry *bte)
{
int ndx=0;
wxNode *n;
NamedBitmap *nb;

	bte->SetIndex(0, -1);
	bte->SetIndex(1, -1);
	n = First();
	while(n != NULL) {
		nb = (NamedBitmap *)n->Data();

		if((nb->GetName() != NULL) && (bte->GetName(0) != NULL) && 
				(strcmp(bte->GetName(0), nb->GetName()) == 0))
				bte->SetIndex(0, ndx);
		if((nb->GetName() != NULL) && (bte->GetName(1) != NULL) && 
				(strcmp(bte->GetName(1), nb->GetName()) == 0))
				bte->SetIndex(1, ndx);

		ndx++;
		n = n->Next();
	}
}

int
BitmapList::BuildBitmapList(BaseTable *ct)
{
int i=0;
BaseTableEntry *cte;
ListNode *ln;

	ln = ct->First();
	while(ln != NULL) {
		cte = (BaseTableEntry *)ln->Data();
		SetBitmapIndex(cte);
		ln = ln->Next();
		i++;
	}

	return(i);
}

// ===========================================================================
NamedBitmap::NamedBitmap(wxBitmap *b, char *n) :
	wxObject()
{
	bm = new wxBitmap(*b);
	name = new char[strlen(n) + 1];
	strcpy(name, n);
	file_name = NULL;
}

NamedBitmap::NamedBitmap(char *f, char *n) :
	wxObject()
{
	bm = new wxBitmap(f, wxBITMAP_TYPE_XPM);
	name = new char[strlen(n) + 1];
	strcpy(name, n);
	file_name = new char[strlen(f) + 1];
	strcpy(file_name, f);
}

NamedBitmap::~NamedBitmap()
{
	if(bm != NULL)
		delete bm;
	if(name != NULL)
		delete name;
	if(file_name != NULL)
		delete file_name;
}

void
NamedBitmap::SetName(char *n)
{
	if(name != NULL)
		delete name;
	name = NULL;
	if(n != NULL) {
		name = new char[strlen(n) + 1];
		strcpy(name, n);
	}
}

void
NamedBitmap::SetFilename(char *f)
{
	if(file_name != NULL)
		delete file_name;
	file_name = NULL;
	if(bm != NULL)
		delete bm;
	bm = NULL;
	if(f != NULL) {
		file_name = new char[strlen(f) + 1];
		strcpy(file_name, f);
		bm = new wxBitmap(file_name, wxBITMAP_TYPE_XPM);
	}
}

