//
// File:		stargen.cpp
// Purpose:		common star generation
// Author:		Mark A. Nordstrand
// Created:
// Updated:	
// Copyright:	LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: stargen.cpp,v $ $Revision: 1.2 $ $Author: man $ $Date: 2002/04/13 14:10:05 $"

#include <stdio.h>
#include <stdlib.h>
#include "stargen.h"
#include "parse.h"
#include "str_util.h"

#define BUFFER_SIZE			256

// ============================================================================
char GenStar::system_nature[MAX_STAR_TABLE_ENTRY+1] = {
	"SSSSSSSSBBBBT"
};

char GenStar::primary_type[MAX_STAR_TABLE_ENTRY+1] = {
	"BBAMMMMMKGFFF"
};

char GenStar::primary_size[MAX_STAR_TABLE_ENTRY][6] = {
	"Ia",
	"Ib",
	"II",
	"III",
	"IV",
	"V",
	"V",
	"V",
	"V",
	"V",
	"V",
	"VI",
	"VII"
};

char GenStar::companion_type[MAX_STAR_TABLE_ENTRY+1] = {
	"-BAFFGGKKMMMM"
};

char GenStar::companion_size[MAX_STAR_TABLE_ENTRY][6] = {
	"Ia",
	"Ib",
	"II",
	"III",
	"IV",
	"VII",
	"VII",
	"V",
	"V",
	"VI",
	"VII",
	"VII",
	"VII"
};

char GenStar::companion_orbit[MAX_STAR_TABLE_ENTRY+1] = {
	"CCCC12345678F"
};

char GenStar::companion_die[MAX_STAR_TABLE_ENTRY+1] = {
	"0000000111110"
};

int GenStar::max_orbits[MAX_STAR_TABLE_ENTRY] = {
	0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12
};

// ============================================================================
GenStar::GenStar(char *filename) :
	DetailStar()
{
char buffer[BUFFER_SIZE],*ptrs[8];
int i=0;
FILE *fp;
GenericParse p;

	if((fp = fopen(filename, "r")) != NULL) {
		while(fgets(buffer, BUFFER_SIZE, fp) != NULL) {
			if('#' == buffer[0])
				continue;
			while(('\n' == buffer[strlen(buffer) - 1]) &&
				('\r' == buffer[strlen(buffer) - 1]))
				buffer[strlen(buffer) - 1] = 0;
			strstrip(buffer, 1);
			strstrip(buffer, 0);
			if(strlen(buffer) == 0)
				continue;

			if(i >= MAX_STAR_TABLE_ENTRY)
				// XXX error
				continue;
			p.Parse(buffer, ptrs, 8, ':');
			system_nature[i] = ptrs[0][0];
			primary_type[i] = ptrs[1][0];
			strcpy(primary_size[i], ptrs[2]);
			companion_type[i] = ptrs[3][0];
			strcpy(companion_size[i], ptrs[4]);
			companion_orbit[i] = ptrs[5][0];
			if('+' == ptrs[5][1]) {
				companion_die[i] = ptrs[5][2];
			} else {
				companion_die[i] = '0';
			}
			max_orbits[i] = atoi(ptrs[6]);
			i++;
		}
	}
}

void 
GenStar::GenStars(int num, char *uwp, char *st[MAX_STAR_GEN])
{
int type_roll,size_roll,i,j;

	// clear out buffers
	for(i = 0;i < MAX_STAR_GEN;i++) {
    	for(j = 0;j < STAR_BUFFER_SIZE;j++) {
			st[i][j] = 0;
		}
	}

	if(num < 1) {
		num = GenSystemNature();
	}

	type_roll = size_roll = 0;
	for(i = 0;i < num;i++) {
		GenerateStar(i, &type_roll, &size_roll, uwp, st[i]);
	}
}

void 
GenStar::GenerateStar(int ndx, int *type_roll, int *size_roll, 
				char *uwp, char *st)
{
int j,dm1=0,dm2=0;
Dice dice;

	// check for primary
	if(ndx == 0) {
		if((uwp != NULL) &&
		   ((uwp[4] > '8') || ((uwp[2] > '3') && (uwp[2] < 'A'))))
		    dm1 = dm2 = 4;
	} else {
		dm1 = *type_roll;
		dm2 = *size_roll;
	}

	// star type
	j = dice.Roll(6, 2, dm1);
	if(j > 12)
		j = 12;
	if(j < 0)
		j = 0;
	if(ndx == 0) {
		*type_roll = j;
		st[0] = primary_type[j];
	} else {
		st[0] = companion_type[j];
	}
	
	// star class			
	st[1] = dice.Roll(10, 1) - 1 + '0';

	// star size
	j = dice.Roll(6, 2, dm2);
	if(j > 12)
		j = 12;
	if(j < 0)
		j = 0;
	if(ndx == 0) {
		*size_roll = j;
		strcpy(&st[2], primary_size[j]);
	} else {
		strcpy(&st[2], companion_size[j]);
	}

	VerifyStar(st);
}

int
GenStar::GenSystemNature(void)
{
int i;

	i = dice.Roll(6, 2);
	if('T' == system_nature[i])
		return(3);
	else if('B' == system_nature[i])
		return(2);
	return(1);
}

void
GenStar::GenComp(char *p, char *st)
{
int type_roll=12,size_roll=12,i;

	for(i = 0;i < MAX_STAR_TABLE_ENTRY;i++) {
		if(p[0] == primary_type[i]) {
			type_roll = i;
			break;
		}
	}

	for(i = 0;i < MAX_STAR_TABLE_ENTRY;i++) {
		if(strcmp(&p[2], primary_size[i]) == 0) {
			size_roll = i;
			break;
		}
	}

	GenerateStar(2, &type_roll, &size_roll, NULL, st);
}

int 
GenStar::GenOrbit(bool trinary)
{
int i,ret;

	i = dice.Roll(6, 2);
	if(trinary)
		i += 4;
	if(i > 12)
		i = 12;

	if('C' == companion_orbit[i])
		return(0);
	if('F' == companion_orbit[i])
		return(20);		// XXX

	ret = companion_orbit[i];
	if(companion_die[i] > '0')
		ret += dice.Roll(6, companion_die[i] - '0');

	return(ret);
}

int 
GenStar::GenMaxOrbits(char *star)
{
int i;

	i = dice.Roll(6, 2);
	if(strcmp(&star[2], "III") == 0)
		i += 4;
	else if((strcmp(&star[2], "Ia") == 0) || (strcmp(&star[2], "Ib") == 0) ||
			(strcmp(&star[2], "II") == 0))
		i += 8;
	if('M' == star[0])
		i -= 4;
	if('K' == star[0])
		i -= 2;

	if(i < 0)
		i = 0;
	if(i > 12)
		i = 12;
	return(max_orbits[i]);
}

void
GenStar::VerifyStar(char *st)
{
// XXX needs a some work
	// last checks
	if(strcmp(&st[2], "IV") == 0) {
		if(('M' == st[0]) || (('K' == st[0]) && (st[1] > '0')))
			strcpy(&st[2], "V");
	}
	if(strcmp(&st[2], "VI") == 0) {
		if(('A' == st[0]) || ('B' == st[0]) || 
					(('F' == st[0]) && (st[1] < '5')))
			strcpy(&st[2], "V");
	}
}

