
/*
 * File:      planet.cpp
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: planet.cpp,v $ $Revision: 1.7 $ $Author: man $ $Date: 2001/12/02 18:18:39 $" */



#include <stdio.h>
#include <string.h>
#include "planet.h"


// ========================================================================
base_planet::base_planet(char *n, char *u, char b,
        unsigned long co, unsigned long cx, char z, char *a) :
	uwp(u)
{
	name = NULL;
	SetName(n);

	bases = b;
	trade_class = co;
	other_class = cx;
	t_zone = z;
//	strcpy(alig, a);
	alig[0] = 0;
	if((a != NULL) && (a[0] != 0)) {
		alig[0] = a[0];
		alig[1] = a[1];
		alig[2] = 0;
	}
}

base_planet::base_planet(base_planet *p) :
	uwp(p)
{
char *ptr;

	ptr = p->GetName();
	name = NULL;
	SetName(ptr);
	bases = p->GetBase();

	trade_class = p->GetTradeCodes();
	other_class = p->GetOtherCodes();

	t_zone = p->GetZone();
	strcpy(alig, p->GetAlleg());
}

base_planet::base_planet(char *n, char *u) :
	uwp(u)
{
	name = NULL;
	SetName(n);
	bases = ' ';
	trade_class = 0l;
	other_class = 0l;
	t_zone = 0;
	sprintf(alig, "Na");	// will this be universal?
}

base_planet::base_planet() :
	uwp()
{
//	uwp_data = NULL;
	name = NULL;
	bases = ' ';
	trade_class = 0l;
	other_class = 0l;
	t_zone = 0;
	sprintf(alig, "Na");	// will this be universal?
}

base_planet::~base_planet()
{
//	if(uwp_data != NULL)
//		delete uwp_data;
	if(name != NULL)
		delete[] name;
}

char *
base_planet::GetName(char *buff)
{
	buff[0] = 0;
	if(name != NULL)
		sprintf(buff, name);
	return(buff);
}

char *
base_planet::GetUWPStr(char *buff)
{
	buff[0] = 0;
//	if(uwp_data != NULL)
//		uwp_data->GetUWPStr(buff);
	uwp::GetUWPStr(buff);
	return(buff);
}

// ========================================================================
main_world::main_world(char *n, short l_x, short l_y, char *u, char b, 
		unsigned long co, unsigned long cx, char z, char *a, short p, 
		short be, short g, char *s1, char *s2, char *s3) :
	base_planet(n, u, b, co, cx, z, a)
{
	loc_x = l_x;
	loc_y = l_y;
	pop_ndx = p;
	belts = be;
	gg = g;

	ParseStars(s1, s2, s3);
	CleanUpParse();
}

main_world::main_world(main_world *mw) :
	base_planet(mw)
{
int i,j;

	loc_x = mw->GetLocX();
	loc_y = mw->GetLocY();
	pop_ndx = mw->GetPopNdx();
	belts = mw->GetNumBelts();
	gg = mw->GetNumGG();

	for(i = 0; i < 3;i++)
		stars[i] = NULL;
	j = mw->GetNumStars();
	for(i = 0;i < j;i++)
		stars[i] = new BaseStar(mw->GetStarType(i), mw->GetStarClass(i), 
			mw->GetStarSize(i));
	CleanUpParse();
}

main_world::main_world() :
	base_planet()
{
int i;

	loc_x = 0;
	loc_y = 0;
	pop_ndx = 0;
	belts = 0;
	gg = 0;
	for(i = 0;i < 3;i++)
		stars[i] = NULL;
}

main_world::main_world(char *n, short l_x, short l_y, 
		char *u, short be, short g, char *s1, char *s2, char *s3) :
	base_planet(n, u)
{
	loc_x = l_x;
	loc_y = l_y;
	pop_ndx = 0;
	belts = be;
	gg = g;

	ParseStars(s1, s2, s3);
	CleanUpParse();
}

main_world::main_world(char *n, short l_x, short l_y, char *u) :
	base_planet(n, u)
{
int i;

	loc_x = l_x;
	loc_y = l_y;
	pop_ndx = 0;
	belts = 0;
	gg = 0;
	for(i = 0;i < 3;i++)
		stars[i] = NULL;
}

main_world::~main_world()
{
int i;

	for(i = 0;i < 3;i++)
		{
		if(stars[i] != NULL)
			delete stars[i];
		}
}

// perform sanity checking
void
main_world::CleanUpParse(void)
{
int i;

	if((pop_ndx < 1) || (pop_ndx > 9))
		pop_ndx = -1;
	if((belts < 0) || (belts > 9))
		belts = -1;
	if((gg < 0) || (gg > 9))
		gg = -1;

	for(i = 0;i < 3;i++) {
		if((stars[i] != NULL) && (!stars[i]->Ok())) {
			delete stars[i];
			stars[i] = NULL;
		}
	}
}

void
main_world::ParseStars(char *s1, char *s2, char *s3)
{
	stars[0] = stars[1] = stars[2] = NULL;
	if((s1 != NULL) && (s1[0] != 0) && (s1[0] != ' ')) {
		stars[0] = new BaseStar(s1);
	}

	if((s2 != NULL) && (s2[0] != 0) && (s2[0] != ' ')) {
		stars[1] = new BaseStar(s2);
	}

	if((s3 != NULL) && (s3[0] != 0) && (s3[0] != ' ')) {
		stars[2] = new BaseStar(s3);
	}
}

char *
main_world::GetStarStr(char *buff)
{
int i;
char lbuff[120];

	buff[0] = 0;
	lbuff[0] = 0;
	for(i = 0;i < 3;i++)
		{
		GetStarStr(i, lbuff);
		}

	sprintf(buff, lbuff);
	return(buff);
}

char *
main_world::GetStarStr(int ndx, char *buff)
{
char lbuff[120];

	if(stars[ndx] != NULL)
		{
		stars[ndx]->GetStarStr(lbuff);
		strcat(buff, lbuff);
		}

	return(buff);
}

int 
main_world::GetNumStars(void)
{
int ret=0;

	if(stars[0] != NULL)
		ret++;
	if(stars[1] != NULL)
		ret++;
	if(stars[2] != NULL)
		ret++;

	return(ret);
}

short 
main_world::GetStarType(int ndx)
{
	if((ndx < 0) || (ndx > 2) || (stars[ndx] == NULL))
		return(-1);
	else 
		return(stars[ndx]->GetStarType());
}

short 
main_world::GetStarSize(int ndx)
{
	if((ndx < 0) || (ndx > 2) || (stars[ndx] == NULL))
		return(-1);
	else 
		return(stars[ndx]->GetStarSize());
}

short 
main_world::GetStarClass(int ndx)
{
	if((ndx < 0) || (ndx > 2) || (stars[ndx] == NULL))
		return(-1);
	else 
		return(stars[ndx]->GetStarClass());
}

BaseStar *
main_world::GetStar(int ndx)
{
	if((ndx < 0) || (ndx > 2) || (stars[ndx] == NULL))
		return(NULL);
	else 
		return(stars[ndx]);
}

void 
main_world::SetStar(int ndx, char *buff)
{
	if((ndx >= 0) || (ndx <= 2)) {
		if(stars[ndx] != NULL) {
			delete stars[ndx];
			stars[ndx] = NULL;
		}
		if(buff != NULL)
			stars[ndx] = new BaseStar(buff);
	}
}

void 
main_world::SetStar(int ndx, int t, int c, int s)
{
	if((ndx >= 0) || (ndx <= 2)) {
		if(stars[ndx] != NULL) {
			delete stars[ndx];
			stars[ndx] = NULL;
		}
		if((t > 0) && (s > 0) && (c > 0))
			stars[ndx] = new BaseStar(t, c, s);
	}
}

// ========================================================================
planet::planet() :
	base_planet()
{
//	orbit = -1.0;
//	sndx = -1;
	sys_flags = 0l;
}

planet::planet(planet *p):
	base_planet(p)
{
//	orbit = p->GetOrbit();
//	sndx = p->GetSndx();
	sys_flags = p->GetSysFlags();
}

//planet::planet(short s, float o, char *n, char *u, unsigned long f):
planet::planet(char *n, char *u,  char b, unsigned long co, unsigned long cx, 
        unsigned long cs, char z, char *a) :
	base_planet(n, u, b, co, cx, z, a)
{
//	orbit = 0;
//	sndx = s;
	sys_flags = cs;
}

planet::~planet()
{
}

void
base_planet::SetName(char *n)
{
    if(name != NULL)
	    delete[] name;

	name = NULL;

	if((n != NULL) && (strlen(n) > 0))
	    {
		name = new char[strlen(n) + 1];
		strcpy(name, n);
		}
}

void
base_planet::SetAlleg(char *a)
{
    alig[0] = a[0];
	alig[1] = a[1];
	alig[2] = 0;
}

// ========================================================================
void 
base_planet::SetPortVal(short v)
{
    if(port == NULL)
	    port = new port_desc(v);
	else
	    port->set_port_val(v);
}
void 
base_planet::SetSizeVal(short v)
{
    if(size == NULL)
	    size = new size_desc(v);
	else
	    size->set_t_hex_val(v);
}
void 
base_planet::SetAtmosVal(short v)
{
    if(atmos == NULL)
	    atmos = new atmos_desc(v);
	else
	    atmos->set_t_hex_val(v);
}
void 
base_planet::SetHydroVal(short v)
{
    if(hydro == NULL)
	    hydro = new hydro_desc(v);
	else
	    hydro->set_t_hex_val(v);
}
void 
base_planet::SetPopVal(short v)
{
    if(pop == NULL)
	    pop = new pop_desc(v);
	else
	    pop->set_t_hex_val(v);
}
void 
base_planet::SetGovtVal(short v)
{
    if(govt == NULL)
	    govt = new govt_desc(v);
	else
	    govt->set_t_hex_val(v);
}
void 
base_planet::SetLawVal(short v)
{
    if(law == NULL)
	    law = new law_desc(v);
	else
	    law->set_t_hex_val(v);
}
void 
base_planet::SetTechVal(short v)
{
    if(tech == NULL)
	    tech = new tech_desc(v);
	else
	    tech->set_t_hex_val(v);
}

