
/*
 * File:      basestar.cpp
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: basestar.cpp,v $ $Revision: 1.6 $ $Author: man $ $Date: 2003/11/02 01:53:55 $" */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "basestar.h"

// XXX
#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

char BaseStar::types[MAX_STAR_TYPES+2] =  
{ "OBAFGKM" };
//char BaseStar::types[MAX_STAR_TYPES] =  { "BAFGKM" };
char BaseStar::sizes[MAX_STAR_SIZES+1][4] = {
	"Ia", 
	"Ib", 
	"II", 
	"III", 
	"IV", 
	"V", 
	"VI", 
	"D"
};

char *BaseStar::colors[MAX_STAR_TYPES+1] = {
	"Dark Blue",
	"Blue",
	"Light Blue",
	"White",
	"Yellow",
	"Orange",
	"Red"
};

BaseStar::BaseStar()
{
	type = MAX_STAR_TYPES;
	cls = 9;
	size = MAX_STAR_SIZES;
	Check();
}

BaseStar::BaseStar(int t, int c, int s)
{
	type = t;
	cls = c;
	size = s;
	Check();
}

BaseStar::BaseStar(char *buff)
{
	SetStarParams(buff);
}

BaseStar::BaseStar(BaseStar *bs)
{
	type = bs->GetStarType();
	cls = bs->GetStarClass();
	size = bs->GetStarSize();
	Check();
}

bool
BaseStar::Ok(void)
{
	if((type < 0) || (type > MAX_STAR_TYPES) ||
			(cls < 0) || (cls >= 10) ||
			(size < 0) || (size > MAX_STAR_SIZES))
		return(FALSE);
	return(TRUE);
}

char *
BaseStar::GetStarStr(char *buff)
{
	sprintf(buff, "%c%d%s ", types[type], cls, sizes[size]);
	return(buff);
}

char *
BaseStar::GetColor(char *buff)
{
	strcat(buff, colors[type]);
	return(buff);
}

char *
BaseStar::GetDesc(char *buff)
{
	buff[0] = 0;
	if(size < 7)
		GetColor(buff);

	switch(size) {
		case 0:
		case 1:
			strcat(buff, " Supergiant");
			break;
		case 2:
		case 3:
			strcat(buff, " Giant");
			break;
		case 4:
			strcat(buff, " Subgiant");
			break;
		case 5:
			strcat(buff, " Main Sequence Star");
			break;
		case 6:
			strcat(buff, " Subdwarf");
			break;
		case 7:
			strcat(buff, "White Dwarf");
			break;
	}

	return(buff);
}

// --------------------------------------------------------------------------
// Set functions
// NOTE:  using the individual ones could cause some problems.
// for example, say it starts at M5III, and want to change to 
// G5IV.  Changing the size may prematurely make a change not
// expected.  for this reason use SetStarParams(), which will
// not make the check until after the change.
void 
BaseStar::SetStarType(int t) 
{ 
	type = t; 
	Check();
}

void 
BaseStar::SetStarClass(int c) 
{ 
	cls = c; 
	Check();
}

void 
BaseStar::SetStarSize(int s) 
{ 
	size = s;
	Check();
}

void 
BaseStar::SetStarParams(int t, int c, int s)
{
	type = t;
	cls = c;
	size = s;
	Check();
}

void 
BaseStar::SetStarParams(char *buff)
{
int i,j;

	type = cls = size = 0;
	for(i = 0; i <= MAX_STAR_TYPES;i++) {
		if(toupper(buff[0]) == types[i]) {
			type = i;
			break;
		}
	}

	j = 1;
	if(buff[j] == ' ')
		j++;
	cls = buff[j] - '0';

	j++;
	if(buff[j] == ' ')
		j++;
	// sometimes D is VII......
	if(strcmp("VII", &buff[j]) == 0)
		size = 7;
	else {
		for(i = 0; i < (MAX_STAR_SIZES + 1);i++) {
			if(strncmp(&buff[j], sizes[i], strlen(sizes[i])) == 0)
				size = i;
		}
	}
//fprintf(stderr, "SetStarParams(%s) %d %d %d", buff, type, cls, size);
	Check();
//fprintf(stderr, " --> %d %d %d\n", type, cls, size);
}

void
BaseStar::Check(void)
{
//fprintf(stderr, "Check():  t:%d c:%d s:%d --> ", type, cls, size);
	// obvious checks
	if(type < 0)
		type = 0;
	if(cls < 0)
		cls = 0;
	if(size < 0)
		size = 0;
	if(type > MAX_STAR_TYPES)
		type = MAX_STAR_TYPES;
	if(cls > 9)
		cls = 9;
	if(size > MAX_STAR_SIZES)
		size = MAX_STAR_SIZES;

	// type O only has sizes Ia, Ib, and V
	//   and the class is never less than 4
	// if O is specified, change the type to the nearest available size
	// make sure the class is greater than 3
	if(type < 1) {
		if((2 == size) || (3 == size))
			size = 1;
		else if((4 == size) || (size > 5))
			size = 5;
		if(cls < 4)
			cls = 4;
	}

	// size VI cannot have type O (already handled), B, or F < class 5
	if(6 == size) {
		if(type < 3)
			type = 3;
		if((3 == type) && (cls < 5))
			cls = 5;
	}

	// type IV cannot have Thpe M or K > 0
	if(4 == size) {
		if(type > 5)
			type = 5;
		if((5 == type) && (cls > 0))
			cls = 0;
	}
//fprintf(stderr, "t:%d c:%d s:%d\n", type, cls, size);
}

