
/*
 * File:      basesect.cpp
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: basesect.cpp,v $ $Revision: 1.23 $ $Author: man $ $Date: 2002/10/07 17:09:27 $" */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#define __USE_GNU
#include <string.h>
#include "str_util.h"
#include "basesect.h"

#define DEFAULT_NAME_LENGTH			14
#define DEFAULT_HEX_START			15
#define	DEFAULT_UWP_START			19
#define DEFAULT_BASE_POS			30
#define DEFAULT_CODE_START			32
#define DEFAULT_ZONE_POS			48
#define DEFAULT_PBG_START			51
#define DEFAULT_ALLEG_START			55
#define DEFAULT_STELLAR_START		58
#define DEFAULT_LENGTH				80


#define BIG_BUFFER_SIZE		120
#define REALBIG_BUFFER		1024

// =================================================================
HexExtraData::HexExtraData(HexExtraData *hed)
{
	title = desc = bm = NULL;
	bm_index = hed->GetIndex();
	if(hed->GetTitle() != NULL) {
		title = new char[strlen(hed->GetTitle()) + 1];
		strcpy(title, hed->GetTitle());
	}
	if(hed->GetDesc() != NULL) {
		desc = new char[strlen(hed->GetDesc()) + 1];
		strcpy(desc, hed->GetDesc());
	}
	if(hed->GetBM() != NULL) {
		bm = new char[strlen(hed->GetBM()) + 1];
		strcpy(bm, hed->GetBM());
	}
}

HexExtraData::HexExtraData(char *t, char *d, char *b)
{
	title = desc = bm = NULL;
	bm_index = -1;
	if((t != NULL) && (t[0] != 0)) {
		title = new char[strlen(t) + 1];
		strcpy(title, t);
	}
	if((d != NULL) && (d[0] != 0)) {
		desc = new char[strlen(d) + 1];
		strcpy(desc, d);
	}
	if((b != NULL) && (b[0] != 0)) {
		bm = new char[strlen(b) + 1];
		strcpy(bm, b);
	}
}

HexExtraData::~HexExtraData()
{
	if(title != NULL)
		delete title;
	if(desc != NULL)
		delete desc;
	if(bm != NULL)
		delete bm;
}

// =================================================================
Route::Route(short x_, short y_, short col) :
	ListData()
{
	x = x_;
	y = y_;
	color = col;
}
// =================================================================
HexData::HexData()
{
int i;

	world = NULL;
	routes = new LinkedList();
	layout = NULL;
	for(i = 0;i < 6;i++)
		border_ndx[i] = -1;
	cp = NULL;
}

HexData::HexData(HexData *hd)
{
int i;
Route *r,*r1;
ListNode *n;

	if(hd->world != NULL)
		world = new main_world(hd->world);
	else
		world = NULL;

	routes = new LinkedList();
	n = hd->routes->First();
	while(n != NULL) {
		r = (Route *)n->Data();
		r1 = new Route(r->x, r->y, r->color);
		routes->Append(r1);
		n = hd->routes->Next();
	}

	if(hd->layout != NULL)
		layout = new HexLayout(hd->layout);
	for(i = 0;i < 6;i++)
		border_ndx[i] = hd->border_ndx[i];

	if(hd->cp != NULL)
		cp = new HexExtraData(hd->cp);
	else
		cp = NULL;
}

HexData::HexData(LinkedList *r)
{
int i;

	world = NULL;
	routes = r;
	layout = NULL;
	for(i = 0;i < 6;i++)
		border_ndx[i] = -1;
	cp = NULL;
}

HexData::~HexData()
{
Route *r;
ListNode *n;

	if(world != NULL)
		delete world;
	if(routes != NULL) {
		n = routes->First();
		while(n != NULL) {
			r = (Route *)n->Data();
			delete r;
			routes->DeleteNode(n);
			n = routes->First();
		}
		delete routes;
	}
	if(layout != NULL)
		delete layout;
	if(cp != NULL)
		delete cp;
}

void 
HexData::AddRoute(short x_, short y_, short col)
{
Route *r;

	r = new Route(x_, y_, col);

	routes->Append(r);
}

void 
HexData::AddBorder(short which, short col)
{
	if((which > -1) && (which < 6))
		border_ndx[which] = col;
}

void 
HexData::AddCP(char *t, char *d, char *b)
{
	if(cp != NULL) {
		delete cp;
		cp = NULL;
	}
	cp = new HexExtraData(t, d, b);
}

// =========================================================================
BaseSector::BaseSector(TCodes *sc)
{
	InitSector();

	codes = sc;

	border_list = new ColorTable();
	route_list = new ColorTable();
}

BaseSector::~BaseSector()
{
	Clear();
}

// intermediate initialization
void 
BaseSector::InitSector(void)
{
int i,j;

	name = NULL;
	alt_name = NULL;
	dat_name = NULL;
	sec_name = NULL;

	parse_params[0] = DEFAULT_NAME_LENGTH;
	parse_params[1] = DEFAULT_HEX_START;
	parse_params[2] = DEFAULT_UWP_START;
	parse_params[3] = DEFAULT_BASE_POS;
	parse_params[4] = DEFAULT_CODE_START;
	parse_params[5] = DEFAULT_ZONE_POS;
	parse_params[6] = DEFAULT_PBG_START;
	parse_params[7] = DEFAULT_ALLEG_START;
	parse_params[8] = DEFAULT_STELLAR_START;
	parse_params[9] = DEFAULT_LENGTH;

	for(i = 0;i < MAX_X_HEX;i++)
		for(j = 0;j < MAX_Y_HEX;j++)
			hexes[i][j] = NULL;

	for(i = 0;i < MAX_SS;i++)
		ss_names[i] = NULL;
}

// intermediate clean-up
//	for between file snacks (ha-ha)
void 
BaseSector::Clear(void)
{
int i,j;

	for(i = 0;i < MAX_X_HEX;i++)
		for(j = 0;j < MAX_Y_HEX;j++)
			if(hexes[i][j] != NULL) {
				delete hexes[i][j];
				hexes[i][j] = NULL;
			}

	if(name != NULL) {
		delete[] name;
		name = NULL;
	}

	if(alt_name != NULL) {
		delete[] alt_name;
		alt_name = NULL;
	}
	if(dat_name != NULL) {
		delete[] dat_name;
		dat_name = NULL;
	}
	if(sec_name != NULL) {
		delete[] sec_name;
		sec_name = NULL;
	}

	for(i = 0;i < MAX_SS;i++)
		if(ss_names[i] != NULL) {
			delete[] ss_names[i];
			ss_names[i] = NULL;
		}
}

// -------------------------------------------------------------------------
// checkers
bool 
BaseSector::HasWorld(int x, int y)
{
	if(hexes[x][y] == NULL)
		return(FALSE);
	if(hexes[x][y]->world == NULL)
		return(FALSE);

	return(TRUE);
}

int 
BaseSector::ValidLoc(char *buff, short *x, short *y)
{
int i;
int j=0;


	if(strlen(buff) == 0)
		return(0);
	for(i = 0;i < (int)strlen(buff);i++) {
		if(!isdigit(buff[i]))
			return(0);

		j *= 10;
		j += (buff[i] - '0');
	}

	*x = j / 100;
	*y = j - (*x * 100);

	return(1);
}

HexData *
BaseSector::GetHex(int x, int y)
{
	if((x < 0) || (y < 0) || (x > MAX_X_HEX) || (y > MAX_Y_HEX))
		return(NULL);

	return(hexes[x][y]);
}

int 
BaseSector::ParseFirst(char *buff)
{
int ret=0;
char *ptr;

	ptr = buff;
	// first, find the first number
	while(!isdigit(*ptr))
		ptr++;

	// now, parse while we can
	while(isdigit(*ptr)) {
		ret *= 10;
		ret += (*ptr - '0');
		ptr++;
	}

	return(ret);
}

int 
BaseSector::ParseSecond(char *buff)
{
char *ptr;

	ptr = buff;
	// find #'s
	while(!isdigit(*ptr))
		ptr++;
	//skip this one
	while(isdigit(*ptr))
		ptr++;
	// return this one (
	return(ParseFirst(ptr));
}

// -------------------------------------------------------------------------
// specific parsing routines:
int 
BaseSector::LoadFile(char *file_name)
{
FILE *fpx;
int j;

	if((fpx = fopen(file_name, "r")) == NULL)
		return(-1);

	Clear();
	codes->ClearLocal();
	route_list->Clear();
	border_list->Clear();
    sec_name = new char[strlen(file_name) + 1];
	strcpy(sec_name, file_name);
	if((j = LoadSector(fpx)) > 0) {
		char *s;

		fclose(fpx);
		// load aux file
        dat_name = new char[strlen(sec_name) + 5];
		strcpy(dat_name, sec_name);
		if((s = strcasestr(dat_name, ".sec")) != NULL)
			*s = '\0';
		strcat(dat_name, ".dat");
		if((fpx = fopen(dat_name, "r")) != NULL) {
			LoadAuxSector(fpx);
			fclose(fpx);
		}
	} else fclose(fpx);
	return(j);
}

int 
BaseSector::LoadSector(FILE *fpx)
{
char buff[BIG_BUFFER_SIZE];
int i;
int count=0;

	while(fgets(buff, BIG_BUFFER_SIZE, fpx) != NULL) {
		// strip off the ^%^*&*%^&* new line
		if(buff[strlen(buff) - 1] == '\n')
			buff[strlen(buff) - 1] = 0;
		strstrip(buff, TRUE);
		// have anything?
		if(strlen(buff) == 0)
			continue;
		// try to parse it
		if(ParseAndAddWorld(buff))
			count++;
		// is it format info?
		// Name?
		else if(strstr(buff, "Name"))
			parse_params[0] = ParseSecond(buff);
		// Hex Nbr?
		else if(strstr(buff, "HexNbr"))
			parse_params[1] = ParseFirst(buff);
		// UWP?
		else if(strstr(buff, "UWP"))
			parse_params[2] = ParseFirst(buff);
		// Bases?
		else if(strstr(buff, "Bases"))
			parse_params[3] = ParseFirst(buff);
		// Codes?
		else if(strstr(buff, "Codes"))
			parse_params[4] = ParseFirst(buff);
		// Zone?
		else if(strstr(buff, "Zone"))
			parse_params[5] = ParseFirst(buff);
		// PBG?
		else if(strstr(buff, "PBG"))
			parse_params[6] = ParseFirst(buff);
		// Alleg?
		else if(strstr(buff, "Alleg"))
			parse_params[7] = ParseFirst(buff);
		// Stellar?
		else if(strstr(buff, "Stellar"))
			parse_params[8] = ParseFirst(buff);
		// unknown!
		// throw it out
		for(i = 0;i < BIG_BUFFER_SIZE;i++)
			buff[i] = 0;
	}

	return(count);
}

char *
BaseSector::ParseStar(char *src, char *dest)
{
int i=0,j=0;

	if(src[0] == 0)
		return(NULL);

	dest[i] = 0;
	while(src[j] != 0) {
		if(src[j] == ' ') {
			// sometimes there's a space before the class....
			if(j > 2) {
				while((src[j] == ' ') && (src[j] != 0))
					j++;
				return(&src[j]);
			}
		} else {
			dest[i] = src[j];
			i++;
			dest[i] = 0;
		}
		j++;
	}
	
	return(NULL);	
}

void 
BaseSector::ParseCodes(char *src, unsigned long *co, unsigned long *cu)
{
unsigned long i=0;
char *ptr;
CodeTableEntry *ct;
TradeTable *trade_table;
CodeTable *other_table;
ListNode *n;

	*co = *cu = 0l;
	trade_table = codes->GetTradeTable();
	other_table = codes->GetOtherTable();

	i = 1l;
	n = trade_table->First();
	while((n != NULL) && (i != 0)) {
		ct = (CodeTableEntry *)n->Data();
		if(((ptr = ct->GetCode()) != NULL) && (strcasestr(src, ptr)))
			*co |= i;
		i *= 2;
		n = n->Next();
	}

	i = 1l;
	n = other_table->First();
	while((n != NULL) && (i != 0)) {
		ct = (CodeTableEntry *)n->Data();
		if(((ptr = ct->GetCode()) != NULL) && (strcasestr(src, ptr)))
			*cu |= i;
		i *= 2;
		n = n->Next();
	}
}


int 
BaseSector::ParseAndAddWorld(char *buff)
{
char n[120];	// name;
short l_x,l_y;
char u[13];		// uwp;
char b;			// base;
char c[120];		// temp codes;
unsigned long co;	// codes;
unsigned long cx;	// user codes;
char z;			// zone;
char a[3];		// alleg;
short p;		// pop ndx
short be;		// belts
short g;		// gas giants
char s[3][20];	// stellar data;
int i,j;
char *ptr;


// do quick stuff first
// is the string long enough?
//	if((int)strlen(buff) < (parse_params[ALLEG_START] + 1))
//		return(0);
// is there a _valid_ location?
	// NOTE: (mis)use the n array here
	j = parse_params[HEX_START] - 1;
	for(i = 0;i < 4;i++)
		n[i] = buff[i+j];
	n[i] = 0;
	l_x = l_y = 0;
	if((!ValidLoc(n, &l_x, &l_y)) ||
	   (l_x < 1) || (l_x >  MAX_X_HEX) ||
	   (l_y < 1) || (l_y > MAX_Y_HEX))
		return(0);
// fell thru, it should be a world description
// start w/ the name;
	for(i = 0;i < parse_params[NAME_LENGTH];i++)
		n[i] = buff[i];
	n[i] = 0;
	strstrip(n, FALSE);

// already did this.....
//	l = parse_first(&buff[parse_params[1]]);
//	l_x = l / 100;
//	l_y = l - (l_x * 100);

// grab the uwp
	i = 0;
	j = parse_params[UWP_START] - 1;
	while(buff[j] != ' ') {
		if(isalnum(buff[j])) {
			u[i] = buff[j];
			i++;
		}
		j++;
	}
	u[i] = 0;

// the base code
	b = buff[parse_params[BASE_POS] - 1];

// the trade codes
	co = cx = 0l;
	i = 0;
	j = parse_params[CODE_START] - 1;
	while(j < parse_params[ZONE_POS] - 1) {
		c[i] = buff[j];
		i++;
		j++;
	}
	c[i] = 0;	
	ParseCodes(c, &co, &cx);
	
// travel zone
	z = buff[parse_params[ZONE_POS] - 1];

// alleg
	j = parse_params[ALLEG_START] - 1;
	for(i = 0;i < 2;i++) {
		a[i] = buff[j];
		j++;
	}
	a[i] = 0;

// pop; belts; gg
	j = parse_params[PBG_START] - 1;
	p = buff[j+0] - '0';
	be = buff[j+1] - '0';
	g = buff[j+2] - '0';

// stars
	i = 0;
	j = parse_params[STELLAR_START] - 1;
	ptr = &buff[j];
	j = 0;
	s[0][0] = s[1][0] = s[2][0] = 0;
	while((ptr = ParseStar(ptr, s[j++])) != NULL);

//fprintf(stderr, "%d %d %s %s %c %c %s %d %d %d %s %s %s\n",
//	l_x, l_y, n, u, b, z, a, p, be, g, s[0], s[1], s[2]);
	hexes[l_x-1][l_y-1] = new HexData();
	hexes[l_x-1][l_y-1]->world = new main_world(n, l_x, l_y,
		u, b, co, cx, z, a, p, be, g, s[0], s[1], s[2]);
#if 0
char n[120];	// name;
short l;		// loc;
short l_x,l_y;
char u[13];		// uwp;
char b;			// base;
char c[18];		// codes;
char z;			// zone;
char a[3];		// alleg;
short p;		// pop ndx
short be;		// belts
short g;		// gas giants
char s[3][20];	// stellar data;
#endif

	return(1);
}

void 
BaseSector::ParseAndAddSS(char *buff)
{
GenericParse gp;
char *buffs[3];
int ndx;

	gp.Parse(buff, buffs, 3);

	ndx = -1;
	if((buffs[1][0] >= 'A') || (buffs[1][0] <= 'P'))
		ndx = buffs[1][0] - 'A';
	else if((buffs[1][0] >= 'a') || (buffs[1][0] <= 'p'))
		ndx = buffs[1][0] - 'a';

	if((ndx > -1) && (ndx < MAX_SS)) {
		if(ss_names[ndx] != NULL)
			delete[] ss_names[ndx];
		ss_names[ndx] = new char[strlen(buffs[2]) + 1];
		strcpy(ss_names[ndx], buffs[2]);
	}
}

// P:2825:B Niobe Neb.:Gaseous Nebula from Nova:Star
void 
BaseSector::ParseAndAddCP(char *buff)
{
GenericParse gp;
char *buffs[6];
short x,y;

	gp.Parse(buff, buffs, 6);
	
	x = y = 0;
	if((ValidLoc(buffs[1], &x, &y)) && 
		(x > 0) && (x <= MAX_X_HEX) &&
		(y > 0) && (y <= MAX_Y_HEX)) {
		if(NULL == hexes[x-1][y-1] )		
			hexes[x-1][y-1] = new HexData();

		hexes[x-1][y-1]->AddCP(buffs[2], buffs[3], buffs[4]);
	}
}

void 
BaseSector::LoadAuxSector(FILE *fpx)
{
CodeTable *ct;
BaseTable *bt;
char buff[BIG_BUFFER_SIZE],*ptr;
int i;

	ct = codes->GetAllegTable();
	bt = codes->GetBaseTable();
	while(fgets(buff, BIG_BUFFER_SIZE, fpx) != NULL) {
		// strip off the ^%^*&*%^&* new line
		if(buff[strlen(buff) - 1] == '\n')
			buff[strlen(buff) - 1] = 0;
//fprintf(stderr, "%s\n", buff);
		switch(buff[0]) {
			// name
			case 'N':
			case 'n':
				ptr = &buff[2];
				strstrip(ptr, TRUE);
				if(name != NULL)
					delete[] name;
				name = new char[strlen(ptr) + 1];
				strcpy(name, ptr);
				break;
			// name
			case 'M':
			case 'm':
				ptr = &buff[2];
				strstrip(ptr, TRUE);
				if(alt_name != NULL)
					delete[] alt_name;
				alt_name = new char[strlen(ptr) + 1];
				strcpy(alt_name, ptr);
				break;
			// borders
			case 'B':
			case 'b':
				ParseAndAddBorder(buff);
				break;
			// routes
			case 'R':
			case 'r':
				ParseAndAddRoute(buff);
				break;
			// subsectors
			case 'S':
			case 's':
				ParseAndAddSS(buff);
				break;
			// cp's
			case 'P':
			case 'p':
				ParseAndAddCP(buff);
				break;
			// colors
			case 'C':
			case 'c':
//				ParseAndAddColor(buff);
				break;
			// captions
			case 'T':
			case 't':
				if((buff[2] == 'R') || (buff[2] == 'r'))
					ParseAndAddRouteList(&buff[2]);
				else if((buff[2] == 'B') || (buff[2] == 'B'))
					ParseAndAddBorderList(&buff[2]);

				break;
			case 'E':
			case 'e':
//				bt->ParseAndAddBase(buff, TRUE);
				bt->Load(&buff[2], TRUE);
				break;
			case 'A':
			case 'a':
//				ct->ParseAndAddCode(buff, TRUE);
				ct->Load(&buff[2], TRUE);
				break;
			// layout
			case 'L':
			case 'l':
				ParseAndAddLayout(&buff[2]);
				break;
			// route/border filter
			case 'V':
			case 'v':
				ParseAndAddRBFilter(&buff[2]);
				break;
			default:
				// error messages?
				break;
		}
		for(i = 0;i < BIG_BUFFER_SIZE;i++)
			buff[i] = 0;
	}
}

void 
BaseSector::ParseAndAddRoute(char *buff)
{
GenericParse gp;
char *buffs[5];
short x,y,x_,y_,color;

	gp.Parse(buff, buffs, 5);
	
	x = y = 0;
	if((ValidLoc(buffs[1], &x, &y)) && 
		(x > 0) && (x <= MAX_X_HEX) &&
		(y > 0) && (y <= MAX_Y_HEX)) {
		x_ = atoi(buffs[2]);
		y_ = atoi(buffs[3]);
		if(((color = atoi(buffs[4])) < 0) || (color < 0))
			color = 0;

		if(NULL == hexes[x-1][y-1] )		
			hexes[x-1][y-1] = new HexData();
		hexes[x-1][y-1]->AddRoute(x_ - 1, y_ - 1, color);
	}
}

void 
BaseSector::ParseAndAddBorder(char *buff)
{
GenericParse gp;
char *buffs[4];
short x,y,ndx,color;

	gp.Parse(buff, buffs, 4);
	
	x = y = 0;
	if((ValidLoc(buffs[1], &x, &y)) && 
		(x > 0) && (x <= MAX_X_HEX) &&
		(y > 0) && (y <= MAX_Y_HEX)) {
		ndx = *buffs[2] - '0';
		if(((color = atoi(buffs[3])) < 0) || (color < 0))
			color = -1;

		if(hexes[x-1][y-1] == NULL)		
			hexes[x-1][y-1] = new HexData();

		hexes[x-1][y-1]->AddBorder(ndx, color);
	}
}

void
BaseSector::ParseAndAddBorderList(char *buff)
{
GenericParse gp;
char *buffs[3];
int i;

	gp.Parse(buff, buffs, 3);

	i = -1;
	if(((i = atoi(buffs[1])) < 0) || (i < 0))
		i = -1;

		border_list->AddColor(i, buffs[2]);
}

void 
BaseSector::ParseAndAddRouteList(char *buff)
{
GenericParse gp;
char *buffs[3];
int i;

	gp.Parse(buff, buffs, 3);
	
	i = -1;
	if(((i = atoi(buffs[1])) < 0) || (i < 0))
		i = -1;

	if(i >= 0)
		route_list->AddColor(i, buffs[2]);
}

void
BaseSector::ParseAndAddColor(char *buff)
{
GenericParse gp;
char *buffs[4];
int r,g,b;

	gp.Parse(buff, buffs, 4);
	r = atoi(buffs[1]);
	g = atoi(buffs[2]);
	b = atoi(buffs[3]);
}

void 
BaseSector::ParseAndAddLayout(char *buff)
{
bool have_filter=FALSE;
HEX_DISPLAY hdisp;
char *ptrs[6];
unsigned char filter;
int i,x1=-1,y1=-1,x2,y2;
HexLayout *hl;
HexData *hd;
GenericParse gp;

	i = gp.Parse(buff, ptrs, 6);
	if(i < 4) {
		x2 = atoi(ptrs[0]);
		y2 = atoi(ptrs[1]);
		hdisp = (HEX_DISPLAY) atoi(ptrs[2]);
	} else if(i < 5) {
		x2 = atoi(ptrs[0]);
		y2 = atoi(ptrs[1]);
		hdisp = (HEX_DISPLAY) atoi(ptrs[2]);
		filter = (unsigned char) atoi(ptrs[3]);
		have_filter = TRUE;
	} else if(i < 6) {
		x1 = atoi(ptrs[0]);
		y1 = atoi(ptrs[1]);
		x2 = atoi(ptrs[2]);
		y2 = atoi(ptrs[3]);
		hdisp = (HEX_DISPLAY) atoi(ptrs[4]);
	} else {
		x1 = atoi(ptrs[0]);
		y1 = atoi(ptrs[1]);
		x2 = atoi(ptrs[2]);
		y2 = atoi(ptrs[3]);
		hdisp = (HEX_DISPLAY) atoi(ptrs[4]);
		filter = (unsigned char) atoi(ptrs[5]);
		have_filter = TRUE;
	}

	// some sanity checking....
	if((x2 < 0) || (x2 >= MAX_LAYOUT_X) || (y2 < 0) || (y2 >= MAX_LAYOUT_Y) ||
			(hdisp < 0) || (hdisp > HD_MW_HYDRO_BM))
		return;

	if((hd = GetHex(x1, y1)) != NULL) {
		if((hl = hd->layout) == NULL)
			hl = hd->layout = new HexLayout();
	} else {
		hl = &layout;
	}

	hl->SetCode(x2, y2, hdisp);
	if(have_filter)
		hl->SetUWPFilter(filter);
}

void 
BaseSector::ParseAndAddRBFilter(char *buff)
{
}

// -------------------------------------------------------------------------
char *
BaseSector::GetListing(short x_, short y_, char *buff)
{
HexData *hd;
main_world *world;
char lbuff[120];

	buff[0] = 0;
	if((hd = GetHex(x_, y_)) != NULL) {
		if((world = hd->world) != NULL) {
			sprintf(buff, "%s", world->GetName(lbuff));
			strfixsize(buff, parse_params[HEX_START]);
			sprintf(lbuff, "%02d%02d", x_ + 1, y_ + 1);
			strcat(buff, lbuff);
			strfixsize(buff, parse_params[UWP_START]);
			strcat(buff, world->GetUWPStr(lbuff));
			sprintf(lbuff, " %c ", world->GetBase());
			strcat(buff, lbuff);

			GetCodeStr(world, lbuff);
			strcat(buff, lbuff);
			strfixsize(buff, parse_params[ZONE_POS]+1);

			sprintf(lbuff, "%c ", world->GetZone());
			strcat(buff, lbuff);
			if(world->GetPopNdx() < 0)
				sprintf(lbuff, " ");
			else
				sprintf(lbuff, "%d", world->GetPopNdx());
			strcat(buff, lbuff);
			if(world->GetNumBelts() < 0)
				sprintf(lbuff, " ");
			else
				sprintf(lbuff, "%d", world->GetNumBelts());
			strcat(buff, lbuff);
			if(world->GetNumGG() < 0)
				sprintf(lbuff, "  ");
			else
				sprintf(lbuff, "%d ", world->GetNumGG());
			strcat(buff, lbuff);
			sprintf(lbuff, "%s ", world->GetAlleg());
			strcat(buff, lbuff);

			world->GetStarStr(lbuff);
			strcat(buff, lbuff);
		}
	}

	return(buff);
}

char *
BaseSector::GetCodeStr(main_world *world, char *buff)
{
CodeTable *ct;
TradeTable *tt;
CodeTableEntry *cte;
unsigned long code,l;
ListNode *n;

	buff[0] = 0;
	// walk thru the code tables and get any that are there
	l = 1l;
	tt = codes->GetTradeTable();
	code = world->GetTradeCodes();
	n = tt->First();
	while((n != NULL) && (l != 0)) {
		cte = (CodeTableEntry *)n->Data();
		if(code & l) {
			strcat(buff, cte->GetCode());
			strcat(buff, " ");
		}
		l *= 2;
		n = n->Next();
	}
	l = 1l;
	ct = codes->GetOtherTable();
	code = world->GetOtherCodes();
	n = ct->First();
	while((n != NULL) && (l != 0)) {
		cte = (CodeTableEntry *)n->Data();
		if(code & l) {
			strcat(buff, cte->GetCode());
			strcat(buff, " ");
		}
		l *= 2;
		n = n->Next();
	}

	return(buff);
}

// -------------------------------------------------------------------------
char *
BaseSector::GetSSName(int s)
{
	if((s < 0) || (s > MAX_SS))
		return(NULL);
	return(ss_names[s]);
}

void
BaseSector::SetSSName(int n, char *buff)
{
	if(ss_names[n] != NULL) {
		if((buff != NULL) && (buff[0] != 0)) {
			if(strcmp(buff, ss_names[n]) != 0) {
				delete[] ss_names[n];
				ss_names[n] = new char[strlen(buff) + 1];
				strcpy(ss_names[n], buff);
			}
		} else {
			delete[] ss_names[n];
			ss_names[n] = NULL;
		}
	} else {
		if((buff != NULL) && (buff[0] != 0)) {
			ss_names[n] = new char[strlen(buff) + 1];
			strcpy(ss_names[n], buff);
		}
	}
}

void
BaseSector::SetName(char *buff)
{
	if(name != NULL) {
		delete name;
		name = NULL;
	}

	if((buff != NULL) && (buff[0] != 0)) {
		name = new char[strlen(buff) + 1];
		strcpy(name, buff);
	}
}

// -------------------------------------------------------------------------
HexData *
BaseSector::GetAdjHex(int x, int y, int h)
{
int n_x,n_y;

	if(!GetAdjCoord(x, y, h, &n_x, &n_y))
		return(NULL);

	return(hexes[n_x][n_y]);
}

bool 
BaseSector::GetAdjCoord(int x, int y, int h, int *_x, int *_y)
{
	return(TranslateCoord(x, y, h, 1, _x, _y));
}

bool
BaseSector::TranslateCoord(int x, int y, int dir, int mag, int *_x, int *_y)
{
	*_x = x;
	*_y = y;
	switch(dir) {
		case 0:
			*_y -= mag;
			break;
		case 1:
			*_x += mag;
			*_y -= (mag / 2);
			if((0 == (x & 1)) && (mag & 1))
				*_y -= 1;
			else if((x & 1) && (0 == (mag & 1)))
				*_y -= 1;
			break;
		case 2:
			*_x += mag;
			*_y += (mag / 2);
			if((0 == (x & 1)) && (0 == (mag & 1)))
				*_y += 1;
			else if((x & 1) && (mag & 1))
				*_y += 1;
			break;
		case 3:
			*_y += mag;
			break;
		case 4:
			*_x -= mag;
			*_y -= (mag / 2);
			if((0 == (x & 1)) && (0 == (mag & 1)))
				*_y += 1;
			else if((x & 1) && (mag & 1))
				*_y += 1;
			break;
		case 5:
			*_x -= mag;
			*_y += (mag / 2);
			if((0 == (x & 1)) && (mag & 1))
				*_y -= 1;
			else if((x & 1) && (0 == (mag & 1)))
				*_y -= 1;
			break;
		default:
			return(FALSE);
			break;
	}

	if((*_x < 0) || (*_y < 0) || (*_x >= MAX_X_HEX) || (*_y >= MAX_Y_HEX))
		return(FALSE);
	
	return(TRUE);
}

// =========================================================================
// returns dir where .sec & .dat live.
//  if the above cannot be determined (not given on command line,
//  for instance), return an empty string which implies cwd
char *
BaseSector::GetDataDir(char *buff)
{
char *ptr;

	sprintf(buff, "%s", sec_name);
	// XXX fairly unix specific code
	ptr = strrchr(buff, '/');		
	if(ptr != NULL) {
		ptr++;
		*ptr = 0;
	} else
		buff[0] = 0;

	return(buff);
}

char *
BaseSector::GetNotesDir(char *buff)
{
	GetDataDir(buff);
	strcat(buff, "/desc");
	return(buff);
}

char *
BaseSector::GetSysDir(char *buff)
{
	GetDataDir(buff);
	strcat(buff, "/sys");
	return(buff);
}

char *
BaseSector::GetEncDir(char *buff)
{
	GetDataDir(buff);
	strcat(buff, "/enc");
	return(buff);
}

char *
BaseSector::GetWorldDir(char *buff)
{
	GetDataDir(buff);
	strcat(buff, "/world");
	return(buff);
}

// =========================================================================
