/*
 * File:      uwp_dlg.h
 * Purpose:   header for uwp dialog related functions
 * Author:    Mark A. Nordstrand
 * Created:   1/23/2000
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: uwp_dlg.h,v $ $Revision: 1.6 $ $Author: man $ $Date: 2003/11/02 03:03:10 $" */

#ifndef UWP_DLG_H
#define UWP_DLG_H

#include "wx/wx.h"
#include "t_dlg.h"
#include "uwp.h"
#include "basestar.h"
#include "codetbl.h"

// ---------------------------------------------------------------
// internal defines for verify functions
#define UWP_MASK_PORT       0x01
#define UWP_MASK_SIZE       0x02
#define UWP_MASK_ATMOS      0x04
#define UWP_MASK_HYDRO      0x08
#define UWP_MASK_POP        0x10
#define UWP_MASK_GOVT       0x20
#define UWP_MASK_LAW        0x40
#define UWP_MASK_TECH       0x80

#define MAX_CODES           32

// ==========================================================================
class EditCodeDialog : public StdDialog
{
public:
    EditCodeDialog(wxWindow *p, CodeTable *ct);
	~EditCodeDialog();

	bool GetCodes(unsigned long *c);
	
private:
	wxCheckBox     *codes[MAX_CODES];

};

// ===========================================================================
// simple uwp error dialog
enum ERROR_RESP {
  ER_OK=0,
  ER_RESET,
  ER_UNDO
};

class ErrorDialog : public wxDialog
{
public:
    ErrorDialog(wxWindow *p);
	~ErrorDialog() {};

	ERROR_RESP GetResp(void);

	void SetResp(ERROR_RESP er);

	void DoOk(wxCommandEvent& event) { SetResp(ER_OK); };
	void DoReset(wxCommandEvent& event) { SetResp(ER_RESET); };
	void DoUndo(wxCommandEvent& event) { SetResp(ER_UNDO); };

	wxStaticText	*info;

	DECLARE_EVENT_TABLE()

private:
	ERROR_RESP      resp;
};

// ===========================================================================
// just a note:
// 	zone choice
// 	star param (type,class,size) box
// 	# GG choice
// 	# belts choice
// 	some kinda code (base/alleg) box?
// 	trade code dialog
// ===========================================================================
#define MAX_UWP_CHOICES		8

typedef enum UWP_IO_TYPE {
	UI_ANY=0,
	UI_SECTOR,
	UI_SYS_PLANET,
	UI_SYS_SAT,
	UI_BELT
};

// ---------------------------------------------------------------------------
class UWPBox : public wxStaticBox
{
public:
	UWPBox::UWPBox(wxWindow *p, char *title=NULL, int base_id=-1);
	~UWPBox();

	void SetUWP(char *buff, UWP_IO_TYPE t=UI_ANY);
	char *GetUWP(char *buff);

//	void SetUWP(uwp *UWP, UWP_IO_TYPE t=UI_ANY);
	bool GetUWP(uwp *UWP);

	bool Enable(bool val);
//	virtual unsigned short VerifyFunction(char *user_uwp, char *adj_uwp)=0;

	wxStaticBoxSizer *GetSizer(void) { return(sizer); };
//	void FinishLayout(wxWindow *l, int l_s, wxWindow *t, int t_s);

	// check a selected UWP
	//  this could be better servered as it's own class,
	//  but, I've moved it around now waaaay to many times.....
	void CheckUWP(void);

private:
	char GetDigit(int ndx);
	bool SetDigit(char c, wxChoice *ch);
//	void CheckValues(wxCommandEvent& event);
	void InitUwpChoices(UWP_IO_TYPE t);
	void StrToChoice(char *buff);

	unsigned short ErrorCheck(char *u, char *a);
	unsigned short CheckAny(int *u);
	unsigned short CheckWorld(int *u);
	unsigned short CheckPlanet(int *u);
//	unsigned short CheckSat(int *u);

	unsigned short CheckBelt(int *u);
	unsigned short CheckRing(int *u);
	unsigned short CheckNoPop(int *u);
	bool CheckUWP(int *val, int min, int max);

	wxStaticBoxSizer		*sizer;

	wxChoice		*l_uwp[MAX_UWP_CHOICES];
	wxStaticText 	*msg[MAX_UWP_CHOICES];
//	wxButton 		*btn;

	UWP_IO_TYPE		io_type;
	bool			verify;

	ErrorDialog    *err_dlg;

	// these are needed for the 'system' checks
	int zone,star_type,parent_size;
	float orb;

	// keep track of originals
	char orig_uwp[MAX_UWP_CHOICES+1];

};

// ===========================================================================
class ZoneChoice : public wxChoice
{
public:
	ZoneChoice(wxWindow *p, bool allow_none=FALSE);
	~ZoneChoice();

	char GetZone(void);
	void SetZone(char z);

private:
	bool		allow_none;
};

// ===========================================================================
class CodeList : public wxListBox
{
public:
	CodeList(wxWindow *p, bool a=FALSE);
	~CodeList();

	char *GetCode(void);
	void SetCode(char *c, SimpleCodeTable *a);

private:
	bool		allow_none;
};

// ===========================================================================
class StarBox : public wxStaticBox
{
public:
	StarBox(wxWindow *p, char *title=NULL);
	~StarBox();

	void SetStar(int *ty, int *cl, int *sz);
	bool GetStar(int *ty, int *cl, int *sz);

	void SetStar(char *star);
	bool GetStar(char *star);

//	void FinishLayout(wxWindow *l, int l_s, wxWindow *t, int t_s);
	wxStaticBoxSizer *GetSizer(void) { return(sizer); };

	bool Enable(bool val);

private:
	wxChoice			*star_type;
	wxChoice			*star_class;
	wxChoice			*star_size;
	wxStaticText		*msg[3];
	wxStaticBoxSizer	*sizer;

};

#endif

