/*
 * File:      uwp.h --
 * Purpose:   class def for uwp
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: uwp.h,v $ $Revision: 1.8 $ $Author: man $ $Date: 2003/11/02 03:02:01 $" */


#ifndef UWP_H
#define UWP_H

#include "t_hex.h"

// helpful defines and enums
//  should these be in t_hex.h?
#define SIZE_SMALL          11
#define SIZE_RING           12
#define SIZE_SMALL_GG       13
#define SIZE_LARGE_GG       14

typedef enum {
	UWPI_PORT=0,
	UWPI_SIZE,
	UWPI_ATMOS,
	UWPI_HYDRO,
	UWPI_POP,
	UWPI_GOVT,
	UWPI_LAW,
	UWPI_TECH
} UWP_INDEX;
#define MAX_UWP			(UI_TECH + 1)

class port_digit
{
friend class port_desc;
public:
	port_digit();
	port_digit(port_digit *p);
	port_digit(short s, short allow_spaceport=1);
	port_digit(char c, short allow_spaceport=1);
	~port_digit();

	char get_port(void) { return(port_str[val]); };
	short get_port_val(void) { return(val); };

	void set_port(char c);
	void set_port_val(short s);

	short AllowSpaceport() { return(allow_spaceport); };

private:
	short val;
	short allow_spaceport;

	static char *port_str;// = "ABCDEFGHXY";

	short xlat_digit(char c);
	short check_spaceport(short s);

	int is_spaceport(void);

};

class port_desc : public port_digit
{
public:
	port_desc(port_desc *p) : port_digit(p) {};
	port_desc(short s, short allow_spaceport=1);
	port_desc(char c, short allow_spaceport=1);
	~port_desc();

	// pass a buffer to this one:
	char *get_full_desc(char *);
	// get a ptr to these:
	char *get_quality(void) { return(quality[val]); };
	char *get_yards(void) { return(yards[val]); };
	char *get_repair(void) { return(repair[val]); };
	char *get_fuel(void) { return(fuel[val]); };

private:
	static char *quality[10];
	static char *yards[10];
	static char *repair[10];
	static char *fuel[10];
};

// uwp_digit value
#define MAX_INDEX		7
class uwp_digit : public t_hex
{
public:
	uwp_digit();
	uwp_digit(uwp_digit *u);
	uwp_digit(short s, T_HEX_TYPE t, short a, short b, short c,
			  short d=-1, short e=-1, short f=-1, short g=-1);
	uwp_digit(char ch, T_HEX_TYPE t, short a, short b, short c,
			  short d=-1, short e=-1, short f=-1, short g=-1);
	virtual ~uwp_digit();

	short get_index(void);

	virtual char *get_full_desc(char *buff) = 0;
	virtual void get_short_desc(char *buff) = 0;

	short GetNdx(int n) { return(ndx_vals[n]); };

private:
	short ndx_vals[MAX_INDEX];
	void construct_index(short a, short b, short c, short d=-1, short e=-1);
};

// general social class (since these are mostly none, low, mod, high)
//  and a little more forgiving about a '-1' value
class uwp_soc_digit : public uwp_digit
{
friend class pop_desc;
friend class law_desc;
public:
	uwp_soc_digit(uwp_soc_digit *s) : uwp_digit(s) {};
	uwp_soc_digit(short s, T_HEX_TYPE t, short a, short b, short c,
				  short d=-1, short e=-1, short f=-1, short g=-1);
	uwp_soc_digit(char ch, T_HEX_TYPE t, short a, short b, short c,
				  short d=-1, short e=-1, short f=-1, short g=-1);
	virtual ~uwp_soc_digit();

	int str_valid(char *buff);
	
private:
	static char *simple[5];
};

class size_desc : public uwp_digit
{
public:
	size_desc(size_desc *s) : uwp_digit(s) {};
	size_desc(short s);
	size_desc(char c);
	~size_desc();

	char *get_full_desc(char *);
	void get_short_desc(char *);

	short get_true_index(void);

	float get_radius_km(void);

	int is_gg(void);
private:
	static char *desc[15];
	static char *simple[6];
};

class atmos_desc : public uwp_digit
{
public:
	atmos_desc(atmos_desc *a) : uwp_digit(a) {};
	atmos_desc(short s);
	atmos_desc(char c);
	~atmos_desc();

	char *get_full_desc(char *);
	void get_short_desc(char *);

	int is_tainted(void);

private:
	static char *desc[16];
	static char *simple[5];
	
};

class hydro_desc : public uwp_digit
{
public:
	hydro_desc(hydro_desc *s) : uwp_digit(s) {};
	hydro_desc(short s);
	hydro_desc(char c);
	~hydro_desc();

	char *get_full_desc(char *);
	void get_short_desc(char *);

private:
	static char *simple[4];
	
};

class pop_desc : public uwp_soc_digit
{
public:
	pop_desc(pop_desc *s) : uwp_soc_digit(s) {};
	pop_desc(short s);
	pop_desc(char c);
	~pop_desc();

	char *get_full_desc(char *);
	void get_short_desc(char *);

private:
	static char *desc[11];

};

// in the future, we might want to handle the wilds here:
class govt_desc : public uwp_soc_digit
{
public:
	govt_desc(govt_desc *g) : uwp_soc_digit(g) {};
	govt_desc(short s);
	govt_desc(char c);
	~govt_desc();

	char *get_full_desc(char *);
	void get_short_desc(char *);

private:
	static char *desc[16];
	static char *simple[16];

};

class law_desc : public uwp_soc_digit
{
public:
	law_desc(law_desc *l) : uwp_soc_digit(l) {};
	law_desc(short s);
	law_desc(char c);
	~law_desc();

	char *get_full_desc(char *);
	void get_short_desc(char *);

private:
	static char *desc[22];

};

class tech_desc : public uwp_soc_digit
{
public:
	tech_desc(tech_desc *t) : uwp_soc_digit(t) {};
	tech_desc(short s);
	tech_desc(char c);
	~tech_desc();

	char *get_full_desc(char *);
	void get_short_desc(char *);

private:
	static char *desc[22];
	static char *simple[7];
	static char *era[22];
};


class uwp
{
//friend class planet;
friend class base_planet;
public:
	uwp();
	uwp(char *);
	uwp(uwp *);
	~uwp();

	void GetUWPStr(char *);
	void get_full_uwp_str(char *);

	int is_gg(void);

	//
	bool SetPort(char c);
	bool SetSize(char c);
	bool SetAtmos(char c);
	bool SetHydro(char c);
	bool SetPop(char c);
	bool SetGovt(char c);
	bool SetLaw(char c);
	bool SetTech(char c);

	port_desc *GetPort(void) { return(port); };
	size_desc *GetSize(void) { return(size); };
	atmos_desc *GetAtmos(void) { return(atmos); };
	hydro_desc *GetHydro(void) { return(hydro); };
	pop_desc *GetPop(void) { return(pop); };
	govt_desc *GetGovt(void) { return(govt); };
	law_desc *GetLaw(void) { return(law); };
	tech_desc *GetTech(void) { return(tech); };

	char get_port(void);
	char get_size(void) { return(get_uwp_char(size)); };
	char get_atmos(void) { return(get_uwp_char(atmos)); };
	char get_hydro(void) { return(get_uwp_char(hydro)); };
	char get_pop(void) { return(get_uwp_char(pop)); };
	char get_govt(void) { return(get_uwp_char(govt)); };
	char get_law(void) { return(get_uwp_char(law)); };
	char get_tech(void) { return(get_uwp_char(tech)); };
	
	short get_port_val(void);
	short get_size_val(void) { return(get_uwp_val(size)); };
	short get_atmos_val(void) { return(get_uwp_val(atmos)); };
	short get_hydro_val(void) { return(get_uwp_val(hydro)); };
	short get_pop_val(void) { return(get_uwp_val(pop)); };
	short get_govt_val(void) { return(get_uwp_val(govt)); };
	short get_law_val(void) { return(get_uwp_val(law)); };
	short get_tech_val(void) { return(get_uwp_val(tech)); };

	char *GetPortDesc(char *buff) { return(port->get_full_desc(buff)); };
	char *GetSizeDesc(char *buff) { return(size->get_full_desc(buff)); };
	char *GetAtmosDesc(char *buff) { return(atmos->get_full_desc(buff)); };
	char *GetHydroDesc(char *buff) { return(hydro->get_full_desc(buff)); };
	char *GetPopDesc(char *buff) { return(pop->get_full_desc(buff)); };
	char *GetGovtDesc(char *buff) { return(govt->get_full_desc(buff)); };
	char *GetLawDesc(char *buff) { return(law->get_full_desc(buff)); };
	char *GetTechDesc(char *buff) { return(tech->get_full_desc(buff)); };
#if 0
	char *GetPortDesc(char *buff);
	char *GetSizeDesc(char *buff);
	char *GetAtmosDesc(char *buff);
	char *GetHydroDesc(char *buff);
	char *GetPopDesc(char *buff);
	char *GetGovtDesc(char *buff);
	char *GetLawDesc(char *buff);
	char *GetTechDesc(char *buff);
#endif
	float GetRadius(void) { return (size->get_radius_km()); };
	
private:
	port_desc		*port;
	size_desc		*size;
	atmos_desc		*atmos;
	hydro_desc		*hydro;
	pop_desc		*pop;
	govt_desc		*govt;
	law_desc		*law;
	tech_desc		*tech;

	void get_full_uwp_desc(uwp_digit *src, char *buff);
	char get_uwp_char(uwp_digit *src);
	short get_uwp_val(uwp_digit *src);
	char *GetNullStr(char *buff);
};

#endif

