/*
 * File:    word.h
 * Purpose:	traveller word generator
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: t_word.h,v $ $Revision: 1.2 $ $Author: man $ $Date: 1999/04/06 04:25:07 $" */

#ifndef T_WORD_H
#define T_WORD_H

#include "t_dice.h"

#define TABLE_ENTRY_SIZE       5
#define TABLE_SIZE             6

#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif

typedef enum WordCase {
  WORD_UPPER=0,
  WORD_LOWER,
  WORD_MIXED
};


struct WORD_ARRAY {
    char    word[TABLE_ENTRY_SIZE];
    };

struct WORD_LINE {
    struct WORD_ARRAY   line[TABLE_SIZE];
    };

struct WORD_TABLE {
    struct WORD_LINE   entry[TABLE_SIZE];
    };

class WordGen
{
public:
    WordGen(WordCase c=WORD_MIXED);
    WordGen(char *config_file, WordCase c=WORD_MIXED);
	~WordGen();

	bool Valid(void) { return(valid); };

	void SetCase(WordCase c) { _case = c; };
	char *GenerateWord(char *);

	char *GetName(void) { return(name); };
	
private:
	void Init(WordCase c=WORD_MIXED);
	bool LoadFile(char *config_file);
	bool ParseTable(char *buff, struct WORD_TABLE *tbl);
	bool ParseName(char *);
	bool ParseFlag(char *);
	char *ParseData(char *);

	void CatSylb(char *buff, char *tbl);
	void CatConst(char *buff, int flag);
	void CatVowel(char *buff);
	
	struct WORD_TABLE base_table;
	struct WORD_TABLE alt_table;

	struct WORD_TABLE init_table[TABLE_SIZE];
	struct WORD_TABLE vow_table[TABLE_SIZE];
	struct WORD_TABLE end_table[TABLE_SIZE];

	char        *name;
	char        vowel_flag;
	WordCase    _case;
	Dice        *die;
	bool        valid;
};

#endif
