/*
 * File:      t_help.h
 * Purpose:   header for MTU help stuff
 * Author:    Mark A. Nordstrand
 * Created:   8/2/99
 * Updated:
 * Copyright: LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: t_help.h,v $ $Revision: 1.3 $ $Author: man $ $Date: 2003/05/05 03:30:41 $" */

#ifndef T_HELP_H
#define T_HELP_H

#include "t_dlg.h"
#include "wx/helpbase.h"
#include "wx/help.h"

// menu id's 
#define T_HELP_APP			501
#define T_HELP_MTU			(T_HELP_APP + 1)
#define T_HELP_TRAVELLER	(T_HELP_MTU + 1)
#define T_HELP_SEARCH		(T_HELP_TRAVELLER + 1)
#define T_HELP_ABOUT		(T_HELP_SEARCH + 1)

// help id's
typedef enum {
	HI_TRAVELLER=0,
	HI_MTU,
	HI_MTU_APP,
	HI_SECTOR,
	HI_SYSGEN,
	HI_SYSTEM,
	HI_WORLD,
	HI_ENC,
	HI_WORD,
	HI_DICE
} HELP_ID;

class AboutDialog : public wxDialog
{
public:
	AboutDialog(wxWindow *parent);
	~AboutDialog();

	void ShowAbout(char *name);
};

// stupid wrapper so we can initialize from the resource file
class THelp : public wxHelpController
{
public:
	THelp();
	~THelp();

	void BuildMenu(wxMenuBar *menu_bar, int app_id);

	bool ResolveMenu(wxWindow *parent, int id);

private:
	int 		app_id;
};

#endif

