/*
 * File:	srch_dlg.h
 * Purpose:	dialogs for search program
 * Author:	Mark A. Nordstrand
 * Created:	6/18/2000
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: srch_dlg.h,v $ $Revision: 1.6 $ $Author: man $ $Date: 2003/05/01 20:58:35 $" */

#ifndef SEARCH_DLG_H
#define SEARCH_DLG_H

#include "t_dlg.h"
//#include "wx/toolbar.h"
#include "universe.h"
#include "sectdisp.h"
#include "systdisp.h"
#include "mtu_file.h"
#include "wx/print.h"
#include "wx/printdlg.h"
#include "wx/generic/printps.h"
#include "wx/generic/prntdlgg.h"

// ====================================================
typedef enum SEARCH_MODE {
	SEARCH_NONE=0,
	SEARCH_RANGE,
	SEARCH_TRADE,
	SEARCH_SHORT
};

typedef enum FOUND_TYPE {
	FT_NORMAL=0,
	FT_3D,
	FT_SYSTEM
};

// forward references
class BaseFound;
class FoundEntry;
class FoundSystemEntry;
class Found3DEntry;

// ====================================================
class FoundList : public LinkedList
{
public:
	FoundList();
	~FoundList();

	void Clear(void);

	BaseFound *GetCurrent(void);
	unsigned long GetIndex(void) { return(index); };
	
	void SetIndex(unsigned long i) { index = i; };

	bool GetCurrent(int *u_x, int *u_y, int *x_, int *y_, int *z_,
			int *orb1, int *orb2, int *orb3, int *orb4);
	bool SetFirst(void);
	bool SetPrev(void);
	bool SetNext(void);
	bool SetLast(void);

	FOUND_TYPE GetCurrentType(void);
	planet *GetCurrentPlanet(void);
	bool GetCurrentSysInfo(int *pn, int *be, int *gg, BaseStar **st);

private:
	bool GetValues(int *sec_x, int *sec_y, int *x_, int *y_, int *z_,
			int *orb1, int *orb2, int *orb3, int *orb4);
	unsigned long	index;
};

// ----------------------------------------------------
#define SEARCH_ORBS			4
#define SEARCH_STARS		3
#if 0
class FoundEntry : public ListData
{
public:
	FoundEntry(int u_x, int u_y, main_world *mw);
	FoundEntry(int u_x, int u_y, int x, int y, int *orbs, planet *p);
	FoundEntry(int x, int y, int z, int *orbs, planet *p);
	~FoundEntry();

	FOUND_TYPE GetType(void) { return(type); };

	planet *GetPlanet(void);
	main_world *GetMainWorld(void);

	void GetValues(int *sec_x, int *sec_y, int *x_, int *y_, int *z_,
			int *orb1, int *orb2, int *orb3, int *orb4);

private:
	FOUND_TYPE		type;
	base_planet		*p;
	int 			u_x,u_y;
	int				x,y,z;
	int				orbs[SEARCH_ORBS];
};
#endif

// ----------------------------------------------------
// found worlds lists
class BaseFound : public ListData
{
friend class FoundEntry;
friend class FoundSystemEntry;
friend class Found3DEntry;
public:
	BaseFound(int x_, int y_);
	~BaseFound() {};

	virtual FOUND_TYPE GetType(void)=0;

	virtual void GetValues(int *sec_x, int *sec_y, int *x_, int *y_, int *z_,
			int *orb1, int *orb2, int *orb3, int *orb4)=0;

	virtual planet *GetPlanet(void)=0;
	virtual bool GetSysInfo(int *pn, int *be, int *gg, BaseStar **st)=0;

private:
	short	x;				// sect x,y
	short	y;
};

// ----------------------------------------------------
class FoundEntry : public BaseFound
{
public:
	FoundEntry(int u_x, int u_y, int x_, int y_);
	~FoundEntry() {};

	void GetValues(int *sec_x, int *sec_y, int *x_, int *y_, int *z_,
			int *orb1, int *orb2, int *orb3, int *orb4);

	FOUND_TYPE GetType(void) { return(FT_NORMAL); };
	planet *GetPlanet(void) { return(NULL); };
	bool GetSysInfo(int *pn, int *be, int *gg, BaseStar **st) { return(FALSE);};

private:
	short	sec_x;			// universe x,y
	short	sec_y;
};

// ----------------------------------------------------
class Found3DEntry;
class FoundSystemEntry : public FoundEntry
{
friend class Found3DEntry;
public:
	FoundSystemEntry(int u_x, int u_y, int x_, int y_,
			int orb1, int orb2, int orb3, int orb4, 
			planet *p_, int pn, int be, int g, BaseStar *st[]);
	virtual ~FoundSystemEntry();

	FOUND_TYPE GetType(void) { return(FT_SYSTEM); };

	void GetValues(int *sec_x, int *sec_y, int *x_, int *y_, int *z_,
			int *orb1, int *orb2, int *orb3, int *orb4);

	planet *GetPlanet(void) { return(p); };
	bool GetSysInfo(int *pn, int *be, int *gg, BaseStar *st[]);

private:
	int			orbs[SEARCH_ORBS];		// hokey address scheme.....
	planet		*p;
	int			pop_index,belts,gg;
	BaseStar	*stars[SEARCH_STARS];
};

// ----------------------------------------------------
class Found3DEntry : public FoundSystemEntry
{
public:
	Found3DEntry(int x_, int y_, int z_,
			int orb1, int orb2, int orb3, int orb4, 
			planet *p_, int pn, int be, int g, BaseStar *st[]);
	~Found3DEntry() {};

	FOUND_TYPE GetType(void) { return(FT_3D); };

	void GetValues(int *sec_x, int *sec_y, int *x_, int *y_, int *z_,
			int *orb1, int *orb2, int *orb3, int *orb4);

private:
	int z;				// sect z
};

// ====================================================
class CompareClass
{ 
public:
	CompareClass();
	~CompareClass();

	bool Ok(base_planet *bp);
	void Reset(void);

	void SetBases(char b) { bases = b; };
	void SetZone(char z) { zone = z; };
	void SetAlleg(const char *a);
	
	char GetBases(void) { return(bases); };
	char GetZone(void) { return(zone); };
	char *GetAlleg(void) { return(alleg); };
private:
	char bases;
	char zone;
	char *alleg;
};

// base class for the 2 min/max values
class MinMaxClass
{ 
friend class MinClass;
friend class MaxClass;
public: 
	MinMaxClass() { Reset(); };
	virtual ~MinMaxClass() {};

	bool Ok(base_planet *bp);	
	bool Ok(short p, short b, short g, BaseStar *stars[]);

	void Reset(void);

	void SetPort(short v) { port = v; };
	void SetSize(short v) { size = v; };
	void SetAtmos(short v) { atmos = v; };
	void SetHydro(short v) { hydro = v; };
	void SetPop(short v) { pop = v; };
	void SetGovt(short v) { govt = v; };
	void SetLaw(short v) { law = v; };
	void SetTech(short v) { tech = v; };
	
	void SetNumGG(short v) { num_gg = v; };
	void SetNumBelt(short v) { num_belt = v; };
	
	void SetNumStar(short v) { num_star = v; };
	void SetStarType(short v) { star_type = v; };
	void SetStarSize(short v) { star_size = v; };
	void SetStarClass(short v) { star_class = v; };
	
private:            
	short 			port;
	short			size;
	short			atmos;
	short			hydro;
	short			pop;
	short			govt;
	short			law;
	short			tech;
	
	short			num_gg;
	short			num_belt;
	
	short			num_star;
	short			star_type;
	short			star_size;
	short			star_class;

	bool CompareVal(bool, short, short);
	// over ride this to get the appropriate min/max check:
	virtual bool Test(short b_val, short c_val) = 0;

};
                               
class MinClass : public MinMaxClass
{
public:
	MinClass();
	~MinClass() {};

private:
	bool Test(short b_val, short c_val) { return(CompareVal(FALSE, b_val, c_val)); };
};

class MaxClass : public MinMaxClass
{
public:
	MaxClass();
	~MaxClass() {};

private:
	bool Test(short b_val, short c_val) { return(CompareVal(TRUE, b_val, c_val)); };
	
};

// ====================================================
// SearchTradeDialog
#define MAX_TRADE_CB		32
class SearchTradeDialog : public StdDialog
{
public:
	SearchTradeDialog(wxWindow *p, TCodes *ct);
	~SearchTradeDialog() {};

//	unsigned long GetTradeSearch(void);
	bool GetTradeSearch(unsigned long *t, unsigned long *s, unsigned long *o);

private:
	wxStaticBoxSizer *LayoutBox(wxStaticBox *box, wxCheckBox *cb[], int max);

	wxCheckBox			*cb_t[MAX_TRADE_CB];
	wxCheckBox			*cb_s[MAX_TRADE_CB];
	wxCheckBox			*cb_o[MAX_TRADE_CB];

};

// ====================================================
// SearchRangeDialog
#define MAX_CHOICES		14
class SearchRangeDialog : public StdDialog
{
public:
	SearchRangeDialog(wxWindow *p);
	~SearchRangeDialog() {};

	bool GetRangeSearch(MinClass *min, MaxClass *max, CompareClass *comp);
	wxString GetChoiceStr(bool max, int ndx);

private:
	int InitArray(int which, wxString ptrs[]);
//					char **ptrs);

	wxChoice		*min_choices[MAX_CHOICES];
	wxChoice		*max_choices[MAX_CHOICES];

	wxTextCtrl		*bases;
	wxChoice		*zones;
	wxTextCtrl		*alleg;

};

// ====================================================
// SearchShortDialog
class SearchShortDialog : public StdDialog
{
public:
	SearchShortDialog(wxWindow *p);
	~SearchShortDialog() {};

	bool GetShortSearch(MinClass *min, MaxClass *max);

	wxString GetChoiceStr(int ndx);
	wxString GetHeaderStr(int ndx);

private:
	int BuildBuffers(const wxString& str1, const wxString& str2, 
					const wxString& str3, const wxString& str4, 
					const wxString& str5, const wxString& str6, 
					const wxString& str7, const wxString& str8);
	int BuildBuffer(wxString& dest, const wxString& src);
	void BuildChoice(int ndx, const wxString& title, 
					const wxString& str1, const wxString& str2, 
					const wxString& str3, const wxString& str4, 
					const wxString& str5, const wxString& str6, 
					const wxString& str7, const wxString& str8);

	wxChoice		*choices[8];

};

// ====================================================
class SearchDialog;
class SearchPrintout : public wxPrintout
{
public:
	SearchPrintout(SearchDialog *p, bool d, bool h, FoundList *f, MTUFile *di,
					BaseSector *s, UListData *ul, TCodes *c, int m);
	~SearchPrintout();

	bool OnPrintPage(int page);
	bool HasPage(int page);
	void GetPageInfo(int *minPage, int *maxPage, int *selPageFrom, int *selPageTo);

private:
	int				page_max;
	bool			detail;
	bool			headers;

	int				cur_count;

	// handy references
	SearchDialog	*parent;
	MTUFile			*dirs;

	FoundList		*fl;
	BaseSector		*bs;
	UListData		*uld;
	TCodes			*codes;
	int				max_sect;
};

// ====================================================
class SearchPrintDialog : public StdDialog
{
public:
	SearchPrintDialog(wxWindow *p);
	~SearchPrintDialog();

	void DoPrint(bool d, FoundList *f, MTUFile *d, BaseSector *s, UListData *ul, 
					TCodes *c, int max_sect);

private:
	// controls
	wxCheckBox		*to_file;
	wxCheckBox		*headers;
	wxCheckBox		*detail;

	// setup
#ifdef __WXMSW__
	wxPrintDialog			*setup_dialog;
#else
	wxGenericPrintDialog	*setup_dialog;
#endif
	wxPrintData			p_data;

	// event handlers
	void DoSetup(wxCommandEvent &event);

	DECLARE_EVENT_TABLE()
};

// ====================================================
// yuk, I should screw around with multiple inheritance,
//   and try to get System Display to work......
class SearchDisplay : public MainWorldDisplay
{
public:
	SearchDisplay(wxDC *d, int x=0, int y=0, int len=-1) :
			MainWorldDisplay(d, x, y, len) {};
	SearchDisplay(FILE *fpx, int len=-1) :
			MainWorldDisplay(fpx, len) {};
	SearchDisplay(wxTextCtrl *t, int len=-1) :
			MainWorldDisplay(t, len) {};
	virtual ~SearchDisplay() {};

	int Draw(bool detail, FoundList *f, MTUFile *dirs, TCodes *c, BaseSector *s,
			UListData *ul, int max_sector=-1, int start=0, int count=-1);

	int DrawSystemDetail(BaseFound *bf, TCodes *c, char *sec_name,char *l_name);

private:
	void FormatSystemOrbit(char *buff, int *orbs);
};

// ====================================================
#define MAX_BITMAP_BTNS		7

class SearchDialog : public wxDialog
{
public:
	SearchDialog(wxWindow *p);
	~SearchDialog();

	void Search(BaseSector *s, UListData *ul, TCodes *c, MTUFile *d);

	void SearchTrade(BaseSector *s, UListData *ul, TCodes *c, MTUFile *d);
	void SearchRange(BaseSector *s, UListData *ul, TCodes *c, MTUFile *d);
	void SearchShort(BaseSector *s, UListData *ul, TCodes *c, MTUFile *d);

	int DrawHeader(SearchDisplay *dm);
	int GetCount(void) { return(found->Count()); };
	int GetLineCount(void);
	int GetHeaderCount(void);

private:
	// controls
	wxTextCtrl		*text;
	wxStaticText	*msg;
	wxBitmapButton	*btn1[MAX_BITMAP_BTNS];
	wxCheckBox		*sys;

	// compare info
	MinClass		*mins;
	MaxClass		*maxs;
	CompareClass	*comp;
	unsigned long	trades;
	unsigned long	other;
	unsigned long	system;

	// how we search
	SEARCH_MODE		mode;

	// anything we may have found
	FoundList		*found;

	// formating info/helpers
	int				max_sect;
	bool			detail;

	// the following are what we search on
	//  (they are, of course, references, and one should always be NULL)
	// current sector if doing sector only
	BaseSector		*sect;
	// list of sectors in universe of interest
	UListData		*sectors;

	// codes
	TCodes			*codes;

	// dirs
	MTUFile			*dirs;
	// misc subdialogs
	SearchTradeDialog		*trade_dlg;
	SearchShortDialog		*short_dlg;
	SearchRangeDialog		*range_dlg;
	SearchPrintDialog		*print_dlg;

	// event handlers
	void DoFirst(wxCommandEvent &event);
	void DoPrev(wxCommandEvent &event);
	void DoNext(wxCommandEvent &event);
	void DoLast(wxCommandEvent &event);
	void DoDetail(wxCommandEvent &event);
	void DoList(wxCommandEvent &event);
	void DoPrint(wxCommandEvent &event);
	void DoTrade(wxCommandEvent &event);
	void DoShort(wxCommandEvent &event);
	void DoRange(wxCommandEvent &event);
	void DoClose(wxCommandEvent &event);

	// misc helpers
	bool Search(int u_x, int u_y, BaseSector *s);
	bool Search(void);
	bool Search3D(void);
	bool SearchSystemFile(char *name, bool for_3d, int u_x, int u_y, 
					int x, int y, int z);
	void SearchSystem1(BaseOrbit *bo, BaseStar *bs[], int *belts, int *gg);
	bool SearchSystem2(BaseOrbit *bo, BaseStar *bs[], int belts, int gg,
			bool for_3d, int u_x, int u_y, int x, int y, int z);
	bool TradeOk(base_planet *mw, unsigned long sys_flags=0l);
	void ResetSearch(void);
	void ReflectState(void);
	void CheckSystem(void);

	DECLARE_EVENT_TABLE()
};

#endif

