/*
 * File:      sg_build.h
 * Purpose:   handle the build portion of system generation
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: sg_build.h,v $ $Revision: 1.1 $ $Author: man $ $Date: 2002/04/14 17:03:23 $" */ 

// NOTE:
//  this used to be build.* in the sysgen dir

#ifndef SG_BUILD_H
#define SG_BUILD_H

#include <stdio.h>
#include "t_dice.h"
#include "t_word.h"
#include "syst.h"
#include "uwpgen.h"
#include "stargen.h"
#include "mtu_file.h"

#define MAX_GG       5
#define MAX_BELTS    3

// ====================================================
// enums to handle placing known components
typedef enum GG_PLACE {
    GP_HAB_PLUS_2=0,
	GP_INNER,
	GP_ANY,
	GP_EXTEND };

typedef enum BELT_PLACE {
    BP_GG=0,
	BP_INNER,
	BP_ANY,
	BP_EXTEND };

typedef enum MW_PLACE {
    MP_HAB,
	MP_HAB_GG,
	MP_ANY,
	MP_EXTEND };

// ====================================================
// real lame way to pass params around
struct sys_conf {
    char		*name;
    char		*sect;
    char		*ssect;
    char		*loc;
	int			x,y,z;			/* 3D alias for above.... */
	bool		use_xyz;

// -1 => random
    int			belts;
    int			gg;

	char		port;			// for secgen....

	char		uwp[9];
    char		stars[3][8];

    char		bases[2];
    char		alleg[3];
    char		zone[2];

    WordGen		*lang;
	MTUFile		*dirs;

    char		*out_file;

    bool		quiet_mode;
	bool		no_sleep;
	bool		run_editor;
	bool		interactive;	// for secgen....

    bool		no_main;		// ie. pick from avail.
	bool		full_rand;

	TECH_GEN	tech_method;	// resource?
	int			tech_min;
	int			tech_max;
};

// ===========================================================================
#define UWP_UNDEFINED -1
#define UWP_BELT      0
#define UWP_GG        1
#define UWP_RING      2
#define UWP_PLANET    3
#define UWP_SAT       4
#define UWP_STAR      5

#define FAC_FARM      0x01
#define FAC_MINE      0x02
#define FAC_COL       0x04
#define FAC_LAB       0x08
#define FAC_MILT      0x10

// forward ref
class OrbitList;
class BuildStar;

class BuildOrbit : public ListData
{
public:
    BuildOrbit(int o, bool s=FALSE);
	~BuildOrbit();

	int GetOrbit(void) { return(orbit); };
	int GetFraction(void) { return(orb_fraction); };
	char *GetData(void) { return(data); };
	char *GetName(void) { return(name); };
	void SetName(char *n);
	char *FormatOrbit(char *buff);
	
	void SetOrbit(int o) { orbit = o; };

	bool AddSat(char *uwp);
	void SetData(char *uwp);
	void SetPop(char p) { data[4] = p; };

//	void GenSats(BuildStar *bs);

	BuildOrbit *GetSat(int ndx);

	void GenFac(bool hab, char *mw_uwp, char mw_base);
	void GenFac2(void);
	bool LabPresent(void) { return(flags & FAC_LAB); };
	bool MiltPresent(void) { return(flags & FAC_MILT); };
	bool FarmPresent(void) { return(flags & FAC_FARM); };
	bool MinePresent(void) { return(flags & FAC_MINE); };
	bool ColPresent(void) { return(flags & FAC_COL); };
	void ClearFac(void) { flags = 0; };
	char *GetFac(char *buff);
	
private:
	int       orbit;
	int       orb_fraction;

	bool      sat;

	char      *name;
	char      data[10];
	unsigned int flags;
	
	Dice      dice;
	OrbitList *sat_orbits;
};

// ===========================================================================
class OrbitList : public LinkedList
{
public:
    OrbitList();
	~OrbitList();

	void AppendOrbit(BuildOrbit *bo);
	BuildOrbit *GetOrbit(int ndx);
	BuildOrbit *LastOrbit(void);
};

// ---------------------------------------------------------------------------
// kinds of orbit for stars
#define ORBIT_UNDEFINED          -3
#define ORBIT_PRIMARY            -2
#define ORBIT_CLOSE              -1
#define ORBIT_FAR                13
#define ORBIT_EXTREME            10000
class BuildStar : public DetailStar
{
public:
    BuildStar(char *n, char *d, bool e, UWPGen *gt);
	BuildStar(char *n, int t, int c, int s, bool e, UWPGen *gt);
	~BuildStar();

	int Edit(void) { return(edit); };
	int GetOrbit(void) { return(orbit); };
	int GetNumOrbits(void) { return(num_orbits); };
	int GetEmpty(int ndx) { return(mt_orb[ndx]); };
	int GetCapt(int ndx) { return(capt_orb[ndx]); };
	int GetTotalOrbits(void);

	char *GetName(void) { return(name); };
	void SetName(char *n);
	void SetOrbit(int o) { orbit = o; };
	void SetNumOrbits(int o) { num_orbits = o; };

	void AddEmpty(int o);
	void AddCapt(int o);
	void SetEmpty(int ndx, int o) { mt_orb[ndx] = o; };
	void SetCapt(int ndx, int o) { capt_orb[ndx] = o; };
	void RemEmpty(int ndx) { mt_orb[ndx] = ORBIT_UNDEFINED; };
	void RemCapt(int ndx) { capt_orb[ndx] = ORBIT_UNDEFINED; };

	int RandomOrbit(void);

	int ValidateOrbit(int o);
	void ValidateAllOrbits(void);

	bool SetOrbFlag(int orb, int typ, bool sat_ok=FALSE);
	int GetInnerGG(void);

	int GetGGOrbit(int ndx) { return(gg_orbs[ndx]); };
	int GetBeltOrbit(int ndx) { return(belt_orbs[ndx]); };
	int GetMWOrbit(void) { return(mw_orb); };
	void ClearGG(void);
	void ClearBelts(void);
	void SetGGOrbit(int orb);
	void SetBeltOrbit(int orb);
	void DeleteGG(int orb);
	void DeleteBelt(int orb);
	void SetMWOrbit(int o) { mw_orb = o; };
	
	bool OrbitAvail(int o, bool sat_ok);

	void FillInWorlds(int st1, int st2, bool force=FALSE);
	void GenWorlds(int orb, int num);
	
#ifdef SG_DEBUG
	void DumpStar(void);
#endif

	BuildOrbit *GetWorldOrbit(int ndx);

	long GetPriority(bool no_main, char *uwp, char hi_pop, BuildOrbit *bo);
	
	void FinishWorlds(char *uwp, char base);

	void ClearOrbits(void);
	void ClearKnown(void);

	// yuck
//	void IncNumOrbits(void) { num_orbits++; };

private:
	bool		edit;   /* edit class, type, or size */
	
    int			orbit;   /* -1 => primary */
	int			num_orbits;
	int			mt_orb[3];
	int			capt_orb[3];

	char		*name;
	
	Dice		dice;
	OrbitList	*sub_orbits;
	UWPGen		*gen_uwp;		// reference -- do not delete

	void Init(bool e, UWPGen *gt);

	bool GetOrbCount(int orb);
	void FinishWorlds(BuildOrbit *bo, char *uwp,  char base);

	/* used while placing known components */
	int              gg_orbs[MAX_GG];
	int              belt_orbs[MAX_BELTS];
	int              mw_orb;
};

// ----------------------------------------------------
enum BuildState {
  BS_INIT=0,
  BS_STAR,
  BS_KNOWN,
  BS_MW_SELECT,
  BS_FINISH };

class SystemGenerate
{
public:
    SystemGenerate(char *dir_name, TECH_GEN tg, int n, int x);
	~SystemGenerate();

	// state control
	bool NextState(sys_conf *cfg);
	bool PrevState(sys_conf *cfg);
	bool Cancel(sys_conf *cfg);
	bool End(sys_conf *cfg);
	
	BuildState GetState(void) { return(state); };

	// misc. helpers
	BuildStar *GetStar(int ndx) { return(stars[ndx]); };

	void DeleteStar(int ndx);

	void AddStar(int ndx, BuildStar *bs) { stars[ndx] = bs; };
	bool OrbitAvail(int ndx, int o, bool sat_ok);

	// Place Stars
	bool VerifyStarOrbits(void);

	// place known
	void SetMW(struct sys_conf *cfg);
	
	void GetMWndx(int *st, int *o, int *s) { *st=mw_st; *o=mw_orb; *s=mw_sat;};
	void ClearMW(void);
	void GenMW(int st, int o, int s, char p=0);

	int Save(char *name, sys_conf *cfg);
	
	BuildOrbit *GetMWOrbit(void);
	int GetNumGG(void);
	int GetNumBelts(void);
	char *GetStarType(int ndx, char *buff);

	void fred(int ndx, int p_ndx, bool no_main, char *uwp, 
				bool edit, char *st, bool gen);

	UWPGen *GetGenUWP(void) { return(gen_uwp); };
	GenStar *GetGenStar(void) { return(gen_star); };

#ifdef SG_DEBUG
	void DumpSG(sys_conf *cfg);
#endif
private:
	void BuildStars(struct sys_conf *cfg);
	void SetStarOrbit(int ndx, int p_ndx);

	void PlaceKnown(sys_conf *cfg);

	void RemoveStars(sys_conf *cfg);
	void RemoveKnown(sys_conf *cfg);
	void UnFillIn(sys_conf *cfg);
	void UnFinish(sys_conf *cfg);
	
	/* helpers used for placing known components */
	int PlaceGG(int ndx, GG_PLACE meth);
	int PlaceBelt(int ndx, BELT_PLACE meth);
	int PlaceMW(int ndx, MW_PLACE meth);
	bool GGHab2(int ndx);
	bool BeltGG(int ndx);
	bool AddToHab(int ndx, bool sat_ok);
	bool AddInner(int ndx, int typ);
	bool AddAnywhere(int ndx, int typ);
	bool AddExtend(int ndx, int typ);
	
	void FillInWorlds(sys_conf *cfg);
	void FillInNames(char *n, WordGen *lang, int ndx);
	void FinishWorlds(sys_conf *cfg);

	void SaveStar(FILE *fp, int ndx, int name_len);
	void SaveOrbit(FILE *fp, BuildOrbit *bo, int indent, int name_len);
	int LongestName(void);

	int GetItem(bool gg=FALSE);

	BuildState		state;

	BuildStar		*stars[MAX_STARS];

	int				type_roll;
	int				size_roll;
	/* track the the main world (if random else ignore this) */
	/* NOTE these are all indecies */
	int				mw_st;
	int				mw_orb;
	int				mw_sat;
	
	Dice			dice;
	UWPGen			*gen_uwp;
	GenStar			*gen_star;
};

#endif
