/*
 * File:      sect.h
 * Purpose:   class def for sectors
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: sect.h,v $ $Revision: 1.2 $ $Author: man $ $Date: 1999/04/06 04:25:07 $" */

//
//	



#ifndef SECT_H
#define SECT_H

#include "planet.h"
#include "llist.h"
// not to sure about this....
//#include "wx/list.h"

#include "codetbl.h"
//#include "basetbl.h"
//#include "sect_gly.h"
#include "t_code.h"


// these should never change:
#define MAX_X_HEX		32
#define MAX_Y_HEX		40

#define MAX_SS			16
// glyph stuff
#define GLYPH_NONE					0
#define GLYPH_STAR					1
#define GLYPH_TRIANGLE				2
#define GLYPH_DIAMOND				4
#define GLYPH_BOX					8
#define GLYPH_MASK1					0x0f
#define GLYPH_MASK2					0xf0
#define GLYPH_CIRCLE1				0x100
#define GLYPH_CIRCLE2				0x200

// some handy enums
typedef enum SYSTEM_DENSITY {
	RIFT_DENSITY=0,
	SPARSE_DENSITY,
	SCATTERED_DENSITY,
	STANDARD_DENSITY,
	DENSE_DENSITY
	};

typedef enum TRAVEL_MATURE {
	BACKWATER_MATURE=0,
	STANDARD_MATURE,
	MATURE_MATURE,
	CLUSTER_MATURE
	};

typedef enum PARSE_PARAMS {
	NAME_LENGTH=0,
	HEX_START,
	UWP_START,
	BASE_POS,
	CODE_START,
	ZONE_POS,
	PBG_START,
	ALLEG_START,
	STELLAR_START
	};

// general hex reference stuff
//	route
//		leave everything public
class Route : public ListData
{
public:
	Route(short, short, short);

//	void Destroy(void) { delete this; };
// other end of route
	short	x;
	short	y;
// whoa!! this is an index into the color table _not_ the color
//	(many changes took place)
	short	color;
};

// handle _all_ data formats
class HexData
{
public:
	HexData();
	HexData(LinkedList *rtl);
	~HexData();

	void AddRoute(short x_, short y_, short col);
	void AddBorder(short which, short col);
	void AddCP(char *name);

	main_world		*world;
	LinkedList			*routes;
// keeps track of the color table index
	short			border_ndx[6];
	char			*cp;
};

// =============================================================================
// color look up table
class ColorLookupEntry : public ListData
{
public:
	ColorLookupEntry(unsigned char r, unsigned char g, unsigned char b);
	~ColorLookupEntry();

	unsigned char Red(void) { return(r_val); }; 
	unsigned char Green(void) { return(g_val); }; 
	unsigned char Blue(void) { return(b_val); };
	
	int Translate(void) { return(xlat_val); };

	void SetXlat(int val) { xlat_val = val; };

private:
	unsigned char 	r_val; 
	unsigned char 	g_val; 
	unsigned char 	b_val;

	int				xlat_val;
};

class ColorLookupTable : public LinkedList
{
public:
	ColorLookupTable();
	~ColorLookupTable();

	void AddColor(unsigned char r, unsigned char g, unsigned char b);
	void Clear(void);

	int Translate(int ndx);
	int UnTranslate(int num);
};

// =============================================================================
// general color table
//  for the border and and route 'master' lists
class ColorTableEntry : public LookupEntry
{
public:
	ColorTableEntry(int n, short c, char *d);
	ColorTableEntry();
	~ColorTableEntry();

	int GetIndex(void) { return(ndx); };
	char *GetDesc(void) { return(desc); };
	short GetColor(void) { return(color_ndx); };

//	void NewEntry(short, char *);

	void Clear(void);
	void SetValues(short, char *);
	char *GetFormated(char *);

private:
// aka a caption
	char		*desc;
// internal reference #
	int			ndx;
// index into the (applacation) color table
	short		color_ndx;
};

class ColorTable : public LookupTable
{
public:
	ColorTable(ColorLookupTable *clu);
	~ColorTable();

	ColorTableEntry *Find(int n);

//	ColorTableEntry *FindOrAdd(int, char *);

	char *GetDesc(int n);

	void Clear(void);

	short GetColor(int ndx);
	int GetIndex(short color);
	int AddColor(short c, char *d);

private:
	ColorLookupTable *lu;
};



// full sector
class sector 
{
public:
	sector();
	sector(char *);
	~sector();

// random gen params:
	set_gen_params(SYSTEM_DENSITY pres, TRAVEL_MATURE trav);
// parsing params:
	set_parse_params(int, int, int, int, int, int, int, int, int);


	bool HasWorld(int x, int y);
	HexData *get_hex(int, int);
	HexData *AddOrGetHex(int, int);
	wxBitmap *GetBaseBM(char *key, int ndx) 
		{ return(codes->GetBaseTable()->GetBM(key, ndx)); };

	int load_file(char *);
	void Clear(void);


	int add_planet(short x_, short y_, char *n, char *uwp, char base, 
		char *codes, char zone, char *pbg, char *alleg, char *stars);

	char *GetListing(short x_, short y_, char *buff);

	ColorLookupTable *GetColorLookup(void) { return(color_lookup); };
	CodeTable *GetTradeTable(void) { return(codes->GetTradeTable()); };
	CodeTable *GetCodeTable(void) { return(codes->GetOtherTable()); };
	CodeTable *GetAllegTable(void) { return(codes->GetAllegTable()); };
	CodeTable *GetSystTable(void) { return(codes->GetSystTable()); };
	BaseTable *GetBaseTable(void) { return(codes->GetBaseTable()); };
	ColorTable *GetRouteTable(void) { return(route_list); };
	ColorTable *GetBorderTable(void) { return(border_list); };

	void WriteCfg(char *);
	void WriteDat(void);
	void WriteSec(void);

	char *GetName(void) { return(name); };
	char *GetDatName(void) { return(dat_name); };
	char *GetSecName(void) { return(sec_name); };

	char *GetSSName(int ndx) { return(ss_names[ndx]); };
	void SetSSName(int ndx, char *name);

	// misc formating helpers
	char *FormatBase(char code, char *buff);
	char *FormatTrade(unsigned long code, char *buff) 
		{ return(FormatCode(codes->GetTradeTable(), code, buff)); };
	char *FormatOther(unsigned long code, char *buff) 
		{ return(FormatCode(codes->GetOtherTable(), code, buff)); };
	char *FormatZone(char code, char *buff);
	char *FormatAlleg(char *code, char *buff);

	int GetCount(int start_x, int start_y, int end_x, int end_y);


	char *FormatCode(CodeTable *ct, unsigned long code, char *buff);


private:
	char				*name;
	char				*dat_name;
	char				*sec_name;
	char				*ss_names[MAX_SS];

// gen params:
	SYSTEM_DENSITY		dens;
	TRAVEL_MATURE		trav;
// parsing params (for .sec file):
	short				parse_params[10];
// actual data:
	HexData			*hex_info[MAX_X_HEX][MAX_Y_HEX];

// (global level) look up tables
//	CodeTable					*trade_table;
//	CodeTable					*other_table;
//	BaseTable					*base_table;
//	CodeTable					*alleg_table;
	TCode						*codes;

// (file level) look up tables
	ColorTable					*border_list;
	ColorTable					*route_list;
	ColorLookupTable			*color_lookup;

	void init_sector(void);

	int GenericParse(char *buff, char **dest, int count);

	// for main (.sec) file:
	char *parse_star(char *src, char *dest);
	void ParseCodes(char *, unsigned long *, unsigned long *);
	int parse_first(char *buff);
	int parse_second(char *buff);
	void parse_and_add_base(char *buff);
	int parse_and_add_world(char *buff);
	void ParseAndAddCode(LinkedList *ll, char *buff);
	int load_sector(FILE *fpx);
	int valid_loc(char *, short *, short *);

	// for aux (.dat) file:
	void load_aux_sector(FILE *fpx);
	void ParseAndAddBorder(char *buff);
	void ParseAndAddRoute(char *buff);
	void ParseAndAddSS(char *buff);
	void ParseAndAddCP(char *buff);
	void ParseAndAddBorderList(char *buff);
	void ParseAndAddRouteList(char *buff);
	void ParseAndAddColor(char *buff);

	// file helpers
	void WriteHeader(FILE *, char *, char *);

// stuff for random gen
	static short				dens_rolls[5];
	static char					*trav_ports[11];

};

#endif

