/*
 * File:      planet.h
 * Purpose:   base definitions for a planet and for a main world
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: planet.h,v $ $Revision: 1.6 $ $Author: man $ $Date: 2001/12/02 18:11:58 $" */


#ifndef PLANET_H
#define PLANET_H

#include "uwp.h"
#include "basestar.h"

class base_planet : public uwp
{
friend class planet;
public:
	base_planet(char *n, char *u);
	base_planet(char *n, char *u, char b, 
		unsigned long co, unsigned long cx, char z=' ', char *a=NULL);
	base_planet();
	base_planet(base_planet *);
	~base_planet();

	char *GetName(char *);
	char *GetUWPStr(char *);

	char *GetName(void) { return(name); };
	char GetZone(void) { return(t_zone); };
	char *GetAlleg(void) { return(alig); };
	char GetBase(void) { return(bases); };

	unsigned long GetTradeCodes(void) { return(trade_class); };
	unsigned long GetOtherCodes(void) { return(other_class); };

	float GetWorldRadius(void) { return(GetRadius()); };

	// XXX
    void SetPortVal(short v);
	void SetSizeVal(short v);
	void SetAtmosVal(short v);
	void SetHydroVal(short v);
	void SetPopVal(short v);
	void SetGovtVal(short v);
	void SetLawVal(short v);
	void SetTechVal(short v);

	void SetName(char *n);
	void SetZone(char z) { t_zone = z; };
	void SetAlleg(char *a);
	void SetBase(char b) { bases = b; };

	void SetTradeCodes(unsigned long t) { trade_class = t; };
	void SetOtherCodes(unsigned long o) { other_class = o; };

private:
//	uwp			*uwp_data;
	char		*name;

	char			bases;
	unsigned long	trade_class;
	unsigned long	other_class;
	char			t_zone;

	char			alig[3];
};

// NOTE NOTE NOTE:
//	there''s 2 mechanisms here:
//	1) random generation
//	2) parsing
//  either way, the class needs to be created before hand
class main_world : public base_planet
{
public:
	main_world();
	main_world(main_world *);
	main_world(char *n, short l_x, short l_y, char *u, char b, 
		unsigned long co, unsigned long cx, char z, char *a, 
		short p, short be, short g, char *s1, char *s2, char *s3);
	main_world(char *n, short l_x, short l_y, char *u, short be, short g,
		char *s1, char *s2, char *s3);
	main_world(char *n, short l_x, short l_y, char *u);
	~main_world();

	short GetNumGG(void) { return(gg); };
	short GetPopNdx(void) { return(pop_ndx); };
	short GetNumBelts(void) { return(belts); };

	char *GetStarStr(char *buff);
	char *GetStarStr(int ndx, char *buff);
	BaseStar *GetStar(int ndx);

	short GetLocX(void) { return(loc_x); };
	short GetLocY(void) { return(loc_y); };

	int GetNumStars(void);
	short GetStarType(int ndx);
	short GetStarSize(int ndx);
	short GetStarClass(int ndx);
	void SetStar(int ndx, char *);
	void SetStar(int ndx, int t, int s, int c);

	void SetPopNdx(int p) { pop_ndx = p; };
	void SetNumGG(int g) { gg = g; };
	void SetNumBelts(int b) { belts = b; };

private:
	void ParseStars(char *s1, char *s2, char *s3);
	void CleanUpParse(void);

	short			loc_x;
	short			loc_y;

	short			pop_ndx;
	short			belts;
	short			gg;

// i''m leaving this a hard code, since 'MAX_STARS' will be used
//  differently elsewhere........
	BaseStar		*stars[3];
};

// planet flags
// (hardcoded in this program)
//#define PLANET_FLAG_FARMING			0x01
//#define PLANET_FLAG_MINING			0x02
//#define PLANET_FLAG_COLONY			0x04
//#define PLANET_FLAG_LAB				0x08
//#define PLANET_FLAG_MILITARY		0x10

// simple planet for systems generation
//  it''s main distinction it that it can be edited
class planet : public base_planet
{
public:
	planet();
	planet(planet *);
//	planet(short s, float o, char *n, char *u, unsigned long f);
	planet(char *n, char *u, char b, unsigned long co, unsigned long cx, 
		unsigned long cs, char z, char *a);
	~planet();

//	float GetOrbit(void) { return(orbit); };
//	short GetSndx(void) { return(sndx); };
//	unsigned long GetFlags(void) { return(flags); };
//	Bool HasFarming(void) { return(flags & PLANET_FLAG_FARMING); };
//	Bool HasMining(void) { return(flags & PLANET_FLAG_MINING); };
//	Bool IsColony(void) { return(flags & PLANET_FLAG_COLONY); };
//	Bool HasLab(void) { return(flags & PLANET_FLAG_LAB); };
//	Bool HasMilitary(void) { return(flags & PLANET_FLAG_MILITARY); };

//	void SetOrbit(float o) { orbit = o; };
//	void SetSndx(short s) { sndx = s; };
//	void SetFarming() { flags |= PLANET_FLAG_FARMING; };
//	void ClearFarming() { flags &= ~PLANET_FLAG_FARMING; };
//	void SetMining() { flags |= PLANET_FLAG_MINING; };
//	void ClearMining() { flags &= ~PLANET_FLAG_MINING; };
//	void SetColony() { flags |= PLANET_FLAG_COLONY; };
//	void ClearColony() { flags &= ~PLANET_FLAG_COLONY; };
//	void SetLab() { flags |= PLANET_FLAG_LAB; };
//	void ClearLab() { flags &= ~PLANET_FLAG_LAB; };
//	void SetMilitary() { flags |= PLANET_FLAG_MILITARY; };
//	void ClearMilitary() { flags &= ~PLANET_FLAG_MILITARY; };

	unsigned long GetSysFlags(void) { return(sys_flags); };

	void SetSysFlags(unsigned long f) { sys_flags = f; };

private:
//	float		orbit;
//	short		sndx;

//	unsigned long	flags;
	unsigned long	sys_flags;

};

#endif

