/*
 * File:		mtu_file.h
 * Purpose:		handle all dirs and files for the mtu suite
 * 				(replacement for mtu_dir)
 * Author:		Mark A. Nordstrand
 * Created:		Sun Mar 17 06:50:12 CST 2002
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: mtu_file.h,v $ $Revision: 1.12 $ $Author: man $ $Date: 2002/10/09 02:18:24 $" */

#ifndef MTU_FILE_H
#define MTU_FILE_H

#include "wx/confbase.h"
#include "wx/fileconf.h"

#define MTUD_NOTES		0x01
#define MTUD_SYS		0x02
#define MTUD_ENC		0x04
#define MTUD_WORLD		0x08
#define MTUD_TRADE		0x10
#define MTUD_ALL	(MTUD_NOTES | MTUD_SYS | MTUD_ENC | MTUD_WORLD | MTUD_TRADE)

class MTUFile
{
public:
	MTUFile();
	~MTUFile();

	// the first 2 could just return the private member,
	//  however, for consistancy, they allocate a new string
	char *GetDataDir(void) { return(data_dir); };
	char *GetHelpDir(void) { return(help_dir); };
	char *GetMTUDir(void) { return(mtu_dir); };
	// some not so common ones
	char *GetMTUDataDir(void) { return(mtu_data); };
	char *GetUnivDir(void) { return(univ_dir); };
	char *GetUnivFile(void) { return(univ_file); };
	char *GetSectDir(void) { return(sect_dir); };
	char *GetSectSecFile(void) { return(sect_sec); };
	char *GetSectDatFile(void) { return(sect_dat); };

	char *GetSectTextDir(void) { return(CheckDir(sect_text)); };
	char *GetSectEncDir(void) { return(CheckDir(sect_enc)); };
	char *GetSectSysDir(void) { return(CheckDir(sect_sys)); };
	char *GetSectWorldDir(void) { return(CheckDir(sect_world)); };
	char *GetSectTradeDir(void) { return(CheckDir(sect_trade)); };

	// full program names
	char *GetSector(void) { return(sector); };
	char *GetSystem(void) { return(system); };
	char *GetSysgen(void) { return(sysgen); };
	char *GetWorld(void) { return(world); };
	char *GetEncTbl(void) { return(enc_tbl); };
	char *GetWord(void) { return(word); };
	char *GetTrade(void) { return(trade); };
	char *GetSecGen(void) { return(secgen); };
	// XXX should be system wide.....
	char *GetEditor(void) { return(editor); };
	char *GetGraphics(void) { return(graphics); };
	char *GetViewer(void) { return(viewer); };

	void CrackNames(char *n);

	void Load(void);

	// make it so we only need one pointer
	wxConfig *GetConfig(void) { return(config); };

	// I really, really dislike this function
	void VerifyDirs(unsigned int which=MTUD_ALL);

private:
	void GetRString(char **dest, char *section, char *entry);
	void GetEString(char **dest, char *section, char *entry);
	char *BuildString(char *ptr1, char *ptr2);
	void ClearExtra(bool u);
	void BuildUniv(char *u_dir);
	void BuildSect(bool abs, char *s_dir);
	char *CheckDir(char *dir);

	// resource pointer
	wxConfig 		*config;

	// stuff (almost) directly from the resource file
	// main dirs of interest
	char		*data_dir;		// top most data dir (ie. /usr/traveller/data)
	char		*exec_dir;		// where the executables live
	char		*help_dir;		// where help files live (tbd)
	char		*mtu_dir;		// mtu dir
	// every executable we care about
	char		*sector;
	char		*system;
	char		*sysgen;
	char		*world;
	char		*enc_tbl;
	char		*word;
	char		*trade;
	char		*secgen;
	char		*editor;
	char		*graphics;
	char		*viewer;

	// some string we build
	char	*mtu_data;	// /usr/traveller/data/mtu/data
	char	*univ_dir;	// /usr/traveller/data/mtu/classic
	char	*univ_file;	// /usr/traveller/data/mtu/classic/classic.dat
	char	*sect_dir;	// /usr/traveller/data/mtu/classic/spinmar
	char	*sect_sec;	// /usr/traveller/data/mtu/classic/spinmar/spinmar.sec
	char	*sect_dat;	// /usr/traveller/data/mtu/classic/spinmar/spinmar.dat
	char	*sect_text;	// /usr/traveller/data/mtu/classic/spinmar/desc
	char	*sect_enc;	// /usr/traveller/data/mtu/classic/spinmar/enc
	char	*sect_sys;	// /usr/traveller/data/mtu/classic/spinmar/sys
	char	*sect_world;// /usr/traveller/data/mtu/classic/spinmar/world
	char	*sect_trade;// /usr/traveller/data/mtu/classic/spinmar/trade
};

#endif

