/*
 * File:      llist.h
 * Purpose:   first attempt at a generac linked list class.....
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: llist.h,v $ $Revision: 1.4 $ $Author: man $ $Date: 1999/09/18 15:13:54 $" */


#ifndef LLIST_H
#define LLIST_H

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#ifdef LLIST_DEBUG
#include <stdio.h>
#endif

// yes, it could be template based......

class ListData
{
public:
	ListData();
	virtual ~ListData();
};

class ListNode
{
public:
	ListNode();
	ListNode(ListData *ld);
	virtual ~ListNode();

	ListData *Data(void) { return(data); };
	ListNode *Next(void) { return(next); };
	ListNode *Prev(void) { return(prev); };

	// should only be accessed by LinkedList
	void SetNext(ListNode *d) { next = d; };
	void SetPrev(ListNode *d) { prev = d; };

	ListData *GetData(void) { return(data); };
//	void SetData(void *d) { data = d; };

#ifdef LLIST_DEBUG
	void Dump(FILE *fpx);
#endif

private:
	ListNode		*next;
	ListNode		*prev;
	ListData		*data;
//	void			*data;
};

// make the linked list itself list data
//  this way, we can have lists of lists
class LinkedList : public ListData
{
public:
	LinkedList();
//	LinkedList(ListNode *);
	virtual ~LinkedList();

// stuff to add/remove to list
	int RemoveAll(void);
	int Remove(int ndx=-1);
//	int Append(void *ptr);
//	int Insert(void *ptr, int ndx=-1);
	int Append(ListData *ptr);
	int Insert(ListData *ptr, int ndx=-1);
	bool Insert(ListData *ptr, ListNode *n);

// handy utility:
	unsigned int Count(void) { return(count); };

// stuff to get actual data:
	ListData *CurrentData(void);
//	ListData *NextData(void);
//	ListData *PrevData(void);
//	ListData *FirstData(void);
//	ListData *LastData(void);
	ListData *NthData(int n);

// stuff to get a ListNode:
	ListNode *Current(void) { return(current); };
	ListNode *Next(void);
	ListNode *Prev(void);
	ListNode *First(void);
	ListNode *Last(void);
	ListNode *Nth(int n);

#ifdef LLIST_DEBUG
	void Dump(FILE *fpx);
#endif

	bool DeleteNode(ListNode *n);

private:
	ListNode		*head;
	ListNode		*tail;
	ListNode		*current;
	int				count;
};



#endif

