//
// File:		hex_fmt.h
// Purpose:		hex formatting
// Author:		Mark A. Nordstrand
// Created:
// Updated:	
// Copyright:	LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: hex_fmt.h,v $ $Revision: 1.1 $ $Author: man $ $Date: 2002/10/03 10:53:15 $"


#ifndef HEX_FMT_H
#define HEX_FMT_H

typedef enum {
// of course, this takes no space
	HD_NONE=0,
// the following use up to 3 'spaces':
	HD_NUMBER,
	HD_NAME,
	HD_NAME_POP,
	HD_UWP,
	HD_UWP_NO_PORT,
	HD_UWP_FILTERED,
	HD_TRADE_CODES,
// the next ones take only a single 'space':
	HD_PORT,
	HD_SIZE,
	HD_ATMOS,
	HD_HYDRO,
	HD_POP,
	HD_GOVT,
	HD_LAW,
	HD_TECH,
	HD_BASE_CODE,
	HD_ALLEG,
	HD_GG_NUM,
	HD_BELTS_NUM,
	HD_POP_NDX,
	HD_NUM_STAR,
// special ones using bitmaps or coloring and only a single space
	HD_BASE_BM1,
	HD_BASE_BM2,
	HD_GG_BM,
	HD_BELTS_BM,
	HD_STAR_BM1,
	HD_STAR_BM2,
	HD_STAR_BM3,
	HD_MW_BM,
	HD_MW_PRESENT,
	HD_MW_HYDRO_BM
} HEX_DISPLAY;

#define MAX_HEX_DISPLAY		(HD_MW_HYDRO_BM + 1)
#define MAX_LAYOUT_X		3
#define MAX_LAYOUT_Y		5

class HexLayout
{
public:
	HexLayout();
	HexLayout(HexLayout *hl);
//	HexLayout(char *buff);
	~HexLayout();

	HEX_DISPLAY GetCode(int x, int y);
	void SetCode(int x, int y, HEX_DISPLAY c);

	// mostly for the sake of the dialog box...
	char *GetString(HEX_DISPLAY c, bool alt=0);

	unsigned char GetUWPFilter(void) { return(uwp_filter); };
	void SetUWPFilter(unsigned char c)  { uwp_filter = c; };

	char *FilterUWP(char *buff);

	void Reset(void);

	bool IsDefault(int x, int y);

private:
	bool ValidCoord(int x, int y);
	HEX_DISPLAY GetDefaultCode(int x, int y);

	HEX_DISPLAY		code[MAX_LAYOUT_X][MAX_LAYOUT_Y];
	unsigned char	uwp_filter;
};

#if 0
a bit of visualization for the above....
   _______
  /r1r1 r1\
 /r2 r2 r2 \
/ r3 r3 r3  \
\ r4 r4 r4  /
 \r5 r5 r5 /
  \_______/

#endif

#endif

