/*
 * File:      d_star.h
 * Purpose:   more detailed stars
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: d_star.h,v $ $Revision: 1.8 $ $Author: man $ $Date: 2003/11/02 03:07:41 $" */


#ifndef D_STAR_H
#define D_STAR_H

#include "basestar.h"

#define MAX_HALF_CLASS		((MAX_STAR_TYPES + 1) * 2)

// this is only needed internally 
//  (it really should be private/hidden):
struct StarZones
{
	char first;
	char habital;
};

class DetailStar : public BaseStar
{
friend class GenStar;
public:
	DetailStar();
	DetailStar(char *n, int, int, int);
	DetailStar(char *, char *);
	~DetailStar();

	char *GetName(char *);
	void SetName(char *);

	// book 6 information:
	double GetMag(void);
	double GetLumin(void);
	double GetTemp(void);
	double GetRad(void);
	double GetMass(void);

	char *GetClassDesc(char *);
	char *GetSizeDesc(char *);
	char *GetSizeName(void);

	// these use orbit # and assume the constant B/D values 
	//  implied in book 6
	int GetFirstOrbit(void);
	int GetHabZone(void);

	// these results are all in AU and are liberally taken form FI
	//  NOTE:  use OrbitConversion() conversions to get orbit number
	double GetInnerLimit(void);
	double GetInnerLifeZone(void);
	double GetOuterLifeZone(void);
	double GetSnowLine(void);
	double GetOuterLimit(void);

	HAB_ZONE CheckHabit(double orbnum);

private:
	int GetIndex(void);
	int GetIndex2(void);
	double Interpolate(double v1, double v2);

	static struct StarZones StarOrbits[MAX_STAR_SIZES+1][MAX_HALF_CLASS];
	static double StarMag[MAX_STAR_SIZES+1][MAX_HALF_CLASS];
	static double StarLumin[MAX_STAR_SIZES+1][MAX_HALF_CLASS];
	static double StarTemp[MAX_STAR_SIZES+1][MAX_HALF_CLASS];
	static double StarRad[MAX_STAR_SIZES+1][MAX_HALF_CLASS];
	static double StarMass[MAX_STAR_SIZES+1][MAX_HALF_CLASS];
								// all indexed by size and half class
    static char *StarNames[MAX_STAR_SIZES+1];

//	short class_ndx;					// aka half class
										// needed for StarOrbits table
										//  will this go away? 

	char		*name;
	// used for generation
};



#endif
