/*
 * File:      color.h
 * Purpose:   misc color utils
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: color.h,v $ $Revision: 1.5 $ $Author: man $ $Date: 2001/12/02 18:11:58 $" */


#ifndef TRAV_COLOR_H
#define TRAV_COLOR_H

#include "codetbl.h"

// ------------------------------------------------------------------
#define BASE_COLORS			8
#define CUSTOM_COLORS		(64 - BASE_COLORS)
#define TOTAL_COLORS		(CUSTOM_COLORS + BASE_COLORS)

// ------------------------------------------------------------------
#define BLACK_COLOR_INDEX			0
#define WHITE_COLOR_INDEX			(BASE_COLORS - 1)

// =============================================================================
// although it may seem that the color concept might be GUI dependent,
// the fact is, it's only used for indexing at this level
//  (sorry, I've been struggling with this way too long!)
// =============================================================================
// general color table
//  for the border and and route 'master' lists
class ColorTableEntry : public LookupEntry
{
public:
	ColorTableEntry(int n, short c, char *d);
	ColorTableEntry();
	~ColorTableEntry();

	int GetIndex(void) { return(ndx); };
	char *GetDesc(void) { return(desc); };
	short GetColor(void) { return(color_ndx); };

//	void NewEntry(short, char *);

	void Clear(void);
	void SetValues(short, char *);
	char *GetFormated(char *);
	char *GetSaveFormated(char *);

#ifdef DEBUG_COLOR_LIST
	void Dump(FILE *);
#endif

private:
// aka a caption
	char		*desc;
// internal reference #
	int			ndx;
// index into the (application) color table
	short		color_ndx;
};

class ColorTable : public LookupTable
{
public:
//	ColorTable(ColorLookupTable *clu);
	ColorTable();
	~ColorTable();

	ColorTableEntry *Find(int n);

//	ColorTableEntry *FindOrAdd(int, char *);

	char *GetDesc(int n);

	void Clear(void);

//	short GetColor(int ndx) { return(ndx); };
	short GetColor(int ndx);
	int GetIndex(short color);
	int AddColor(short c, char *d);

	void Load(char *buff, bool local=FALSE);

#ifdef DEBUG_COLOR_LIST
	void Dump(FILE *);
#endif
private:
};



#endif
