/*
 * File:      basestar.h
 * Purpose:   common decl. for stars
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: basestar.h,v $ $Revision: 1.7 $ $Author: man $ $Date: 2003/11/02 03:00:59 $" */

// simplest bit of star information
//  just track type, class, and size
//  while making sure they are valid values.

#ifndef BASESTAR_H
#define BASESTAR_H

#define	MAX_STAR_TYPES			6
#define MAX_STAR_SIZES			7

// traveller habitible zones
//  why here?
//  needed for uwp_dlg.h....
typedef enum HAB_ZONE {
	HAB_IN_STAR=-2,
	HAB_INNER=-1,
	HAB_HABIT=0,
	HAB_OUTER=1,
	HAB_OUTER_2=2,
	HAB_UNKNOWN=-3
};

class BaseStar
{
friend class DetailStar;
friend class GenStar;
//friend class FullStar;
public:
	BaseStar();
	BaseStar(int, int, int);
	BaseStar(char *);
	BaseStar(BaseStar *);
	~BaseStar() {};

	int GetStarType(void) { return(type); };
	int GetStarClass(void) { return(cls); };
	int GetStarSize(void) { return(size); };

	void SetStarType(int t);
	void SetStarClass(int c);
	void SetStarSize(int s);

	void SetStarParams(int t, int c, int s);
	void SetStarParams(char *);
	
	char *GetStarStr(char *);

	char *GetColor(char *);
	char *GetDesc(char *);

	bool Ok(void);

private:
	void Check(void);

	static char types[MAX_STAR_TYPES+2];
	static char sizes[MAX_STAR_SIZES+1][4];	
	static char *colors[MAX_STAR_TYPES+1];

	int		type;
	int		cls;
	int		size;
};



#endif

