/*
 * File:		enc_dlg.h
 * Purpose:		general dialogs for animal encounters
 * Author:	
 * Created:	
 * Updated:	
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: enc_dlg.h,v $ $Revision: 1.4 $ $Author: man $ $Date: 2003/05/04 16:30:56 $" */

#ifndef ENC_DLG_H
#define ENC_DLG_H

#include "t_dlg.h"
#include "uwp_dlg.h"
#include "t_code.h"
#include "enc.h"

// ====================================================
// hokey way to pass stuff around
struct conf_struct {
	char			*name;
	char			*sect;
	char			*ssect;
	char			*loc;
	char			uwp[9];
	ENC_GEN			method;
	TERRAIN_TYPE	ter;
	TRAV_VER		trav_version;
	char			*out_file;
	// table stuff
	//  for now, leave 'em static
	int				die_size;
	int				num_die;
//	char			*table;
	char			*table_1d6;
	char			*table_2d6;
	char			*table_1d20;
	bool			quiet_mode;
	bool			no_sleep;
};

// ====================================================
class EncDialog : public StdDialog
{
public:
	EncDialog(wxWindow *p);
	~EncDialog() {};

	bool GetConfig(struct conf_struct *cfg);
	
	void DoTerr(wxCommandEvent& event) { SetTerrain(); };
	void DoDice(wxCommandEvent& evnet) { DoFormat(); };

	void SetTerrain(void);
	void DoFormat(void);

	DECLARE_EVENT_TABLE()

private:
	EncTerrain		terrain_table;

	UWPBox			*uwp_box;

	wxTextCtrl		*name;
	wxTextCtrl		*sect;
	wxTextCtrl		*ss;
	wxTextCtrl		*loc;

	wxRadioBox		*vers;

	wxRadioBox		*method;

	wxChoice		*terrain;

	wxRadioBox		*dice;
	wxTextCtrl		*dice_str[3];

	wxStaticText	*equiv;

	bool			ready;
};

#endif

