/*
 * File:      enc.h
 * Purpose:   handle the look-up tables for encounter gen
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: enc.h,v $ $Revision: 1.2 $ $Author: man $ $Date: 1999/04/06 04:25:07 $" */


#ifndef END_H
#define END_H

#include <stdio.h>
#include "t_dice.h"
#include "wx/list.h"


// ====================================================
// generation enum
typedef enum ENC_GEN {
	EG_SINGLE_ROLL=0,
	EG_SINGLE_TABLE,
	EG_FULL 
	};

typedef enum TRAV_VER {
	TV_CT=0,
	TV_MT,
	TV_TNE,
	TV_T4 };

typedef enum CT_ARMOUR_TYPE {
	CAT_NONE=0,
	CAT_JACK,
	CAT_MESH,
	CAT_CLOTH };

typedef enum MT_ARMOUR_TYPE {
	MAT_NONE=0,
	MAT_JACK,
	MAT_MESH,
	MAT_MESH1,
	MAT_CLOTH,
	MAT_CLOTH1,
	MAT_REFLEC,
	MAT_ABLAT,
	MAT_BATTLE,
	MAT_COMBAT4 };

typedef enum TNE_ARMOUR_TYPE {
	TAT_NONE=0,
	TAT_HALF,
	TAT_HALF_HEAD1,
	TAT_ONE_HEAD2,
	TAT_TWO_HEAD3,
	TAT_THREE };

typedef enum T4_ARMOUR_TYPE {
	T4AT_NONE=0,
	T4AT_ONE,
	T4AT_ONE_RIGID,
	T4AT_TWO,
	T4AT_TWO_RIGID,
	T4AT_THREE,
	T4AT_THREE_RIGID,
	T4AT_FOUR,
	T4AT_FOUR_RIGID,
	};

typedef enum MT_WEAPON_TYPE {
	MWT_HORNS_HOOVES=0,
	MWT_HORNS,
	MWT_HOOVES_TEETH,
	MWT_HOOVES,
	MWT_HORNS_TEETH,
	MWT_THRASHER,
	MWT_CLAWS_TEETH,
	MWT_TEETH,
	MWT_CLAWS,
	MWT_CLAWS1,
	MWT_STINGER,
	MWT_CLAWS1_TEETH1,
	MWT_TEETH1,
	MWT_BLADE,		// dagger in t4
	MWT_PIKE,		// spear in t4
	MWT_BROADSWORD,
	MWT_BODY_PISTOL };

typedef enum TNE_WEAPON_TYPE {
	TWT_HOOVES_TEETH,
	TWT_TRAMPLE,
	TWT_HOOVES,
	TWT_HORNS_HOOVES,
	TWT_HORNS,
	TWT_QUILLS,
	TWT_TAIL,
	TWT_PROJECTILE,
	TWT_ACID,
	TWT_CLAWS_TEETH,
	TWT_COILS,
	TWT_CLAWS,
	TWT_TEETH,
	TWT_POISON_TEETH,
	TWT_POISON_CLAWS,
	TWT_POISON_QUILLS,
	TWT_POISON_STINGER,
	TWT_TENTACLE_ACID,
	TWT_TENTACLE_POISON,
	TWT_TENTACLE_TEETH
};

// convience enums
typedef enum ROLL_TYPE {
	RT_POSSIBLE=0,
	RT_SURPRISE,
	RT_SURPRISED,
	RT_MORE,
	RT_1D_M_5,
	RT_1D_M_4,
	RT_1D_M_3,
	RT_1D_M_2,
	RT_1D_M_1,
	RT_1D,
	RT_1D_P_1,
	RT_1D_P_2,
	RT_1D_P_3,
	RT_2D,
	RT_3D,
	RT_3D_P_2,
	RT_5,
	RT_6,
	RT_7,
	RT_8,
	RT_9,
	RT_10,
	RT_11
	};
	
typedef enum ANIMAL_CLASS {
	AC_HERBIVORE=0,
	AC_OMNIVORE,
	AC_CARNIVORE,
	AC_SCAVENGER };
#define MAX_ANIMAL_CLASS	(AC_SCAVENGER + 1)

typedef enum ANIMAL_TYPE {
	AT_FILTER = 0,
	AT_INTERMITTENT,
	AT_GRAZER,
	AT_GATHERER,
	AT_HUNTER,
	AT_EATER,
	AT_POUNCER,
	AT_CHASER,
	AT_TRAPPER,
	AT_SIREN,
	AT_KILLER,
	AT_HIJACKER,
	AT_INTIMIDATOR,
	AT_CARRION_EATER,
	AT_REDUCER };
#define MAX_ANIMAL_TYPE		(AT_REDUCER + 1)

typedef enum ANIMAL_QUALIFIER {
	AQ_NONE=0,
	AQ_SWIMMER,
	AQ_AMPHIBIAN,
	AQ_FLYER,
	AQ_TRIPHIBIAN };

typedef enum TERRAIN_TYPE {
	TER_Beach=0,
	TER_Bottom,
	TER_Broken,
	TER_Cave,
	TER_Chasm,
	TER_Clear,
	TER_Crater,
	TER_Depths,
	TER_Desert,
	TER_Forest,
	TER_Glacier,
	TER_Jungle,
	TER_Marsh,
	TER_Mountain,
	TER_Prairie,
	TER_River,
	TER_Rough,
	TER_Ruins,
	TER_Sargasso,
	TER_SeaCave,
	TER_Shallows,
	TER_Surface,
	TER_Swamp };
#define MAX_TERRAIN		(TER_Swamp + 1)

typedef enum TNE_ATTACK_AS {
	TAA_ARMED_MELEE=0,
	TAA_DIVING_BLOW,
	TAA_DEFENSE_ONLY,
	TAA_THROWN,
	TAA_STRANGLE };

typedef enum CT_SPEEDS {
	CS_ONE=0,
	CS_TWO,
	CS_THREE,
	CS_ONE_ZERO,
	CS_ONE_TWO,
	CS_THREE_TWO,
	CS_TWO_ONE
	};

#define DEFAULT_1D6		"SHHHOC"
#define DEFAULT_2D6		"SOSOHHHCCCC"
#define DEFAULT_D20		"HHHHHHHHHOOOOCCCCSSS"

// ==========================================================================
class EncTerrain 
{
public:
	EncTerrain() {};
	~EncTerrain() {};

	char *GetTerrain(TERRAIN_TYPE t);
	char *GetEquiv(TERRAIN_TYPE t);
	char *GetEncHeader(TRAV_VER v, char *buff, bool Table=TRUE);
};

// ==========================================================================
// base animal encounter
class Encounter : public wxObject
{
public:
	Encounter() : wxObject() {};
	~Encounter() {};

	virtual char *GetEnc(TRAV_VER v, char *buff)=0;
	virtual bool IsEvent(void)=0;
private:
};

// ---------------------------------------------------------------------------
// not implemented (yet?)
#if 0
class Event : public Encounter
{
public:
	Event(char *e);
	~Event();

	char *GetEnc(TRAV_VER v, char *buff);
	bool IsEvent(void) { return(TRUE); };

private:
	char	*event;
};
#endif
// ---------------------------------------------------------------------------
class AnimalEncounter : public Encounter
{
public:
	AnimalEncounter(TERRAIN_TYPE t, ANIMAL_CLASS a, char *uwp);
	AnimalEncounter(TERRAIN_TYPE t, char c, char *uwp);
	~AnimalEncounter();

	char *GetEnc(TRAV_VER v, char *buff);
	bool IsEvent(void) { return(FALSE); };
private:
	Dice	*dice;

	int					num;
	ANIMAL_TYPE			type;
	ANIMAL_QUALIFIER	qualifier;
	int					mass;
	int					mt_hits;
	int					tne_hits;
	int					t4_hits[2];		// also ct
	int					ct_wounds;
	int					mt_wounds;
	int					t4_wounds;
	CT_ARMOUR_TYPE		ct_armor;
	MT_ARMOUR_TYPE		mt_armor;
	TNE_ARMOUR_TYPE		tne_armor;
	T4_ARMOUR_TYPE		t4_armor;
	MT_WEAPON_TYPE		ct_weapon;
	MT_WEAPON_TYPE		mt_weapon;
	TNE_WEAPON_TYPE		tne_weapon;
	MT_WEAPON_TYPE		t4_weapon;
	int					tne_to_hit;
	int					tne_dam;
	int					tne_dam2;
	int					tne_pen;
	int					tne_range;
	TNE_ATTACK_AS 		tne_attack_as;
	int					tne_init;
	int					ct_attack;
	int					ct_flee;
	int					ct_speed;
	int					mt_attack;		// also t4
	int					mt_flee;
	int					mt_speed;
	int					tne_attack;
	int					tne_flee;
	int					tne_speed;

	// some internal helpers
	void Init(TERRAIN_TYPE t, ANIMAL_CLASS a, char *uwp);
	MT_WEAPON_TYPE TravWeapon(int roll);
	int CrackTypeCode(ROLL_TYPE t);
	int CrackSpeedCode(CT_SPEEDS s);

	void GetCTEnc(char *buff);
	void GetMTEnc(char *buff);
	void GetTNEEnc(char *buff);
	void GetT4Enc(char *buff);

	char *GetCTArmour(CT_ARMOUR_TYPE a);
	char *GetMTArmour(MT_ARMOUR_TYPE a);
	char *GetTNEArmour(TNE_ARMOUR_TYPE a);
	char *GetT4Armour(T4_ARMOUR_TYPE a);
	char *GetMTWeapon(MT_WEAPON_TYPE w);
	char *GetTNEWeapon(TNE_WEAPON_TYPE w);

	char *DecodeAttackFlee(int val, char *buff);
};


// ==========================================================================
// animal encounter table

// ==========================================================================
// individual table
class EncounterTable : public wxList
{
public:
	EncounterTable(TERRAIN_TYPE t, char *uwp, int size, int num, char *f);
	~EncounterTable();

	AnimalEncounter *GetEnc(int ndx);
private:
};

// ==========================================================================
// full animal encounter
//  wrapper for all tables
class EncounterTables 
{
public:
	EncounterTables(char *uwp, int size, int num, char *f);
	~EncounterTables();

	EncounterTable *GetTable(TERRAIN_TYPE t) { return(table[t]); };
private:
	TRAV_VER			vers;

	int					die_size;
	int					die_num;
	char				*format;
	Dice				*dice;
	EncounterTable		*table[MAX_TERRAIN];
};


// ==========================================================================

#endif

