//
// File:		adjust.cpp
// Purpose:		adjust sector offsets
// Author:		Mark A. Nordstrand
// Created:
// Updated:	
// Copyright:	LGPL
// Traveller is a registered trademark of Far Future Enterprises.
// Portions based upon material Copyright 1977-2002 Far Future Enterprises.
//
// rcsid[] = "$RCSfile: adjust.cpp,v $ $Revision: 1.1 $ $Author: man $ $Date: 2002/03/27 02:16:50 $"

#include <stdio.h>
#include <stdlib.h>
#include "parse.h"

// why?  
// the galactic program uses the spinward marches as sector 0,0
//  every reference on galatic mapping has core as sector 0,0

// what?
// read in a universe .dat file and adjust all the coordinates by
//  -4, -1   

#define BUFFER_SIZE		80

int
main(int argc, char *argv[])
{
bool err=1;

	if(argc != 1) {
		char buffer1[BUFFER_SIZE],*ptrs[6];
		int x,y;
		FILE *in,*out;
		GenericParse p;

		if((in = fopen(argv[1], "r")) != NULL) {
			sprintf(buffer1, "%s.new", argv[1]);
			if((out = fopen(buffer1, "a")) == NULL) {
				fprintf(stderr, "Could not open %s\n", buffer1);
				fclose(in);
			} else {
				while(fgets(buffer1, BUFFER_SIZE, in) != NULL) {
					err = 0;
					if('#' == buffer1[0]) {
						fprintf(out, "%s", buffer1);
						continue;
					}
					p.Parse(buffer1, ptrs, 6, ':');
					x = atoi(ptrs[2]);
					y = atoi(ptrs[3]);
					fprintf(out, "%s:%s:%d:%d:%s\n", ptrs[0], ptrs[1], x - 4,
							y - 1, ptrs[4]);
				}
				fclose(in);
				fclose(out);
			}
		}
	}

	if(err) {
		fprintf(stderr, "%s Usage:\n", argv[0]);
		fprintf(stderr, " %s <file name>\n", argv[0]);
		fprintf(stderr, "   where:\n  file name is the universe .dat file.\n");
	}

	return(err);
}

