
/*
 * File:      soc.h
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: soc.h,v $ $Revision: 1.3 $ $Author: man $ $Date: 2003/04/26 19:53:30 $" */



#include <stdio.h>
#include <math.h>
#include "t_dice.h"
#include "planet.h"
#include "wx/list.h"

class Population : public pop_desc
{
public:
	Population();
	Population(short p, int m);
	Population(double);
	~Population();

	char *get_pop_str(void);
	void Generate(short p, int m);

	void SetPop(double p);
	void SetPop(short p, int m);

	double GetPop(void) { return(tot_pop); };
	int GetPopMult(void) { return(pop_mult); };

//helpers:
	double		get_pop(void);
	int			get_uwp_pop(void);
	int			get_pop_mult(void);
	void		set_pop(double);
	void		set_uwp_pop(int);
	void		set_pop_mult(void);
	double		gen_pop(int, int);

private:
	double		tot_pop;
	int			pop_mult;

	Dice		*dice;
};

// =========================================================================
typedef enum CITY_TYPE {
	CT_PRIMARY=0,
	CT_SECONDARY,
	CT_TERTARY,
	CT_ORBIT
};

class SubCity;
class CityData;
class BaseCity : public wxObject
{
friend class CityData;
friend class SubCity;
public:
	BaseCity(char prt, int pp);
	~BaseCity();

	void Generate(char prt, int pp);

	virtual CITY_TYPE GetCityType(void)=0;
	virtual char *GetCityFormat(char *buff)=0;

	char *GetCityClass(CITY_TYPE ct) { return(city_type[ct]); };
//	virtual double GetPop(void)=0;

	char GetPort(void) { return(port->get_port()); };

private:
//	char		port;
	port_desc	*port;

	static char *city_type[4];
	static char	port_table[10][10];

	Dice		*dice;

	char *GetPortQualityStr(void);
};

class CityData : public BaseCity
{
public:
	CityData(char prt, int pp, int p_mult, CITY_TYPE t);
	~CityData();

	void Generate(char prt, int pp, int p_mult);

	CITY_TYPE GetCityType(void) { return(type); };
	double GetPop(void) { return(pop->GetPop()); };
	char *GetCityFormat(char *buff);

	void AdjPop(double val);
#if 0
	void		PrintCity(FILE *);
	void		set_pop(double);
	void		gen_pop(int, int, int);
	double		get_pop(void);
//	void		flesh_out_city(int pop, int prt, int atm, int tech, int p_flag);
	void		set_port(char);
	char		get_port(void);
	void		orb_city(char, int, int);
	void		orb_city(char, double);
	void		adj_pop(double);
	int			get_class(void);
#endif

private:
	Population	*pop;
//	int			size;				// very large.....
	CITY_TYPE	type;
//	char		name[33];
//
};

class SubCity : public BaseCity
{
public:
	SubCity(char port, int p, int c);
	~SubCity() {};

//	int			PrintCity(FILE *,int);

	CITY_TYPE GetCityType(void) { return(CT_TERTARY); };
	int IsOrbital(void) { return(0); };
	char *GetCityFormat(char *buff);

	double GetApproxPop(void) { return(count * 5 * pow(10, pop)); };

	int GetCount(void) { return(count); };
	int GetPop(void) { return(pop); };
private:
	int			pop;					// uwp(w/ pop_mult == 5)
	int			count;					//
};

// -------------------------------------------------------------------------
class CityList : public wxList
{
public:
	CityList() : wxList() {};
	~CityList();

	BaseCity *GetCity(int ndx);
	void Clear();
};

// =========================================================================
struct	_CUST {
		char    *desc;				// actual custom
		int		tab_num;			// which table
		int		max_num;			// entry on table
		int		mask;				// display control bit mask:
/*										bit     meaning(if T)
										 7       display a group1
										 6       display a group2
										 5       (small msg here)
										 4       display a group1
										 3       display a group2
										 2       (main msg here)
										 1       display a group1
										 0       display a group2
                                        */
};

class CustomData : public wxObject
{
public:
	CustomData();
	~CustomData();

	void Generate(void);
//	void PrintCustom(FILE *);

	char *GetCustom(char *buff);

private:
//	int			local;              /* first table (8a) (1D6) */
//	int			detail;             /* second table (8b-g) */
	int			detail;				/* ndx to struct */
	int			group;              /* third table (8h) */
	int			o_group;            /* third table (8h) */

	int GetGroup(void);
	void FormatOut(char *buff, char *msg, int count);

	static char		*group_[20];
	static int		grp_map[37];
	static struct	_CUST customs[170];

	Dice		*dice;
};

class CustomList : public wxList
{
public:
	CustomList() : wxList() {};
	~CustomList();

	void Clear(void);
	CustomData *GetCustom(int ndx);
};

// =========================================================================
class Religion
{
public:
	Religion(int auto_flag, int pop, int tech);
	~Religion();

	void Generate(int auto_flag, int pop, int tech);
//	void PrintShortRel(FILE *);
//	void PrintReligion(FILE *);

private:
	int			god_view;
	int			spiritual_aim;
	int			devotion;
	int			organization;
	int			liturgical;
	int			fervor;
	int			number;

	Dice		*dice;
};


/*                       
class Pop : public population
{
public:
	Pop();
	~Pop();

	

};
*/

// =========================================================================
class Govt : public govt_desc
{
public:
	Govt(short govt,int wld_flg=FALSE);
	~Govt();

	void Generate(void);
	int GetTrueGovt(void);

//	void PrintGovt(FILE *);

	int GetDivision(void) { return(division); };
	char *GetAuthStr(int ndx) { return(auth_str[auth[ndx].authority]); };
	char *GetOrgStr(int ndx) { return(org_str[auth[ndx].organization]); };

private:
	int			wilds;
	int			division;

	struct AUTH
		{
		int authority;
		int organization;
		} auth[3];

	static int wilds_conv_table[13];
	static char *govt_str[16];
	static char *wgovt_str[13];
	static char *org_str[4];
	static char *auth_str[7];

	Dice	*dice;
};

// =========================================================================
#define MAX_TECH	14
class Tech : public tech_desc
{
public:
	Tech(short t, char port, int pop, int ext_glob, int ext_int,
			int agg_att, int agg_act, int atm, int hyd);
	~Tech();

	void Generate(char port, int pop, int ext_glob, int ext_int,
			int agg_att, int agg_act, int atm, int hyd);

//	void	PrintTech(FILE *);
	
	char *GetDesc(int ndx) { return(tech_str[ndx]); };
	tech_desc *GetTech(int ndx) { return(tech.dets[ndx]); };

private:
	union
		{
		struct t_detail
			{
			tech_desc *high_common;
			tech_desc *low_common;
			tech_desc *energy;
			tech_desc *computer;
			tech_desc *commo;
			tech_desc *medical;
			tech_desc *environ;
			tech_desc *land_tran;
			tech_desc *water_tran;
			tech_desc *air_tran;
			tech_desc *space_tran;
			tech_desc *pers_milt;
			tech_desc *hvy_milt;
			tech_desc *novelty;
			} dtech;
		tech_desc *dets[MAX_TECH];
		} tech;

	static char *tech_str[MAX_TECH];

	tech_desc *NewTech(int lo, int hi, short val);
	int		gen_mod(void);

	Dice	*dice;
};

// =========================================================================
#define MAX_LAW		5
class Law : public law_desc
{
public:
	Law(short law, int pop, int ext);
	~Law();        

	void Generate(int pop, int ext);

//	void PrintLaw(FILE *);

	char *GetDesc(int ndx) { return(law_str[ndx]); };
	law_desc *GetLaw(int ndx) { return(profile.dets[ndx]); };
	char *GetUniformityStr(void) { return(unif_str[uniformity]); };

private:
	union
		{
		struct detail
			{
			law_desc *weapons;
			law_desc *trade;
			law_desc *criminal;
			law_desc *civil;
			law_desc *personal;
			};
		law_desc *dets[MAX_LAW];
		} profile;

	int uniformity;

	static char	*unif_str[3];
	static char *law_str[MAX_LAW];

	Dice		*dice;
};

		



// =========================================================================
class SocialData : public wxObject
{
public:
//	void SocialData(planet *p, int wd=0);
	SocialData(double p, int g, int l,
		int t, char pt, int atm, int hyd, int wd=0);
	SocialData(int p, int p_ndx, int g, int l,
		int t, char pt, int atm, int hyd, int wd=0);
	~SocialData();

//	void Generate(planet *p, int wd=0);
	void Generate(int p, int p_ndx, int g, int l,
		int t, char pt, int atm, int hyd, int wd=0);

//	void		PrintSoc(FILE *);
//	int			print_city(FILE *, int);
//	int			print_customs(FILE *);
//	void		print_outlook(FILE *);

	Population *GetTotPop(void) { return(tot_pop); };
	Govt *GetGovt(void) { return(govt); };
	Law *GetLaw(void) { return(law); };
	Tech *GetTech(void) { return(tech); };
	Religion *GetReligion(void) { return(religion); };
	CustomData *GetCustom(int ndx) { return(cust_list->GetCustom(ndx)); };
	BaseCity *GetCity(int ndx) { return(city_list->GetCity(ndx)); };

	double GetRuralPop(void) { return(rural_pop); };

	char *GetProgAttStr(void) { return(outlook_str[0][prog_att]); };
	char *GetProgActStr(void) { return(outlook_str[1][prog_act]); };
	char *GetAggAttStr(void) { return(outlook_str[2][agg_att]); };
	char *GetAggActStr(void) { return(outlook_str[3][agg_act]); };
	char *GetExtGlobStr(void) { return(outlook_str[4][ext_glob]); };
	char *GetExtIntStr(void) { return(outlook_str[5][ext_int]); };

private:
	int			prog_att;
	int			prog_act;
	int			agg_att;
	int			agg_act;
	int			ext_glob;
	int			ext_int;
	
	CustomList	*cust_list;
	CityList	*city_list;

//	int			prim_size;		// uwp size of primary city

	double		rural_pop;

	Population	*tot_pop;
	Govt		*govt;
	Law			*law;
	Tech		*tech;
	Religion	*religion;

	void SubInit(int g, int l, int t, char pt, int atm, int hyd, int wd=0);

	void GenOutlook(int p, int g, int l);
	void GenCustoms(void);
	void GenCities(char pt, int atm);
	void AddOrbital(char pt, int t, int prim_size);

	void AddSubCity(char port, int u_pop, int mult);

	int CheckOrbital(char pt, int tech);

//	int check_orbital(int, char, int, char);
//	int gen_city(char, int, int);
//	void add_orbital(char,int);

	static char	*city_class[4];
	static char *outlook_str[6][4];

	Dice		*dice;
};

class SocList : public wxList
{
public:
	SocList();
	~SocList();
	
	SocialData *GetSoc(int ndx);
	void Clear(void);
	
	double GetPop(void);
	void Generate(planet *p, int wd=0);
//	void Generate(int p, int p_ndx, int g, int l, int t, char pt, 
//					int atm, int hyd, int wd=0);

private:
	Dice		*dice;

};

