
/*
 * File:      sizeinfo.h
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: sizeinfo.h,v $ $Revision: 1.2 $ $Author: man $ $Date: 1999/04/06 04:25:07 $" */



//							BaseSize
//								|
//						+-------+-------+
//						|				|
//                  BeltSize		GenSize
//										|
//                              +-------+-------+
//                              |               |
//                          GGSize          PlanetSize
//												|
//										+-------+-------+
//										|				|
//									SatSize			WorldSize

#include <stdio.h>
#include "t_dice.h"
#include "orbit.h"

#ifndef SIZEINFO_H
#define SIZEINFO_H

#define W_UNDEF		-1
#define W_WORLD		0
#define W_SAT		1
#define W_BELT		2
#define W_RING		3
#define W_GG		4

class BaseSize
{
public:
	BaseSize();
	~BaseSize();
	BaseSize(int, int, int, float);
	void PrintOrbit(FILE *);
	int get_sndx(void);
	float get_eccen(void);
// calc fcn:
	void calc_period(float);
protected:
	int				type;		// -1-undef,0=world,1=sat,2=belt,3=ring,4=gg
//	int				orbit;		// *10 for planets as is for sats.
	Orbit			*orbit;	// it's orbit (orbit = -1 for Primary)
//	int				sndx;		// which star we orbit
};

class BeltSize : public BaseSize                                              
{
public:
	BeltSize(int, int, int, float);
// helpers
	int get_c_zone(void);
// formating fcn:
	void PrintBeltShort(FILE *);
	void PrintBelt(FILE *);
	char *FormatD(int, char *);
// random:
	void gen_stats(int);
protected:
	float			p_diameter;				// all random
	float			m_diameter;
	int				n_zone;
	int				m_zone;
	int				c_zone;
	float			width;
// random gen stuff
	void belt_pred_diam(void);
	void belt_max_diam(void);
	void belt_zones(int hab_zone);
	void belt_width(void);
	Dice	dice2;
private:
	static int zone_table[3][3][11];
};
     
class GenSize : public BaseSize
{
public:
	void set_gen(int);
// sets mass, grav, and orbital period
	void			fill_details(float);
	void			PrintGen(FILE *);
	

// random gen stuff:
	void gen_diameter(void);
	Dice	dice2;
protected:
	int				uwp_size;				// user
	long		 	diameter;				// user/random (in Km)
	float			density;                // random
	float			mass;					// calc
	float			gravity;				// calc
//	float			orb_period;				// calc; primary for sats
//	float			eccen;					// random; user for sats
};

class PlanetSize : public GenSize
{
public:
	void gen_planet(int, int, int, float, float);
	float 			get_au_orb(void);
	void			PrintPlanet(FILE *);
	char			*format_rot_period(char *);
	char			*format_a_period(char*, float);
// helpers:
	int get_core(void);
	int get_stress(void);
	float get_tilt(void);
	float get_rot_period(void);
	void set_rot_period(float);
	void sat_details(float, int);
// random gen stuff:
	void planet_core(int size, int atmos, int outer_zone_flag);
	void planet_rot(float pmass);
	float special_rot(float);
	void gen_tilt(void);
	void gen_stress(float);
protected:
	char		    core;					// random (0=Heavy,1=....)
	float			rot_period;	            // random
	float			tilt;					// random
	int				stress;					// random
private:
	static char		*cores[4];
};

class GGSize : public GenSize
{
public:
	GGSize(int, int, int, float, int, int);
	void PrintGG(FILE *);
//	int set_gg(int, int);
//  random gen stuff:
	void gg_size(int large_flag);
	void gg_density(void);
protected:
	int				large;		// user (flag)
	int				num_sats;	// user (ever used?)
};

class WorldSize : public PlanetSize
{
public:
	WorldSize(int, int, int, float, int, int);
	void PrintWSize(FILE *);
	int get_num_sats(void);

protected:
	int				num_sats;	// user
};

class SatSize : public PlanetSize
{
public: 
	SatSize(int,int,int,float,int);
	void PrintSSize(FILE *);
	void sat_details(int, float, int);
	float get_sat_period(void);
	float get_eff_period(void);
protected:
	float			prime_mass;				// user
	float			sat_period;				// random (rot)
	float			km_orbit;				// calc
	int				sat_orbit;				// user
};

#endif
