
/*
 * File:      size.h 
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: size.h,v $ $Revision: 1.2 $ $Author: man $ $Date: 1999/04/06 04:25:07 $" */

#ifndef SIZE_H
#define SIZE_H


#include "d_star.h"
#include "uwp.h"
#include "t_dice.h"

typedef enum SIZE_TYPES {
	ST_PARENT=0,
	ST_GG,
	ST_BELT,
	ST_WORLD,
	ST_SAT
};

typedef enum WORLD_CORE {
	WC_HEAVY=0,
	WC_MOLTEN,
	WC_ROCKY,
	WC_ICY
};


// ======================================================================
class OrbitInfo
{
public:
	OrbitInfo(float orb, float p_mass);
	~OrbitInfo() { delete dice; };

	float GetOrbit(void) { return(orbit); };
	float GetPeriod(void) { return(period); };
	float GetEccen(void) { return(eccen); };

	void GenerateEccen(void);
	float GetAUOrbit(void);
	float ConvToAUOrbit(float o);

	char *FormatPeriod(char *buff);
private:
	float		orbit;			// orbit # (not AU nor diameter)
	float		period;
	float		eccen;

	static float DistTable[22];

	Dice		*dice;

	void CalcPeriod(float p_mass);
};

// ======================================================================
class StarInfo : public DetailStar
{
public:
	StarInfo(int t, int c, int s, float orb, float p_mass);
	~StarInfo();

	OrbitInfo *orb;

	char *GetFormatedOrbit(char *buff);

	float GetAUOrbit(void) { return(orb->GetAUOrbit()); };
	float ConvOrbToAU(float o) { return(orb->ConvToAUOrbit(o)); };
private:

};

// ----------------------------------------------------------------------
class BaseSize : public size_desc
{
friend class ParentSize;
friend class BeltSize;
friend class SimpleSize;
friend class GGSize;
friend class WorldSize;
friend class SatSize;
public:
	BaseSize(short s, float orb, float p_mass, int n);
//	BaseSize(char c, float orb, float p_mass, int n);
	~BaseSize() {};

	float GetMass(void) { return(mass); };
	int GetNumSatillites(void) { return(num_sat); };

	virtual SIZE_TYPES GetType(void)=0;
	virtual short GetUWPSize(void)=0;

	OrbitInfo *orb;

private:
	float		mass;
	int			num_sat;

	Dice		*dice;

	void Init(float orb, float p_mass, int n);
};

class ParentSize : public BaseSize
{
public:
	ParentSize(short s, float orb, float p_mass, float e, float m, int u,
					int n);
//	ParentSize(char c, float orb, float p_mass, float e, float m, int u,
//					int n);
	~ParentSize() {};

	SIZE_TYPES GetType(void) { return(ST_PARENT); };
	short GetUWPSize(void) { return(uwp_size); };

private:
	short		uwp_size;

	void Init(float m, int u);
};

// ----------------------------------------------------------------------
class BeltSize : public BaseSize
{
public:
	BeltSize(int zone_flag, float orb, float p_mass);
	~BeltSize() {};

	SIZE_TYPES GetType(void) { return(ST_BELT); };
	short GetUWPSize(void) { return(0); };

	float GetPredom(void) { return(p_diameter); };
	float GetMax(void) { return(m_diameter); };
	int GetM(void) { return(m_zone); };
	int GetN(void) { return(n_zone); };
	int GetC(void) { return(c_zone); };
	float GetWidth(void) { return(width); };

	void Generate(int zone_flag);

	char *FormatD(int which, char *buff);

private:
	float			p_diameter;				// all random
	float			m_diameter;
	int				n_zone;
	int				m_zone;
	int				c_zone;
	float			width;

	static int zone_table[3][3][11];
};

// ----------------------------------------------------------------------
class SimpleSize : public BaseSize
{
friend class GGSize;
friend class WorldSize;
friend class SatSize;
public:
	SimpleSize(short s, float orb, float p_mass, int n) :
			BaseSize(s, orb, p_mass, n) {};
//	SimpleSize(char c, float orb, float p_mass, int n) :
//			BaseSize(c, orb, p_mass, n) {};
	~SimpleSize() {};

	float GetDensity(void) { return(density); };

private:
	float density;

};

class GGSize : public SimpleSize
{
public:
	GGSize(short s, float orb, float p_mass, int n);
//	GGSize(char c, float orb, float p_mass, int n);
	~GGSize() {};

	SIZE_TYPES GetType(void) { return(ST_GG); };

	short GetUWPSize(void) { return(uwp_size); };

	void Generate(void);

private:
	short		uwp_size;
};

// ----------------------------------------------------------------------
class WorldSize : public SimpleSize
{
friend class SatSize;
public:
	WorldSize(short s, float orb, float p_mass, int pre_stress, 
					int atmos, int n, int zone_flag);
//	WorldSize(char c, float orb, float p_mass, int pre_stress, 
//					int atmos, int n, int zone_flag);
	~WorldSize() {};
	
	SIZE_TYPES GetType(void) { return(ST_WORLD); };
	short GetUWPSize(void) { return(get_t_hex_val()); };

	void Generate(float p_mass, int pre_stess, int atmos, int zone_flag);

	long GetDiameter(void) { return(diameter); };
	float GetGravity(void) { return(gravity); };
	WORLD_CORE GetCoreVal(void) { return(core); };
	char *GetCore(void) { return(cores[core]); };
	float GetRotPeriod(void) { return(rot_period); };
	float GetTilt(void) { return(tilt); };
	int GetStress(void) { return(stress); };

	char *FormatRotPeriod(char *buff);

	void SetRotPeriod(float rot) { rot_period = rot; };

private:
	long		diameter;
	float		gravity;
	WORLD_CORE	core;
	float		rot_period;
	float		tilt;
	int			stress;

	static char *cores[4];

	void CalcGravity(void);
	float SpecialRot(float rot);
	char *PeriodFormat(char *buff, float per);
};

class SatSize : public WorldSize
{
public:
	SatSize(short s, float orb, float p_mass, int pre_stress, 
				int atmos, int n, int zone_flag, int par_size, float par_mass);
//	SatSize(char c, float orb, float p_mass, int pre_stress, 
//					int atmos, int n, int zone_flag, int p_size);
	~SatSize() {};
	
	SIZE_TYPES GetType(void) { return(ST_SAT); };

	void Generate(float p_mass);

	float GetEffPeriod(void);
	char *FormatEffPeriod(char *buff);
	char *FormatSatPeriod(char *buff);

	float GetSatPeriod(void) { return(sat_period); };
	float GetKmOrbit(void) { return(km_orbit); };
	int GetSatOrbit(void) { return(sat_orbit); };

	void SetSatPeriod(float rot) { rot_period = rot; };
private:
	float 		sat_period;
	float 		km_orbit;
	int			sat_orbit;

	void Init(int sorb, int par_size);
};

// ----------------------------------------------------------------------

#endif
