
/*
 * File:      hydro.h
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: hydro.h,v $ $Revision: 1.2 $ $Author: man $ $Date: 1999/04/06 04:25:07 $" */



#ifndef HYDRO_H
#define HYDRO_H

#define NAT_RES_MASK	0xf800
#define PRO_RES_MASK	0x0700
#define MAN_RES_MASK	0x00f0
#define INF_RES_MASK	0x000f

#include "uwp.h"
#include "t_dice.h"
#include "size.h"

class Resources
{
public:
	Resources(WORLD_CORE core, uwp *u, int life);
	~Resources() { delete dice; };  
//	void PrintResources(FILE *);
	void Generate(WORLD_CORE core, uwp *u, int life);

	char *GetNatResStr(char *buff);
	char *GetProResStr(char *buff);
	char *GetManResStr(char *buff);
	char *GetInfResStr(char *buff);

private:
	unsigned short	resources;				// bit mask

	static char *res_str1[4];
	static char *res_str2[16];

	char *GetResStr(char *buff, int start, int end, unsigned short mask);
	Dice			*dice;
};

class Hydro : public hydro_desc
{
public:
	Hydro(uwp *u, int nat_life, WORLD_CORE core, int stress, int atm_comp);
	~Hydro();

	void Generate(uwp *u, int nat_life, WORLD_CORE core, int stress, 
						int atm_comp);

//	void PrintHydro(FILE *);

	void CalcTerraDM(int,int,int,int,int);
// random gen stuff:
	void GenComp(int atm, int atm_comp);
	void GenHydPer(void);
	void GenPlates(int, int);
	void GenCont(void);
	void GenVolc(int);
	void GenTerra(int,int);

	int GetPerc(void) { return(percentage); };
	int GetComp(void) { return(comp); };
	char *GetCompStr(void) { return(hydro_str[comp]); };
	int GetPlates(void) { return(tect_plates); };
	int GetHydDM(void) { return(hyd_dm); };
	int GetTerDM(void) { return(ter_dm); };
	int GetHydTer(void) { return(hyd_ter); };
	int GetTerTer(void) { return(ter_ter); };
	int GetWeatherControl(void) { return(weather_control); };
	int GetMajorCont(void) { return(major_cont); };
	int GetMinorCont(void) { return(minor_cont); };
	int GetIslands(void) { return(islands); };
	int GetArch(void) { return(arch); };
	int GetVolc(void) { return(volc); };

private:
	int				percentage;				// semi-random
	int				comp;					// semi-random
	int				tect_plates;			// random
	int				hyd_dm;					// calc
	int				ter_dm;					// calc
	int				hyd_ter;				// random
	int				ter_ter;				// random
	int				weather_control;		// random
	int				major_cont;				// random
	int				minor_cont;				// random
	int				islands;				// random
	int				arch;					// random
	int				volc;					// random

	static char *hydro_str[3];
	static int conts[4][15];
	static int oceans[3][15];

	Dice			*dice;
};

#endif
 
