
/*
 * File:      hydro.cpp
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: hydro.cpp,v $ $Revision: 1.2 $ $Author: man $ $Date: 1999/04/06 04:25:07 $" */

#include <math.h>
#include <string.h>
#include <ctype.h>
#include "hydro.h"
#include "str_util.h"

Hydro::Hydro(uwp *u, int nat_life, WORLD_CORE core, int stress, int atm_comp) :
	hydro_desc(u->get_hydro_val())
{
	dice = new Dice(6, 2, 0);
	Generate(u, nat_life, core, stress, atm_comp);
}

Hydro::~Hydro()
{
	delete dice;
}

void
Hydro::Generate(uwp *u, int nat_life, WORLD_CORE core, 
		int stress, int atm_comp)
{
	CalcTerraDM(u->get_size_val(), get_t_hex_val(), u->get_pop_val(), 
		u->get_tech_val(), nat_life);
	GenComp(get_t_hex_val(), atm_comp);
	GenHydPer();
	GenPlates(core, u->get_size_val());
	GenCont();
 	GenVolc(stress);
	GenTerra(u->get_pop_val(), u->get_tech_val());
}

char *Hydro::hydro_str[3] = {
"Liquid Water",
"Tainted Liquid Water",
"Atmosphere Related Chemical Mix"
};

#if 0
void Hydro::PrintHydro(FILE *stdlog)
{
	fprintf(stdlog, "  Hydrographic Percentage: %d%%\n",percentage);
	fprintf(stdlog, " Hydrographic Composition: %s\n", hydro_str[comp]);
	fprintf(stdlog, "Number of Tectonic Plates: %d\n",tect_plates);
	fprintf(stdlog, "       Number of Volcanos: %d\n",volc);
	if(hydro < 50)
		{
		fprintf(stdlog, "    # of Major Continents: %d\n",major_cont);
		fprintf(stdlog, "    # of Minor Continents: %d\n",minor_cont);
		fprintf(stdlog, "       # of Major Islands: %d\n",islands);
		fprintf(stdlog, "       # of Archipelagoes: %d\n",arch);
		}
    else
		{
		fprintf(stdlog, "        # of Major Oceans: %d\n",major_cont);
		fprintf(stdlog, "        # of Minor Oceans: %d\n",minor_cont);
		fprintf(stdlog, "          # of Small Seas: %d\n",islands);
		fprintf(stdlog, "     # of Scattered Lakes: %d\n",arch);
		}
	fprintf(stdlog, " Hydrosphere Terraforming: ");
	if(hyd_ter) fprintf(stdlog, "Y");
	else fprintf(stdlog, "N");
	fprintf(stdlog, " (%d)\n", hyd_dm);		
	fprintf(stdlog, "     Terrian Terraforming: ");
	if(ter_ter) fprintf(stdlog, "Y");
	else fprintf(stdlog, "N");
	fprintf(stdlog, " (%d)\n", ter_dm);		
	fprintf(stdlog, "          Weather Control: ");
	if(weather_control) fprintf(stdlog, "Y");
	else fprintf(stdlog, "N");

}
#endif

void Hydro::CalcTerraDM(int size,int atm,int pop,int tech,int life)
{
	hyd_dm = ter_dm = 0;		// default
	
	if(size)
		{
		if(size < 3)
			{
			hyd_dm += 2;
			ter_dm += 4;
			}
		else if(size < 5)
			{
			hyd_dm += 1;
			ter_dm += 3;
			}
		else if(size < 7)
			{
			ter_dm += 2;
			}
		else if(size < 9)
			{
			hyd_dm -= 1;
			ter_dm += 1;
			}
		else
			{
			hyd_dm -= 2;
			}
		}

	if(atm == 0)
		{
		hyd_dm += 4;
		ter_dm += 4;
		}

	if(get_t_hex_val() < 1)
		ter_dm++;
	else if(get_t_hex_val() < 5)
		hyd_dm++;
	else if(get_t_hex_val() < 10)
		hyd_dm++;

	if(pop < 5)
		{
		hyd_dm -= 2;
		ter_dm -= 2;
		}
	else if(pop > 8)
		{
		hyd_dm += 2;
		ter_dm += 2;
		}

	if(tech < 5)
		{
		hyd_dm -= 10;
		ter_dm -= 10;
		}
	else if(tech > 9)
		{
		hyd_dm += 1;
		ter_dm += 1;
		}
	else if(tech < 12)
		{
		hyd_dm += 2;
		ter_dm += 2;
		}
	else
		{
		hyd_dm += 3;
		ter_dm += 3;
		}

	if(!life)
		{
		hyd_dm += 3;
		ter_dm += 3;
		}

}	

// misc random stuff:
void Hydro::GenHydPer(void)
{
	percentage = (get_t_hex_val() * 10) + dice->Roll(10, 1) - 6;
	if(percentage < 0) percentage = 0;
	if(percentage > 100) percentage = 100;
}

void Hydro::GenPlates(int core, int size)
{
int i;

	if(core > 1)
		tect_plates = 1;
	i = size + get_t_hex_val() - dice->Roll(6,2);
	if(i < 1)
		tect_plates = 1;
	else
		tect_plates = i;
}

void Hydro::GenComp(int atm, int atm_comp)
{
	comp = 0;
	if((atm == 2) || (atm == 4) || (atm == 7) || (atm == 9))
		if(dice->Roll(6,1) < 4)
			comp = 1;
	else if(atm == 10)
		{
		if(dice->Roll(6,2) < 10)
			comp = 2;
		else 
			comp = 1;
		}
	else if(atm == 11)
		comp = 2;
	else if(atm_comp == 20)
		{
		if(get_t_hex_val())
			comp = 1;
		else 
			comp = 2;
		}
	else if(atm_comp > 18)
		comp = 2;
}

// WARNING!!!!!!!!!!!
// this is some pretty confusing code
int Hydro::conts[4][15] =
     {{  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  1 },
      {  1,  1,  1,  0,  0,  0,  0,  0,  0, -1, -1, -1, -2, -3, -4 },
      {  1,  2,  3,  1,  2,  3,  1,  2,  3,  1,  2,  3,  1,  1,  1 },
      { -1, -2, -3, -1, -2, -3, -1, -2, -3,  0,  0,  0, -1, -2, -3 }};
int Hydro::oceans[3][15] =
     {{ -4, -4, -3, -3, -2, -2, -1, -1, -1,  0,  0,  0,  0,  0,  0 },
      {  1,  1,  1,  1,  1,  2,  1,  2,  3,  1,  2,  3,  1,  2,  3 },
      { -3, -2, -1, -1, -1, -2, -1, -2, -3, -1, -2, -3, -1, -2, -3 }};


void Hydro::GenCont(void)
{
int i;

	major_cont = minor_cont = islands = arch = 0;
	if((percentage < 1) || (percentage > 99))
		return;

    i = get_t_hex_val() * 3 + dice->Roll(6,1);
    if(percentage > 49)
		{
        if(i < 35) arch = dice->Roll(6,2);
        if(i == 31)
			{
            islands = dice->Roll(6,1) - 3;
			}
        else if(i < 31)
			{
            i -= 16;
            major_cont = dice->Roll(6,conts[0][i]) + conts[1][i];
            minor_cont = dice->Roll(6,conts[2][i]) + conts[3][i];
            if(i == 14) islands = dice->Roll(6,2);
            else islands = dice->Roll(6,3) - 3;
			}
		}
    else
       {
        if(i > 2) arch = dice->Roll(6,2);
        if(i == 6)
           {
            islands = dice->Roll(6,1) - 3;
           }
        else if(i > 6)
           {
            i -= 7;
            if(i > 11) major_cont = 1;
            else major_cont = dice->Roll(6,1) + oceans[0][i];
            minor_cont = dice->Roll(6,oceans[1][i]) + oceans[2][i];
            if(i == 0) islands = dice->Roll(6,2) - 3;
            else islands = dice->Roll(6,3) - 3;
           }
       }
	if(islands < 0)
		islands = 0;
	if(minor_cont < 0)
		minor_cont = 0;
	if(major_cont < 0)
		major_cont = 0;
}

void Hydro::GenVolc(int stress)
{
int i,j,k=0,l;

	if(tect_plates < 2)
		j = dice->Roll(6,1);
	else
		j = tect_plates;
	
	for(i = 0;i < j;i++)
		{
		l = stress + dice->Roll(6,2) - 7;
		if(l > 0)
			k += l;
		}

	volc = k;
}

void Hydro::GenTerra(int pop,int tech)
{
int i;

	if(dice->Roll(6,2) <= hyd_dm)
		hyd_ter = 1;
	else
		hyd_ter = 0;

	if(dice->Roll(6,2) <= ter_dm)
		ter_ter = 1;
	else
		ter_ter = 0;
	
	weather_control = 0;	// default
	if(tech > 8)
		{
		i = dice->Roll(6,2);
		if((i < pop) && (i < tech))
			weather_control = 1;
		else
			weather_control = 0;
		}
}

// =========================================================================
Resources::Resources(WORLD_CORE core, uwp *u, int life)
{
	dice = new Dice(6, 2, 0);
	Generate(core, u, life);
}

char *Resources::res_str1[4] = {
	"        Natural Resources: ",
	"      Processed Resources: ",
	"    Manufactured Products: ",
	"     Information Products: ",
	};
char *Resources::res_str2[16] = {
	"Agricultural",
	"Ores",
	"Radioactives",
	"Crystals",
	"Compounds",
	"Agroproducts",
	"Metals",
	"Non-Metals",
	"Parts",
	"Durables",
	"Conmsumables",
	"Weapons",
	"Recordings",
	"Artforms",
	"Software",
	"Documents"
	};

char *
Resources::GetResStr(char *buff, int start, int end, unsigned short mask)
{
int i,l=0;

	for(i = start;i < end;i++)
		{
		if(resources & mask)
			{
			if(l) strcat(buff, ",");
			strcat(buff, res_str2[i]);
			l++;
			}
		mask >>= 1;
		}
	return(buff);
}

char *
Resources::GetNatResStr(char *buff)
{
	buff[0] = 0;
	if(resources & NAT_RES_MASK)
		GetResStr(buff, 0, 5, 0x8000);

	return(buff);
}

char *
Resources::GetProResStr(char *buff)
{
	buff[0] = 0;
	if(resources & PRO_RES_MASK)
		GetResStr(buff, 5, 8, 0x0400);

	return(buff);
}

char *
Resources::GetManResStr(char *buff)
{
	buff[0] = 0;
	if(resources & MAN_RES_MASK)
		GetResStr(buff, 8, 12, 0x0080);

	return(buff);
}

char *
Resources::GetInfResStr(char *buff)
{
	buff[0] = 0;
	if(resources & INF_RES_MASK)
		GetResStr(buff, 12, 16, 0x0008);

	return(buff);
}

#if 0
void Resources::PrintResources(FILE *fpx)
{
int i,k=0,l;
unsigned short j;

	if(resources & NAT_RES_MASK)
		{
		j = 0x8000;
		l = 0;
		fprintf(fpx, res_str1[0]);
		for(i = 0;i < 5;i++)
			{
			if(resources & j)
				{
				if(l) fprintf(fpx, ",");
				fprintf(fpx, res_str2[i]);
				l++;
				}
			j >>= 1;
			}
		fprintf(fpx, "\n");
		k++;
		}
	if(resources & PRO_RES_MASK)
		{
		j = 0x0400;
		l = 0;
		fprintf(fpx, res_str1[1]);
		for(i = 5;i < 8;i++)
			{
			if(l) fprintf(fpx, ",");
			if(resources & j)
				{
				fprintf(fpx, res_str2[i]);
				l++;
				}
			j >>= 1;
			}
		fprintf(fpx, "\n");
		k++;
		}
	if(resources & MAN_RES_MASK)
		{
		j = 0x0080;
		l = 0;
		fprintf(fpx, res_str1[2]);
		for(i = 8;i < 12;i++)
			{
			if(l) fprintf(fpx, ",");
			if(resources & j)
				{
				fprintf(fpx, res_str2[i]);
				l++;
				}
			j >>= 1;
			}
		fprintf(fpx, "\n");
		k++;
		}
	if(resources & INF_RES_MASK)
		{
		j = 0x0009;
		l = 0;
		fprintf(fpx, res_str1[3]);
		for(i = 12;i < 16;i++)
			{
			if(l) fprintf(fpx, ",");
			if(resources & j)
				{
				fprintf(fpx, res_str2[i]);
				l++;
				}
			j >>= 1;
			}
		fprintf(fpx, "\n");
		k++;
		}
		
	if(k)
		fprintf(fpx, "\n");
}
#endif

void 
Resources::Generate(WORLD_CORE core, uwp *u, int life)
{
int i;
unsigned short j;
int dm[16];

	for(i = 0;i < 16;i++)
		dm[i] = 0;

	switch(core)
		{
		case WC_HEAVY:
			dm[0] += 1;
			dm[1] += 8;
			dm[2] += 6;
			dm[3] += 7;
			dm[4] += 5;
			dm[6] += 2;
			dm[7] += 1;
			break;
		case WC_MOLTEN:
			dm[0] += 4;
			dm[1] += 7;
			dm[2] += 5;
			dm[3] += 5;
			dm[4] += 6;
			dm[5] += 1;
			break;
		case WC_ROCKY:
			dm[0] += 4;
			dm[1] += 3;
			dm[2] += 3;
			dm[3] += 2;
			dm[4] += 1;
			dm[5] += 1;
			break;
		default:
			dm[0] -= 5;
			dm[4] -= 4;
			dm[6] -= 1;
			dm[7] -= 1;
			break;
		}		
	if((u->get_hydro_val() < 4) || (u->get_hydro_val() > 9))
		{
		dm[0] += 1;
		dm[5] += 2;
		dm[7] += 1;
		}
	else
		{
		dm[0] -= 3;
		dm[1] += 2;
		dm[2] += 1;
		dm[4] += 1;
		dm[6] += 1;
		dm[7] += 1;
		dm[8] += 1;
		dm[9] += 1;
		dm[10] += 1;
		dm[11] += 1;
		}
    if(u->get_pop_val() < 5)
    	{
    	dm[5] += 1;
    	dm[6] -= 1;
    	dm[8] -= 1;
    	dm[9] -= 1;
    	dm[10] -= 1;
    	dm[11] -= 1;
    	dm[15] -= 1;
    	}
    else
		{
    	dm[5] += 2;
    	dm[6] += 1;
    	dm[7] += 1;
    	if(u->get_pop_val() < 9)
    		{
	    	dm[8] += 1;
    		dm[9] += 2;
    		dm[10] += 1;
    		dm[12] += 1;
    		dm[13] += 2;
	    	dm[14] += 1;
    		}

	    else
    		{
	    	dm[8] += 2;
    		dm[9] += 3;
    		dm[10] += 4;
	    	dm[11] += 1;
    		dm[12] += 2;
    		dm[13] += 3;
	    	dm[14] += 4;
    		dm[15] += 1;
	    	}
		}
	if(u->get_govt_val() < 2)
		{
    	dm[8] -= 1;
   		dm[9] -= 1;
   		dm[10] -= 1;
		}
	else if(u->get_govt_val() < 7)
		{
    	dm[8] += 1;
   		dm[9] += 1;
   		dm[10] += 1;
    	dm[11] += 1;
   		dm[12] += 1;
   		dm[13] += 1;
    	dm[14] += 1;
   		dm[15] += 1;
		}
	else if(u->get_govt_val() < 8)
		{
    	dm[8] += 2;
   		dm[9] += 2;
   		dm[10] += 3;
    	dm[11] += 3;
   		dm[12] += 1;
   		dm[13] += 2;
    	dm[14] += 1;
   		dm[15] += 2;
		}
	else
		{
   		dm[10] += 1;
    	dm[11] += 1;
   		dm[12] += 2;
    	dm[14] += 1;
   		dm[15] += 4;
		}
	if(u->get_law_val() > 9)
		{
   		dm[12] += 3;
    	dm[14] += 3;
   		dm[15] += 6;
		}
	else if(u->get_law_val() > 6)
		{
   		dm[12] += 2;
    	dm[14] += 2;
   		dm[15] += 4;
		}
	else if(u->get_law_val() > 2)
		{
   		dm[12] += 1;
    	dm[14] += 1;
   		dm[15] += 2;
		}
	if(u->get_tech_val() < 4)
		{
		dm[0] += 1;
		dm[1] += 1;
		dm[2] += 1;
		dm[3] += 1;
		dm[4] += 1;
		dm[5] += 1;
		dm[6] -= 1;
		dm[12] -= 3;
		dm[13] += 2;
		dm[14] -= 9;
		}
	else if(u->get_tech_val() < 7)
		{
		dm[5] += 2;
		dm[6] += 2;
		dm[7] += 2;
		dm[9] += 1;
		dm[10] += 1;
		dm[11] += 1;
		dm[12] += 1;
		dm[13] += 1;
		dm[15] += 1;
		}
	else if(u->get_tech_val() < 12)
		{
		dm[0] -= 1;
		dm[5] += 1;
		dm[6] += 4;
		dm[7] += 4;
		dm[8] += 2;
		dm[9] += 2;
		dm[10] += 2;
		dm[11] += 1;
		dm[12] += 2;
		dm[13] += 1;
		dm[14] += 1;
		dm[15] += 3;
		}
	else
		{
		dm[0] -= 2;
		dm[1] += 1;
		dm[2] += 1;
		dm[3] += 1;
		dm[4] += 1;
		dm[5] += 1;
		dm[6] += 5;
		dm[7] += 6;
		dm[8] += 4;
		dm[9] += 3;
		dm[10] += 4;
		dm[11] += 2;
		dm[12] += 3;
		dm[13] += 1;
		dm[14] += 4;
		dm[15] += 1;
		}
	if(life)
		{
		dm[0] += 5;
		dm[4] += 1;
		dm[5] += 5;
		dm[7] += 3;
		dm[8] += 1;
		dm[9] += 1;
		dm[10] += 1;
		dm[11] += 1;
		}
	else
		dm[4] -= 1;


	j = 0x8000;
	resources = 0;
	for(i = 1;i < 16;i++)
		{
		if(dice->Roll(6,2) <= dm[i])
			resources |= j;
		j >>= 1;
		}
}

