
/*
 * File:      detail.h 
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 * 
 */

/* rcsid[] = "$RCSfile: detail.h,v $ $Revision: 1.2 $ $Author: man $ $Date: 1999/04/06 04:25:07 $" */




#ifndef DETAIL_H
#define DETAIL_H


#include "syst.h"
#include "size.h"
#include "atmos.h"
#include "hydro.h"
#include "soc.h"

#define DSI_PRIMARY				0
#define DSI_1ST_SECONDARY		1
#define DSI_2ND_SECONDARY		2
#define DSI_1ST_TERTARY			3
#define DSI_2ND_TERTARY			4

// ======================================================================
class Detail
{
public:
	Detail();
	~Detail();

	void Generate(BaseOrbit *bo, int star_type);

	void ClearAll(void);
	void ClearPar(void);
	void ClearDetail(void);


	void AddStar(int ndx, int t, int c, int s, float orb, float p_mass);
	void AddParent(short s, float orb, float p_mass, float e, float m, 
						int u, int n);
	void AddParent(char c, float orb, float p_mass, float e, float m, 
						int u, int n);
	void AddSatDetail(SatOrbit *so, int star_type);
	void AddWorldDetail(WorldOrbit *wo, int star_type);

	StarInfo *GetStar(int ndx) { return(stars[ndx]); };
	ParentSize *GetPar(void) { return(par); };

	BaseSize *GetSize(void) { return(size); };
	Atmos *GetAtmos(void) { return(atmos); };
	Hydro *GetHydro(void) { return(hydro); };
	Resources *GetResources(void) { return(resources); };
	SocialData *GetSocial(int ndx) { return(soc_list->GetSoc(ndx)); };
	SocList *GetSocList(void) { return(soc_list); };

private:
	StarInfo		*stars[MAX_STARS];

	ParentSize		*par;

	BaseSize		*size;
	Atmos			*atmos;
	Hydro			*hydro;
	Resources		*resources;
	SocList			*soc_list;

	int GetPreStress(WorldOrbit *wo);
	void GetLumins(WorldOrbit *wo, float *min, float *mean, float *max);
	void GetMaxOrb(int orb, int sndx, float max[]);
	void GetMinOrb(int orb, int sndx, float min[]);
	int GetStarIndex(WorldOrbit *wo);

	void AddDetail(planet *p, float orbit, float p_mass, int pre_stress,
		int num_sat, int hab_zone, int p_size, float min_l, float mean_l,
		float max_l, int star_type, float par_mass);
};

// ======================================================================
// ======================================================================
// ----------------------------------------------------------------------

#endif
