
/*
 * File:      atmos.h
 * Purpose:   
 * Author:
 * Created:
 * Updated:
 * Copyright: LGPL.
 *            Traveller is a registered trademark of Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: atmos.h,v $ $Revision: 1.2 $ $Author: man $ $Date: 1999/04/06 04:25:07 $" */

#ifndef ATMOS_H
#define ATMOS_H

#include "uwp.h"
#include "t_dice.h"

typedef enum TRUE_ATMOS {
	TA_NONE=0,
	TA_TRACE,
	TA_V_THIN,
	TA_THIN,
	TA_STD,
	TA_DENSE,
	TA_V_DENSE
};

class Temp
{
public:
// atmos lumin @ this orbit, albedo, greenhouse, dist in au, day len
//	Temp(int, float, float, float, float, float);
	Temp() {};
	~Temp() {};

	void CalcTemp(float alb, float grn);

	// helpers
	void SetLumin(int w, float lum) { lumin[w] = lum; };
	float GetLumin(int w) { return(lumin[w]); };
	float GetBaseTemp(int w) { return(base_temp[w]); };
	float GetDayRot(int w) { return(d_rot[w]); };
	float GetNightRot(int w) { return(n_rot[w]); };

	void CalcRot(TRUE_ATMOS tatm, float day_len);

	// string helpers/formaters
	char *GetLuminStr(char *buff);
	char *GetBaseStr(char *buff);
	char *GetMaxDayModStr(char *buff);
	char *GetMaxNightModStr(char *buff);

private:
	float			lumin[3];					// user
	float 			base_temp[3];				// calc
//	float			rot_lum[3];					// calc
	float			d_max[3];				  	// calc
	float			n_max[3];					// calc
	float			d_rot[3];					// calc
	float			n_rot[3];					// calc
};
	
class Atmos : public atmos_desc
{
public:
	Atmos(uwp *u, int zone_flag, float min_l, float mean_l, float max_l, 
		float ecc, float tilt, int star_type, float rot);
	~Atmos();

	void Generate(uwp *u, int zone_flag, float min_l, float mean_l, float max_l,
					float ecc, float tilt, int star_type, float rot);
// calc fcns:
	void CalcGreenhouse(void);
	void CalcAlbedo(int,int);
	void CalcBaseTemp(void);
	void CalcRot(float);
	void CalcNatDM(int size, int star_type);
	void CalcTerDM(int size, int hydro, int pop, int tech);
	void RecalcTemp(float rot);
	float CalcTempAtRow(int,int,int,float);	

// helper fcns:
	// set fcns
	void SetLumin(int w, float l);
	void SetTempMods(int,float, float);
	void AdjAdjAlb(int alb, float new_alb);
	void AdjAdjGrn(int grn, float new_grn);
	// get fcns
	float GetBaseTemp(int w) { return(base_temp->GetBaseTemp(w)); };
	Temp *GetBaseTemp(void) { return(base_temp); };
	Temp *GetTerrTemp(void) { return(terr_temp); };

// random gen stuff
	void GenAtmosComp(void);
	void GenGases(void);
	void GenPressure(void);
	void ExoticGreenhouse(void);
	void CheckNativeLife(void);
	void CheckTer(int);
	void GenAltAlb(void);
	void GenAltGrn(void);
	void PrintAtmos(FILE *);
	void PrintTempW(FILE *, float);
	
	int GetLife(void) { return(native_life); };
	int GetComp(void) { return(comp); };
	int GetGrnDM(void) { return(grn_dm); };
	int GetAlbDM(void) { return(alb_dm); };
	long GetGasMask(void) { return(gas_mask); };
	float GetPressure(void) { return(pressure); };
	float GetAlbedo(void) { return(albedo); };
	float GetGreenhouse(void) { return(greenhouse); };
	float GetAdjAlbedo(void) { return(adj_alb); };
	float GetAdjGreenhouse(void) { return(adj_greenhouse); };
	float GetEccenMod(void) { return(eccen_mod); };
	float GetAxModPlus(void) { return(ax_mod_plus); };
	float GetAxModMinus(void) { return(ax_mod_minus); };
	float GetLatMod(void) { return(lat_mod); };
	int GetNative(void) { return(native_life); };
	int GetAtmT(void) { return(atm_ter); };
	int GetGrnT(void) { return(grn_ter); };
	int GetAlbT(void) { return(alb_ter); };
	int GetNativeDM(void) { return(nat_dm); };
	int GetAtmTDM(void) { return(atm_dm); };
	int GetGrnTDM(void) { return(grn_dm); };
	int GetAlbTDM(void) { return(alb_dm); };



	
	char *GetAtmosCompStr(char *buff);
	char *GetGasStr(char *buff);
	char *GetTrueAtmosStr(void);

private:
//	int		atmos;			// user
	int		comp;			// random
	long	gas_mask;		// random
	float	pressure;		// random
	float	albedo;			// lu
	float	greenhouse;		// lu/random
	float	adj_alb;		// user
	float	adj_greenhouse;	// user
	Temp	*base_temp;		// calc
	Temp	*terr_temp;		// calc
	float	eccen_mod;		// calc
	int		lat_mod;		// lu
	int		comp_mod;		// random
	float	ax_mod_plus;	// calc
	float	ax_mod_minus;	// calc
	int		base_ax_row;	// lu (row where it's 1.00)
	float	day_len;		// calc
	int		nat_dm;			// calc
	int		atm_dm;			// calc
	int		grn_dm;			// calc
	int		alb_dm;			// calc
	int		native_life;	// random
	int		atm_ter;		// random
	int		grn_ter;		// random
	int		alb_ter;		// random

	float	GetAlbedo(int, int, int);
	float	GetGE(int);
	TRUE_ATMOS GetTrueAtmos(void);

	static char 		*atmos_comp[25];
	static char 		*atmos_str[16];
	static char 		*true_atmos_str[7];
	static char			*gases[19];
	static int			alb_table[4][2][11];

	Dice	*dice;
};

#endif
