/*
 * File:      	t_code_conv
 * Purpose:   	convert old t_code.cfg to new format
 * Author:		Mark A. Nordstrand
 * Created:	
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: t_code_conv.c,v $ $Revision: 1.2 $ $Author: man $ $Date: 2002/06/05 04:51:07 $" */


/* quick hack to convert config file 
 *
 * you probably don't need this if you haven't ever edited t_code.cfg.
 *
 * to build (really doesn't deserve a makefile):
 *		cc -ot_code_conv t_code_conv.c
 *
 */

#include "stdio.h"
#include "stdlib.h"

#define BUFFER_SIZE			256

#define ALLEG_FILE		"alleg.dat"
#define BASES_FILE		"bases.dat"
#define SCODES_FILE		"scodes.dat"
#define TCODES_FILE		"tcodes.dat"
#define UCODES_FILE		"ucodes.dat"

#define ALLEG_FLAG		'A'
#define BASES_FLAG		'E'
#define SCODES_FLAG		'S'
#define TCODES_FLAG		'T'
#define UCODES_FLAG		'C'


FILE *
open_file(char *dir, char *name)
{
char buffer[BUFFER_SIZE];

	sprintf(buffer, "%s/%s", dir, name);
	return(fopen(buffer, "a"));
}

int
convert(FILE *in, char *dest_dir)
{
char buffer[BUFFER_SIZE];
FILE *alleg;
FILE *bases;
FILE *scodes;
FILE *tcodes;
FILE *ucodes;

	/* yes, leaving the FILE *'s open is sloppy..... */
	if((alleg = open_file(dest_dir, ALLEG_FILE)) == NULL)
		return(-1);
	if((bases = open_file(dest_dir, BASES_FILE)) == NULL)
		return(-1);
	if((scodes = open_file(dest_dir, SCODES_FILE)) == NULL)
		return(-1);
	if((tcodes = open_file(dest_dir, TCODES_FILE)) == NULL)
		return(-1);
	if((ucodes = open_file(dest_dir, UCODES_FILE)) == NULL)
		return(-1);

	while(fgets(buffer, BUFFER_SIZE, in) > 0) {
		if(('\n' == buffer[0]) || ('#' == buffer[0]))
			continue;

		switch(buffer[0]) {
			case ALLEG_FLAG:
				fprintf(alleg, "%s", &buffer[2]);
				break;
			case BASES_FLAG:
				fprintf(bases, "%s", &buffer[2]);
				break;
			case SCODES_FLAG:
				fprintf(scodes, "%s", &buffer[2]);
				break;
			case TCODES_FLAG:
				fprintf(tcodes, "%s", &buffer[2]);
				break;
			case UCODES_FLAG:
				fprintf(ucodes, "%s", &buffer[2]);
				break;
			default:
				fprintf(stderr,"Warning, cannot figure out what to do with:\n");
				fprintf(stderr, "<%s>\n", buffer);
				break;
		}
	}

	fprintf(alleg, "\n");
	fprintf(bases, "\n");
	fprintf(scodes, "\n");
	fprintf(tcodes, "\n");
	fprintf(ucodes, "\n");

	fclose(alleg);
	fclose(bases);
	fclose(scodes);
	fclose(tcodes);
	fclose(ucodes);
	return(0);
}

int
main(int argc, char *argv[])
{
int err=0;
FILE *fp;

	if(argc != 2) {
		if((fp = fopen(argv[1], "r")) == NULL)
			err = 1;
		else {
			fprintf(stdout, 
				"\nThis program attempts to convert the older configuration file to a newer\n");
			fprintf(stdout, 
				"formt.  As such, it makes every attempt to preserve any existing data, and\n");
			fprintf(stdout, 
				"you will probably need to verify the new data files look 'ok'.\n");
			fprintf(stdout, 
				"Also, the format of the standard trade codes has been enhanced, and you should\n");
			fprintf(stdout, 
				"inspect %s/%s.\n", argv[2], SCODES_FILE);
			if(convert(fp, argv[2]) < 0) {
				fprintf(stderr, "\nError in conversion detected!\n");
				err = 2;
			} 

			fclose(fp);
		}
	}
	

	if(err) {
		fprintf(stderr, "Usage:\n");
		fprintf(stderr, "  %s: <old config file> <new config dir>\n",
				argv[0]);
		return(err);
	}

	return(0);
}

