/*
 * File:      	stripstar.c
 * Purpose:   	strip off the stellar data.....
 * Author:		Mark A. Nordstrand
 * Created:	
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: stripstar.c,v $ $Revision: 1.2 $ $Author: man $ $Date: 2002/06/05 04:51:07 $" */


/* real crude way to do this */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "str_util.h"
#include "sect_text.h"


int 
main(int argc, char *argv[])
{
int err=0,x,y;
struct TMP_STRUCT s1;
FILE *fout=NULL;

	if((argc < 2) || (argc > 3))
		err = 1;
	else {
		if(!get_sector(argv[1], &s1)) {
			err = 2;
		} else {
			if(argc < 3)
				fout = stdout;
			else {
				if((fout = fopen(argv[2], "a+")) == NULL)
					err = 5;
			}
			if(fout != NULL) {
				for(x = 0;x < MAX_X;x++) {
					for(y = 0;y < MAX_Y;y++) {
						s1.data[x][y].stars[0] = 0;
					}
				}

				if(!write_sector(fout, &s1))
					err = 6;
			}
		}
	}

	if(err) {
		fprintf(stderr, "Usage:\n%s <input file> [<output file.>]\n", argv[0]);
	}

	return(err);
}

