/*
 * File:      	crappy sector load 
 * Purpose:   
 * Author:		Mark A. Nordstrand
 * Created:	
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: sect_text.c,v $ $Revision: 1.3 $ $Author: man $ $Date: 2002/06/05 04:51:07 $" */

/* utilities to handle (real simple) loading of a sector 
 * from a standard sector file 
 *
 * if you think the regular stuff is bad......
 *   error handling is virtually non-existant....
 *   only thing used from lib is str_util
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "str_util.h"
#include "sect_text.h"

/* given a buffer containing a header line, start and end positions */
static void
get_offsets(char *buff, int *x, int *y)
{
char *ptr;
int _x=0,_y=0;

	ptr = buff;
	while(!isdigit(*ptr))
		ptr++;

	while(isdigit(*ptr)) {
		_x *= 10;
		_x += (*ptr - '0');
		ptr++;
	}
	ptr++;
	while(isdigit(*ptr)) {
		_y *= 10;
		_y += (*ptr - '0');
		ptr++;
	}
	*x = _x-1;
	*y = _y-1;
}

/* given a buffer containing a world line, deterimine the x,y coords */
static void
get_loc(char *buff, int *x, int *y)
{
char lbuff[4];

	lbuff[0] = buff[0];
	lbuff[1] = buff[1];
	lbuff[2] = 0;
	*x = atoi(lbuff) - 1;
	lbuff[0] = buff[2];
	lbuff[1] = buff[3];
	lbuff[2] = 0;
	*y = atoi(lbuff) - 1;
}

/* given a start and end postion (struct OFFSET) copy a string */
static void
get_chunk(char *src, char *dest, struct OFFSET *o)
{
int len;

	len = o->end - o->start + 1;
	strncpy(dest, &src[o->start], len);
	dest[len] = 0;
}

/* even used? */
static void
get_small_chunk(char *src, char *dest, struct OFFSET *o)
{
	dest[0] = src[o->start];
	dest[1] = 0;
}

static void
set_start_end(TMP_STRUCT *s_new)
{
int x,y;
size_t max_len=0,max_len1=16;

	for(x = 0;x < MAX_X;x++) {
		for(y = 0;y < MAX_Y;y++) {
			if(strlen(s_new->data[x][y].name) > max_len)
				max_len = strlen(s_new->data[x][y].name);
			if(strlen(s_new->data[x][y].codes) > max_len1)
				max_len1 = strlen(s_new->data[x][y].codes);
		}
	}

	s_new->layout.name.start = 0;
	s_new->layout.name.end = max_len;
	s_new->layout.hex.start = max_len + 2;
	s_new->layout.hex.end = max_len + 5;
	s_new->layout.uwp.start = max_len + 7;
	s_new->layout.uwp.end = max_len + 15;
	s_new->layout.bases.start = max_len + 17;			/* XXX */
	s_new->layout.bases.end = max_len + 17;
	s_new->layout.codes.start = max_len + 19;
	s_new->layout.codes.end = max_len + max_len1 + 19;
	s_new->layout.zone.start = max_len + max_len1 + 20;	/* XXX */
	s_new->layout.zone.end = max_len + max_len1 + 21;
	s_new->layout.pbg.start = max_len + max_len1 + 23;
	s_new->layout.pbg.end = max_len + max_len1 + 25;
	s_new->layout.alleg.start = max_len + max_len1 + 27;
	s_new->layout.alleg.end = max_len + max_len1 + 28;
	s_new->layout.stars.start = max_len + max_len1 + 30;
	s_new->layout.stars.end = 79;
}

/* load a world */
static int 
get_world(char *buff, TMP_STRUCT *s)
{
int x,y;

	get_loc(&buff[s->layout.hex.start], &x, &y);
	if((x < 0) || (y < 0) || (x >= MAX_X) || (y >= MAX_Y)) {
		fprintf(stderr, "Warning: problem parsing(%d) (%d %d):\n%s", 
				s->layout.hex.start, x, y, buff);
		return(FALSE);
	} else {
		s->data[x][y].present = 1;
		get_chunk(buff, s->data[x][y].name, &s->layout.name);
		get_chunk(buff, s->data[x][y].hex, &s->layout.hex);
		get_chunk(buff, s->data[x][y].uwp, &s->layout.uwp);
		s->data[x][y].bases[0] = buff[s->layout.bases.end];
		s->data[x][y].bases[1] = 0;
		get_chunk(buff, s->data[x][y].codes, &s->layout.codes);
		s->data[x][y].zone[0] = buff[s->layout.zone.end];
		s->data[x][y].zone[1] = 0;
		get_chunk(buff, s->data[x][y].pbg, &s->layout.pbg);
		get_chunk(buff, s->data[x][y].alleg, &s->layout.alleg);
		get_chunk(buff, s->data[x][y].stars, &s->layout.stars);
	}
	return(TRUE);
}

/*****************************************************************************
 ** stuff available externally
 */

/* top level reader */
int 
get_sector(char *fname, struct TMP_STRUCT *s)
{
char buff[BUFF_SIZE];
int header=1,count=0;
FILE *fp;

	if((fp = fopen(fname, "r")) == NULL)
		return(FALSE);

	memset((void *) s, 0, sizeof(struct TMP_STRUCT));
	while((fgets(buff, BUFF_SIZE, fp)) != NULL) {
		if(strncmp(buff, "....+....1", 10) == 0) {
			header = 0;
			continue;
		}
		if(header) {
			if(strstr(buff, "Name") != NULL) {
				get_offsets(buff, &s->layout.name.start, &s->layout.name.end);
			} else if(strstr(buff, "HexNbr") != NULL) {
				get_offsets(buff, &s->layout.hex.start, &s->layout.hex.end);
			} else if(strstr(buff, "UWP") != NULL) {
				get_offsets(buff, &s->layout.uwp.start, &s->layout.uwp.end);
			} else if(strstr(buff, "Bases") != NULL) {
				get_offsets(buff, &s->layout.bases.start, &s->layout.bases.end);
				s->layout.bases.end = s->layout.bases.start;
			} else if(strstr(buff, "Codes") != NULL) {
				get_offsets(buff, &s->layout.codes.start, &s->layout.codes.end);
			} else if(strstr(buff, "Zone") != NULL) {
				get_offsets(buff, &s->layout.zone.start, &s->layout.zone.end);
				s->layout.zone.end = s->layout.zone.start;
			} else if(strstr(buff, "PBG") != NULL) {
				get_offsets(buff, &s->layout.pbg.start, &s->layout.pbg.end);
			} else if(strstr(buff, "Alleg") != NULL) {
				get_offsets(buff, &s->layout.alleg.start, &s->layout.alleg.end);
			} else if(strstr(buff, "Stellar") != NULL) {
				get_offsets(buff, &s->layout.stars.start, &s->layout.stars.end);
			}
		} else {
			if(get_world(buff, s))
				count++;
		}
	}

	fclose(fp);
	return(count);
}

/* write out a sector file */
int 
write_sector(FILE *fp, struct TMP_STRUCT *s)
{
int x,y,count=0;

	set_start_end(s);

	fprintf(fp, "\n 1-%d: Name\n", s->layout.name.end + 1);
	fprintf(fp, "%d-%d: HexNbr\n", 
		s->layout.hex.start + 1, s->layout.hex.end + 1);
	fprintf(fp, "%d-%d: UWP\n", 
		s->layout.uwp.start + 1, s->layout.uwp.end + 1);
	fprintf(fp, "   %d: Bases\n", 
		s->layout.bases.end + 1);
	fprintf(fp, "%d-%d: Codes & Comments\n", 
		s->layout.codes.start + 1, s->layout.codes.end + 1);
	fprintf(fp, "   %d: Zone\n", 
		s->layout.zone.end + 1);
	fprintf(fp, "%d-%d: PBG\n", 
		s->layout.pbg.start + 1, s->layout.pbg.end + 1);
	fprintf(fp, "%d-%d: Allegiance\n", 
		s->layout.alleg.start + 1, s->layout.alleg.end + 1);
	fprintf(fp, "%d-%d: Stellar Data\n", 
		s->layout.stars.start + 1, s->layout.stars.end + 1);

	fprintf(fp, "\n....+....1....+....2....+....3....+....4....+....5....+....6....+....7....+....8\n");

	for(x = 0;x < MAX_X;x++) {
		for(y = 0;y < MAX_Y;y++) {
			if(s->data[x][y].present < 1)
				continue;

			strfixsize(s->data[x][y].name, 
				s->layout.name.end - s->layout.name.start + 1);
			strfixsize(s->data[x][y].hex, 
				s->layout.hex.end - s->layout.hex.start + 1);
			strfixsize(s->data[x][y].uwp, 
				s->layout.uwp.end - s->layout.uwp.start + 1);
			strfixsize(s->data[x][y].codes, 
				s->layout.codes.end - s->layout.codes.start + 1);
			strfixsize(s->data[x][y].pbg, 
				s->layout.pbg.end - s->layout.pbg.start + 1);
			strfixsize(s->data[x][y].alleg, 
				s->layout.alleg.end - s->layout.alleg.start + 1);
			strfixsize(s->data[x][y].stars, 
				s->layout.stars.end - s->layout.stars.start + 1);

			strstrip(s->data[x][y].stars, 1);
			strstrip(s->data[x][y].stars, 0);
			/* stars should still have a /n */
			fprintf(fp, "%s %s %s %c %s %c %s %s %s\n",
					s->data[x][y].name, 
					s->data[x][y].hex, 
					s->data[x][y].uwp, 
					s->data[x][y].bases[0], 
					s->data[x][y].codes, 
					s->data[x][y].zone[0], 
					s->data[x][y].pbg, 
					s->data[x][y].alleg, 
					s->data[x][y].stars);
			count++;
		}
	}

	return(count);
}

