/*
 * File:      	hardtimes.h
 * Purpose:   	apply hardtimes (and others) to sector(s)
 * Author:		Mark A. Nordstrand
 * Created:	
 * Updated:	
 * Copyright:	LGPL
Traveller is a registered trademark of Far Future Enterprises.
Portions based upon material Copyright 1977-2002 Far Future Enterprises.
 */

/* rcsid[] = "$RCSfile: hardtimes.h,v $ $Revision: 1.2 $ $Author: man $ $Date: 2002/06/05 04:51:07 $" */

#ifndef HARDTIMES_H
#define HARDTIMES_H

#include "str_util.h"
#include "d_sect.h"

typedef enum {
	HTM_HARD_TIMES=0,
	HTM_COLLAPSE,
	HTM_REBUILD
} HARD_TIMES_METHOD;

typedef enum {
	HTA_SAFE=0,
	HTA_FRONTIER,
	HTA_OUTLANDS,
	HTA_WILDS
} HT_AREA;

typedef enum {
	HTW_PEACE=0,
	HTW_WAR,
	HTW_INTENSE,
	HTW_BLACK
} HT_WAR;

class HardTimes 
{
public:
	HardTimes(char *dir);
	~HardTimes() {};

	HT_AREA GetArea(int x, int y);
	HT_WAR GetWar(int x, int y);

private:
	HT_AREA		area[MAX_X_HEX][MAX_Y_HEX];
	HT_WAR		war[MAX_X_HEX][MAX_Y_HEX];
};

#endif

